// Copyright (c) 2022-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SEGMENTED_RADIX_SORT_HPP_
#define ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SEGMENTED_RADIX_SORT_HPP_

#include "../../../config.hpp"
#include "../../../type_traits.hpp"
#include "../../config_types.hpp"
#include "../device_config_helper.hpp"

#include <type_traits>

/* DO NOT EDIT THIS FILE
 * This file is automatically generated by `/scripts/autotune/create_optimization.py`.
 * so most likely you want to edit rocprim/device/device_(algo)_config.hpp
 */

/// \addtogroup primitivesmodule_deviceconfigs
/// @{

BEGIN_ROCPRIM_NAMESPACE

namespace detail
{

template<unsigned int arch, class key_type, typename value_type, class enable = void>
struct default_segmented_radix_sort_config : default_segmented_radix_sort_config_base<6>::type
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1030),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1100),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1200),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx1201),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 4, 256, 5, 32, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 2, 256, 5, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<6,
                                  kernel_config<256, 8>,
                                  typename std::conditional<1,
                                                            WarpSortConfig<4, 4, 256, 5, 8, 8, 256>,
                                                            DisabledWarpSortConfig>::type,
                                  1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 4, 256, 5, 32, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          6,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 2, 256, 5, 16, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx906),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx908),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx90a),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<128, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 8, 256, 5, 16, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<16, 8, 256, 5, 32, 16, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::unknown),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          7,
          kernel_config<256, 17>,
          typename std::conditional<1,
                                    WarpSortConfig<32, 4, 256, 3000, 32, 4, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = double, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = float, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::half, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = rocprim::int128_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 16)
                      && (sizeof(key_type) > 8)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int64_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 8)
                      && (sizeof(key_type) > 4)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 4)
                      && (sizeof(key_type) > 2)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 16)
                      && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 8)
                      && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 4)
                      && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 2)
                      && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1) && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = short, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 2)
                      && (sizeof(key_type) > 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 16>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = rocprim::int128_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 16) && (sizeof(value_type) > 8))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 4>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int64_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 8) && (sizeof(value_type) > 4))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 4) && (sizeof(value_type) > 2))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = short
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 2) && (sizeof(value_type) > 1))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = int8_t
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (sizeof(value_type) <= 1)
                      && (!std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

// Based on key_type = int8_t, value_type = empty_type
template<class key_type, typename value_type>
struct default_segmented_radix_sort_config<
    static_cast<unsigned int>(target_arch::gfx942),
    key_type,
    value_type,
    std::enable_if_t<(!bool(rocprim::is_floating_point<key_type>::value) && (sizeof(key_type) <= 1)
                      && (std::is_same<value_type, rocprim::empty_type>::value))>>
    : segmented_radix_sort_config<
          8,
          kernel_config<256, 8>,
          typename std::conditional<1,
                                    WarpSortConfig<8, 4, 256, 64, 16, 8, 256>,
                                    DisabledWarpSortConfig>::type,
          1>
{};

} // end namespace detail

END_ROCPRIM_NAMESPACE

/// @}
// end of group primitivesmodule_deviceconfigs

#endif // ROCPRIM_DEVICE_DETAIL_CONFIG_DEVICE_SEGMENTED_RADIX_SORT_HPP_
