/*
   Copyright (c) 2025 Advanced Micro Devices, Inc. All rights reserved.
   Permission is hereby granted, free of charge, to any person obtaining a copy
   of this software and associated documentation files (the "Software"), to deal
   in the Software without restriction, including without limitation the rights
   to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
   copies of the Software, and to permit persons to whom the Software is
   furnished to do so, subject to the following conditions:
   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.
   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANNTY OF ANY KIND, EXPRESS OR
   IMPLIED, INNCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANNY CLAIM, DAMAGES OR OTHER
   LIABILITY, WHETHER INN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
   OUT OF OR INN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
   THE SOFTWARE.
 */

/* Test Case Description:
   The test will stress memory pool with many allocations and destructions.
   It will measure execution time and monitor memory reserved by the pool.
   Can be executed on devices with > 30MiB of free device memory
*/

#include <hip_test_common.hh>
#include <performance_common.hh>
#include <cstdio>
#include <algorithm>
#include <chrono>
#include <iostream>
#include <limits>

#define HIP_CHECK_LT(func)                                                                         \
  localError = func;                                                                               \
  if (localError != hipSuccess) {                                                                  \
    return localError;                                                                             \
  }

hipError_t Test() {
  hipMemPool_t pool;
  hipError_t localError;
  int device = 0;
  HIP_CHECK_LT(hipSetDevice(device));
  HIP_CHECK_LT(hipDeviceGetDefaultMemPool(&pool, device));

  std::size_t free{};
  std::size_t total{};
  HIP_CHECK_LT(hipMemGetInfo(&free, &total));
  if (free < 30_GB) {
    std::cout << "Free memory is too low: " << free / 1_MB << " MiB" << std::endl;
    HipTest::HIP_SKIP_TEST("HIP test requires >30 GiB of free memory!");
    return hipSuccess;
  }

  uint64_t threshold = std::numeric_limits<uint64_t>::max();
  HIP_CHECK_LT(hipMemPoolSetAttribute(pool, hipMemPoolAttrReleaseThreshold, &threshold));

  hipStream_t stream = nullptr;

  void* ptr_0x7f0345a00000;
  void* ptr_0x7f0348000000;
  void* ptr_0x7f0352800000;
  void* ptr_0x7f0354800000;
  void* ptr_0x7f0356e00000;
  void* ptr_0x7f0359400000;
  void* ptr_0x7f035ae00000;
  void* ptr_0x7f0361000000;
  void* ptr_0x7f0363400000;
  void* ptr_0x7f0363c00000;
  void* ptr_0x7f0365c00000;
  void* ptr_0x7f0367a00000;
  void* ptr_0x7f036a000000;
  void* ptr_0x7f036ba00000;
  void* ptr_0x7f036c200000;
  void* ptr_0x7f036c600000;
  void* ptr_0x7f0372400000;
  void* ptr_0x7f0374000000;
  void* ptr_0x7f0374800000;
  void* ptr_0x7f0376800000;
  void* ptr_0x7f037c600000;
  void* ptr_0x7f037ce00000;
  void* ptr_0x7f037da00000;
  void* ptr_0x7f0380a00000;
  void* ptr_0x7f0383000000;
  void* ptr_0x7f0384e00000;
  void* ptr_0x7f0385400000;
  void* ptr_0x7f038d200000;
  void* ptr_0x7f038da00000;
  void* ptr_0x7f038e600000;
  void* ptr_0x7f0391600000;
  void* ptr_0x7f0391800000;
  void* ptr_0x7f0391e00000;
  void* ptr_0x7f0396000000;
  void* ptr_0x7f0396200000;
  void* ptr_0x7f0399600000;
  void* ptr_0x7f039da00000;
  void* ptr_0x7f039de00000;
  void* ptr_0x7f039e200000;
  void* ptr_0x7f039e600000;
  void* ptr_0x7f03a1e00000;
  void* ptr_0x7f03a2a00000;
  void* ptr_0x7f03a2c00000;
  void* ptr_0x7f03a6200000;
  void* ptr_0x7f03a6e00000;
  void* ptr_0x7f03aa600000;
  void* ptr_0x7f03aaa00000;
  void* ptr_0x7f03aea00000;
  void* ptr_0x7f03aee00000;
  void* ptr_0x7f03af200000;
  void* ptr_0x7f03af600000;
  void* ptr_0x7f03b2e00000;
  void* ptr_0x7f03b3200000;
  void* ptr_0x7f03b3600000;
  void* ptr_0x7f03b3800000;
  void* ptr_0x7f03b7200000;
  void* ptr_0x7f03b7600000;
  void* ptr_0x7f03bb600000;
  void* ptr_0x7f03bba00000;
  void* ptr_0x7f03bbe00000;
  void* ptr_0x7f03bfa00000;
  void* ptr_0x7f03bfe00000;
  void* ptr_0x7f03c3a00000;
  void* ptr_0x7f03c3e00000;
  void* ptr_0x7f03c4200000;
  void* ptr_0x7f03c8200000;
  void* ptr_0x7f03c8600000;
  void* ptr_0x7f03cc600000;
  void* ptr_0x7f03d0a00000;
  void* ptr_0x7f03d4e00000;
  void* ptr_0x7f04be000000;
  void* ptr_0x7f04c1000000;
  void* ptr_0x7f04c9400000;
  void* ptr_0x7f04cb200000;
  void* ptr_0x7f04cd400000;
  void* ptr_0x7f04cd800000;
  void* ptr_0x7f04d1800000;
  void* ptr_0x7f04d5c00000;
  void* ptr_0x7f04d9600000;
  void* ptr_0x7f04da000000;
  void* ptr_0x7f04dbc00000;
  void* ptr_0x7f04e0800000;
  void* ptr_0x7f04e8000000;
  void* ptr_0x7f04e8400000;
  void* ptr_0x7f04eb000000;
  void* ptr_0x7f04ec400000;
  void* ptr_0x7f04ed000000;
  void* ptr_0x7f04f0800000;
  void* ptr_0x7f04f3600000;
  void* ptr_0x7f04f9800000;
  void* ptr_0x7f04fae00000;
  void* ptr_0x7f04fbc00000;
  void* ptr_0x7f0504200000;
  void* ptr_0x7f0504e00000;
  void* ptr_0x7f0507600000;
  void* ptr_0x7f050b600000;
  void* ptr_0x7f050c800000;
  void* ptr_0x7f050fa00000;
  void* ptr_0x7f0513e00000;
  void* ptr_0x7f0514e00000;
  void* ptr_0x7f0517a00000;
  void* ptr_0x7f0517e00000;
  void* ptr_0x7f0519200000;
  void* ptr_0x7f051be00000;
  void* ptr_0x7f051c200000;
  void* ptr_0x7f051d600000;
  void* ptr_0x7f0520200000;
  void* ptr_0x7f0520600000;
  void* ptr_0x7f0525a00000;
  void* ptr_0x7f0526400000;
  void* ptr_0x7f0528600000;
  void* ptr_0x7f0528a00000;
  void* ptr_0x7f0529e00000;
  void* ptr_0x7f052a000000;
  void* ptr_0x7f052a800000;
  void* ptr_0x7f052ca00000;
  void* ptr_0x7f052ce00000;
  void* ptr_0x7f0530e00000;
  void* ptr_0x7f0531e00000;
  void* ptr_0x7f0535200000;
  void* ptr_0x7f0536200000;
  void* ptr_0x7f0536600000;
  void* ptr_0x7f0539200000;
  void* ptr_0x7f0539600000;
  void* ptr_0x7f053a600000;
  void* ptr_0x7f053d600000;
  void* ptr_0x7f053ea00000;
  void* ptr_0x7f0541a00000;
  void* ptr_0x7f0542e00000;
  void* ptr_0x7f054f600000;
  void* ptr_0x7f0581c00000;
  void* ptr_0x7f0586000000;
  void* ptr_0x7f0586600000;
  void* ptr_0x7f0587a00000;
  void* ptr_0x7f058aa00000;
  void* ptr_0x7f0597200000;
  void* ptr_0x7f05a3a00000;
  void* ptr_0x7f05b0000000;
  void* ptr_0x7f05b0200000;
  void* ptr_0x7f05b4400000;
  void* ptr_0x7f05b8600000;
  void* ptr_0x7f05bca00000;
  void* ptr_0x7f05c5000000;
  void* ptr_0x7f05cd600000;
  void* ptr_0x7f05d1a00000;
  void* ptr_0x7f05d5e00000;
  void* ptr_0x7f05da200000;
  void* ptr_0x7f05de600000;
  void* ptr_0x7f0630400000;
  void* ptr_0x7f0682200000;
  void* ptr_0x7f0683a00000;
  void* ptr_0x7f0687e00000;
  void* ptr_0x7f068e800000;
  void* ptr_0x7f0696c00000;
  void* ptr_0x7f069b000000;
  void* ptr_0x7f06a7800000;
  void* ptr_0x7f06abc00000;
  void* ptr_0x7f06b0000000;
  void* ptr_0x7f06b4400000;
  void* ptr_0x7f06f9200000;
  void* ptr_0x7f06fb000000;
  void* ptr_0x7f06ff400000;
  void* ptr_0x7f0703800000;
  void* ptr_0x7f0703c00000;
  void* ptr_0x7f0707c00000;
  void* ptr_0x7f0708000000;
  void* ptr_0x7f070c000000;
  void* ptr_0x7f0710400000;
  void* ptr_0x7f0714800000;
  void* ptr_0x7f07b8000000;
  void* ptr_0x7f0809e00000;
  void* ptr_0x7f080b200000;
  void* ptr_0x7f080d400000;
  void* ptr_0x7f080d800000;
  void* ptr_0x7f080da00000;
  void* ptr_0x7f0811800000;
  void* ptr_0x7f0815800000;
  void* ptr_0x7f0815c00000;
  void* ptr_0x7f0819c00000;
  void* ptr_0x7f081a000000;
  void* ptr_0x7f081e000000;
  void* ptr_0x7f0822400000;
  void* ptr_0x7f0826800000;
  void* ptr_0x7f0834400000;
  void* ptr_0x7f0836600000;
  void* ptr_0x7f083aa00000;
  void* ptr_0x7f083ee00000;
  void* ptr_0x7f0876e00000;
  void* ptr_0x7f0883c00000;
  void* ptr_0x7f0884000000;
  void* ptr_0x7f0887200000;
  void* ptr_0x7f0887400000;
  void* ptr_0x7f0887c00000;
  void* ptr_0x7f0888000000;
  void* ptr_0x7f0888400000;
  void* ptr_0x7f088c400000;
  void* ptr_0x7f088c800000;
  void* ptr_0x7f0890800000;
  void* ptr_0x7f0890a00000;
  void* ptr_0x7f0894c00000;
  void* ptr_0x7f0907000000;
  void* ptr_0x7f090b400000;
  void* ptr_0x7f0926a00000;
  void* ptr_0x7f092ae00000;
  void* ptr_0x7f092f200000;
  void* ptr_0x7f0933600000;
  void* ptr_0x7f0937a00000;
  void* ptr_0x7f093be00000;
  void* ptr_0x7f0948600000;
  void* ptr_0x7f094ca00000;
  void* ptr_0x7f0950a00000;
  void* ptr_0x7f0954e00000;
  void* ptr_0x7f0959200000;
  void* ptr_0x7f09bda00000;
  void* ptr_0x7f09c6200000;
  void* ptr_0x7f09ca600000;
  void* ptr_0x7f09ca800000;
  void* ptr_0x7f09cec00000;
  void* ptr_0x7f09d7200000;
  void* ptr_0x7f09dae00000;
  void* ptr_0x7f09db200000;
  void* ptr_0x7f09e3400000;
  void* ptr_0x7f09eba00000;
  void* ptr_0x7f09f4000000;
  void* ptr_0x7f0a2aa00000;
  void* ptr_0x7f0a7ee00000;
  void* ptr_0x7f0ab5800000;
  void* ptr_0x7f0bc9400000;
  void* ptr_0x7f0bc9c00000;
  void* ptr_0x7f0bca400000;
  void* ptr_0x7f0bcac00000;
  void* ptr_0x7f0bcae00000;
  void* ptr_0x7f0bcb400000;
  void* ptr_0x7f0bcb800000;
  void* ptr_0x7f0bcf800000;
  void* ptr_0x7f0bd3c00000;
  void* ptr_0x7f0bd3e00000;
  void* ptr_0x7f0c37e00000;
  void* ptr_0x7f0c38400000;
  void* ptr_0x7f0c38a00000;
  void* ptr_0x7f0c39000000;
  void* ptr_0x7f0c39400000;
  void* ptr_0x7f0c39800000;
  void* ptr_0x7f0c39c00000;
  void* ptr_0x7f0c3a000000;
  void* ptr_0x7f0cdb600000;
  void* ptr_0x7f0cdc800000;
  void* ptr_0x7f0cdd000000;
  void* ptr_0x7f0cdd200000;
  void* ptr_0x7f0ce1400000;
  void* ptr_0x7f0ce5800000;
  void* ptr_0x7f0cede00000;
  void* ptr_0x7f0cee000000;
  void* ptr_0x7f0cee400000;
  void* ptr_0x7f0ceea00000;
  void* ptr_0x7f0cf2000000;
  void* ptr_0x7f0cf6400000;
  void* ptr_0x7f0d2ce00000;
  void* ptr_0x7f0d9a000000;
  void* ptr_0x7f0dd4e00000;
  void* ptr_0x7f0dd6200000;
  void* ptr_0x7f0dd6400000;
  void* ptr_0x7f0dd7000000;
  void* ptr_0x7f0dda600000;
  void* ptr_0x7f0ddb400000;
  void* ptr_0x7f0dde800000;
  void* ptr_0x7f0ddea00000;
  void* ptr_0x7f0ddec00000;
  void* ptr_0x7f0ddf000000;
  void* ptr_0x7f0de0000000;
  void* ptr_0x7f0de2c00000;
  void* ptr_0x7f0de3400000;
  void* ptr_0x7f0de3a00000;
  void* ptr_0x7f0de6000000;
  void* ptr_0x7f0de6a00000;
  void* ptr_0x7f0de7000000;
  void* ptr_0x7f0de7800000;
  void* ptr_0x7f0de7c00000;
  void* ptr_0x7f0dec000000;
  void* ptr_0x7f0dec400000;
  void* ptr_0x7f0deca00000;
  void* ptr_0x7f0dece00000;
  void* ptr_0x7f0ded200000;
  void* ptr_0x7f0deda00000;
  void* ptr_0x7f0dee000000;
  void* ptr_0x7f0dee600000;
  void* ptr_0x7f0deea00000;
  void* ptr_0x7f0deee00000;
  void* ptr_0x7f0def000000;
  void* ptr_0x7f0def400000;
  void* ptr_0x7f0def800000;
  void* ptr_0x7f0defc00000;
  void* ptr_0x7f0df0000000;
  void* ptr_0x7f0df0a00000;
  void* ptr_0x7f0df1200000;
  void* ptr_0x7f0df1400000;
  void* ptr_0x7f0df7600000;
  void* ptr_0x7f0df7e00000;
  void* ptr_0x7f0df9800000;
  void* ptr_0x7f0e0ae00000;
  void* ptr_0x7f0e0b000000;
  void* ptr_0x7f0e0b400000;
  void* ptr_0x7f0e0b800000;
  void* ptr_0x7f0e0bc00000;
  void* ptr_0x7f0e0e600000;
  void* ptr_0x7f0e0ea00000;
  void* ptr_0x7f0e13401000;

  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0ae00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  const auto start = std::chrono::steady_clock::now();
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0e0ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df1200000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ab5800000, 2287342920, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0d2ce00000, 913273928, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0a2aa00000, 2326316628, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cf6400000, 913273928, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e13401000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0ea00000, 4106828, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0e600000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0bc00000, 2305148, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0b800000, 1315184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0b400000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df0a00000, 4725080, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0b000000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dec000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddb400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd7000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dd7000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bd3e00000, 913273928, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cede00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd7000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dd7000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09bda00000, 1826547856, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce5800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd7000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dd7000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0876e00000, 5479643568, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cdd200000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd7000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dd7000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0809e00000, 1826547856, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f07b8000000, 1369910892, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0714800000, 2739821784, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c3a000000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bcb800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7800000, 1790740, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de7800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddb400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0bd3e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0cede00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09bda00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0cdd200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0809e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce5800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0876e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dec000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dec000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dec000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7800000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df0000000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de7800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7800000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def800000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de7800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7800000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def400000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deee00000, 4123152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de7800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7800000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deea00000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee600000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de7800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7800000, 2061576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee000000, 4123152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0df0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0def800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0deea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dee600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0def400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0deee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddf000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddf000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddf000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddf000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddf000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deee00000, 2415144, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def400000, 1207572, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deda00000, 2415144, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0deee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddf000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddf000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddf000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddf000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee600000, 1334952, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deea00000, 1334952, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dee600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddf000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de3400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddf000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee600000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def800000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dee600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee600000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df0000000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dee600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee600000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def000000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ded200000, 4775880, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dee600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dee600000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dece00000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deca00000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dee600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dec400000, 2387940, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de7000000, 4775880, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0def800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0df0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dece00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0deca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0def000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ded200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddf000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de2c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dde800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de2c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dde800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de2c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dde800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de2c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dde800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0df1200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0bcb800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def000000, 1790740, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0def000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ab5800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0a2aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0d2ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0e0ea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0e13401000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0e0bc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0e0b800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0df0a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0e0b400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddea00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd6400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cede00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce5800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bd3c00000, 915751160, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0cede00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0dd6400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dda600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ab5800000, 2287342920, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0a7ee00000, 913273928, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09f4000000, 2326316628, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cede00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cdd200000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bcf800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09db200000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bcb400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0bcf800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09db200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09eba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bcf800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09e3400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09ca600000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09c6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09ca600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09dae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dd4e00000, 17231394, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ddea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0cede00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0cdd200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09eba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09e3400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09dae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df9800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0df9800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df7e00000, 95305955, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e13401000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0ea00000, 4106828, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0bc00000, 2305148, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0b400000, 1315184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0e0b800000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df7600000, 4725080, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0959200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cf2000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cdd000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09d7200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09cec00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f09d7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def000000, 1374384, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0deca00000, 1591960, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f094ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09d7200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f09ca800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0948600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f094ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0954e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0dece00000, 2061576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ded200000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0df0000000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de6a00000, 2387940, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de6000000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f093be00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0950a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0937a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0933600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0937a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0933600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0937a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0933600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0933600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0933600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f092f200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f092f200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f092f200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0def800000, 2061576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0de0000000, 2387940, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f092ae00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0926a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f090b400000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0907000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f088c400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0888000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0883c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0834400000, 245549876, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0826800000, 228318482, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ddec00000, 17231394, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0834400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06abc00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06a7800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f069b000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ceea00000, 17231394, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0696c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0696c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0682200000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0630400000, 1369910892, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05de600000, 1369910892, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0d9a000000, 4123152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cee400000, 2415144, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cee000000, 1334952, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cdc800000, 4775880, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05da200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0cdb600000, 14732472, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c39c00000, 2061576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c39800000, 2061576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c39400000, 1207572, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c39000000, 1207572, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c38a00000, 2387940, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c38400000, 2387940, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05d5e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05d1a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05c5000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05bca00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05b8600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05b8600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0586000000, 913273928, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05c5000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05c5000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0581c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0581c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f054f600000, 913273928, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05bca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0586000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05bca00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05b4400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bcac00000, 4954464, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05bca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05bca00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bca400000, 4954464, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0bcac00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0c39c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0c39800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0c39400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0c39000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0c38a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0c38400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0682200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f068e800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c38a00000, 4123152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c38400000, 4123152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c37e00000, 2415144, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bcae00000, 2415144, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c39000000, 1334952, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0c39400000, 1334952, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bc9c00000, 4775880, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0bc9400000, 4775880, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05b0200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05a3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0597200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05a3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0597200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05a3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0597200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f058aa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0542e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f058aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0542e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f058aa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0542e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0536600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0529e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0536600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0529e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0687e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0683a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0586600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053ea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053a600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0683a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0586600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053ea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053a600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0683a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0586600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053ea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053a600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0536200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0586600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053ea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053a600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0536200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0586600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053ea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053a600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0536200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0531e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0586600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053ea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053a600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0536200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0531e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0586600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a000000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0504e00000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0504e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0536600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0529e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f051d600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f051d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0529e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0529e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0525a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0519200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0514e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f050c800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0504200000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04fbc00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04f3600000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04eb000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f050c800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0504200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04fbc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04f3600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04eb000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04f9800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04ed000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04e0800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04ed000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04e0800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ded200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0df0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0de6000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04ed000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04ed000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05b0200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0597200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0542e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f088c400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0888000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0883c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f088c800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0888400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0884000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0822400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081e000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0819c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0884000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0822400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081e000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0819c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06abc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06a7800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0708000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0708000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f068e800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05a3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f058aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0687e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0683a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0884000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0710400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f070c000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0707c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0703800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0884000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d9600000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04be000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0884000000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06ff400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06fb000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0710400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f070c000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0707c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0703800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d9600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04be000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0884000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0708000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04e8400000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04dbc00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04e8400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04dbc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0884000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0703c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04f0800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04ec400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04e8000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0703c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04f0800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04ec400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04e8000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06ff400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06fb000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0708000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0884000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0529e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0525a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0536600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f088c800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0888400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0519200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0514e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04f9800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f088c400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0888000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0883c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0520600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0513e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0520600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0513e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0520600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f051c200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0517e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f05cd600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f051c200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0517e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0513e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0507600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04fae00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0507600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04fae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f05cd600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f050fa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f050b600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f050b600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f088c400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0888000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0883c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f088c400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0888000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0883c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f088c400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0888000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0883c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0520600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0586600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0513e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0520200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d4e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d4e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d4e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c8600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bbe00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c8600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bbe00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f051be00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0517a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d0a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03cc600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c8200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0517a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d0a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03cc600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c8200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0517a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d0a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03cc600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c8200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bfa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d0a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03cc600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c8200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bfa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d0a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03cc600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c8200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bfa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bb600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03cc600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c8200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bfa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bb600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03cc600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b3800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038e600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b3800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038e600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bfe00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b3600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b3600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b3600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03af200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a2a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0396000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038da00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0385400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037ce00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0396000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0385400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0383000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0376800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0376800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0376800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0376800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0520200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d4e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0367a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0367a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f051be00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0517a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d0a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b3600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03af200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bfe00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a2a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0383000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d4e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d4e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03cc600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d4e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c8600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d4e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c8600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03d4e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c8600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bbe00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03af600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bbe00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03af600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c4200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bfe00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bba00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b3200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c4200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bfe00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b3200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c4200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bfe00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bba00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b3200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bfe00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b3200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bfe00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bba00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b3200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b3200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03bba00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a2c00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037da00000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a2c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03af200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a2a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0396200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0396200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a2a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a2a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0385400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037ce00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c200000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363c00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0385400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0372400000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0365c00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0359400000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0365c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0359400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0365c00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0365c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c8600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0356e00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0356e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03d4e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c4200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bfe00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a2a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03af200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0372400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03bba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0ce1400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0ce1400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f053d600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b7200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aaa00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039e200000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aaa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039e200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03b2e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aea00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a6200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03a1e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039da00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0399600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a6200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03a1e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039da00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0399600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03aa600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391800000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036c600000, 620330184, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f039de00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0384e00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0384e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0391600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f038d200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0380a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f037c600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0374000000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f036ba00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0363400000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f035ae00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0352800000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0374000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f036ba00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0363400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f035ae00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0352800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0361000000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0348000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0348000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887400000, 6184728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 2002428, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887200000, 7163820, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1141956, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0354800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0354800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b7200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f081a000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0345a00000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f053d600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0345a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03b2e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aea00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052a800000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cb200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0811800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080d400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0526400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052a800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cb200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0815c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0815c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0811800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080d400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0526400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0391600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f038d200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f039de00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f081a000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0380a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f037c600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0361000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0894c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0539600000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0535200000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0530e00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ca00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0535200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0530e00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ca00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f052ce00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04da000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b0000000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d5c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04d1800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d5c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04d1800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04cd800000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c1000000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f03c3a00000, 206776728, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c1000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03c3a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0528a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f04c9400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04c9400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0539600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0887c00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083ee00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f083aa00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0836600000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080b200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06f9200000, 456636964, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890800000, 68925580, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f06b4400000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0587a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0541a00000, 68925576, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0541a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0887c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083ee00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f083aa00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0836600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080b200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06f9200000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b4400000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04da000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f06b0000000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0528a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0587a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0894c00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f03aa600000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f052ce00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f04cd800000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f080da00000, 413553456, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0890a00000, 137851152, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipMallocAsync(&ptr_0x7f0defc00000, 1081220, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0defc00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  const auto end = std::chrono::steady_clock::now();
  const std::chrono::duration<double> elapsed_seconds{end - start};
  std::cout << "time(ms): " << (elapsed_seconds.count() * 1000) << std::endl;

  HIP_CHECK_LT(hipMemPoolGetAttribute(pool, hipMemPoolAttrReleaseThreshold, &threshold));
  std::cout << "Threashold (MiB): " << threshold / 1_MB << std::endl;
  HIP_CHECK_LT(hipMemPoolGetAttribute(pool, hipMemPoolAttrReservedMemCurrent, &threshold));
  std::cout << "Reserved current(MiB): " << threshold / 1_MB << std::endl;

  HIP_CHECK_LT(hipMemPoolGetAttribute(pool, hipMemPoolAttrUsedMemCurrent, &threshold));
  std::cout << "Used current (MiB): " << threshold / 1_MB << std::endl;
  HIP_CHECK_LT(hipMemGetInfo(&free, &total));
  std::cout << static_cast<uint32_t>((total - free) / 1_MB) << " MiB used out of "
            << static_cast<uint32_t>(total / 1_MB) << " MiB" << std::endl;
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f080da00000, stream));
  HIP_CHECK_LT(hipFreeAsync(ptr_0x7f0890a00000, stream));
  HIP_CHECK_LT(hipStreamSynchronize(stream));
  return hipSuccess;
}


TEST_CASE("Unit_hipMemPoolMaxAlloc") { HIP_CHECK(Test()); }
