/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.inline.completion.frontend.split;

import com.intellij.codeInsight.inline.completion.InlineCompletionRemDevUtils;
import com.intellij.codeInsight.inline.completion.RemDevAggregatorInlineCompletionProvider;
import com.intellij.codeInsight.inline.completion.session.InlineCompletionSession;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.jetbrains.rd.ide.model.ActionCallStrategyKind;
import com.jetbrains.rdclient.editorActions.cwm.FrontendEditorActionHandlerStrategyCustomizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\u0010\u001a\u00020\u0005H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/inline/completion/frontend/split/InlineCompletionActionHandlerStrategyCustomizer;", "Lcom/jetbrains/rdclient/editorActions/cwm/FrontendEditorActionHandlerStrategyCustomizer;", "<init>", "()V", "getCustomStrategy", "Lcom/jetbrains/rd/ide/model/ActionCallStrategyKind;", "actionId", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isInlineCompletionAction", "", "currentStrategyKind", "intellij.platform.inline.completion.frontend.split"})
public final class InlineCompletionActionHandlerStrategyCustomizer
implements FrontendEditorActionHandlerStrategyCustomizer {
    @Nullable
    public ActionCallStrategyKind getCustomStrategy(@NotNull String actionId, @NotNull Editor editor, @Nullable Caret caret, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        boolean isRhizome = InlineCompletionRemDevUtils.INSTANCE.isRhizomeUsed();
        if (Intrinsics.areEqual((Object)actionId, (Object)"CallInlineCompletionAction") && isRhizome) {
            return ActionCallStrategyKind.FrontendOnly;
        }
        if (this.isInlineCompletionAction(actionId)) {
            boolean bl;
            Caret caret2 = caret;
            if (caret2 == null) {
                Caret caret3 = editor.getCaretModel().getCurrentCaret();
                caret2 = caret3;
                Intrinsics.checkNotNullExpressionValue((Object)caret3, (String)"getCurrentCaret(...)");
            }
            Caret caret4 = caret2;
            InlineCompletionSession session = InlineCompletionSession.Companion.getOrNull(editor);
            if (isRhizome && session != null && !(session.getProvider() instanceof RemDevAggregatorInlineCompletionProvider)) {
                return ActionCallStrategyKind.FrontendOnly;
            }
            InlineCompletionSession inlineCompletionSession = session;
            if (inlineCompletionSession != null && (inlineCompletionSession = inlineCompletionSession.getContext()) != null) {
                Integer n = inlineCompletionSession.startOffset();
                int n2 = caret4.getOffset();
                bl = n != null && n == n2;
            } else {
                bl = false;
            }
            if (bl) {
                return this.currentStrategyKind();
            }
        }
        return null;
    }

    private final boolean isInlineCompletionAction(String actionId) {
        return Intrinsics.areEqual((Object)actionId, (Object)"InsertInlineCompletionAction") || Intrinsics.areEqual((Object)actionId, (Object)"InsertInlineCompletionLineAction") || Intrinsics.areEqual((Object)actionId, (Object)"InsertInlineCompletionWordAction") || Intrinsics.areEqual((Object)actionId, (Object)"NextInlineCompletionSuggestionAction") || Intrinsics.areEqual((Object)actionId, (Object)"PrevInlineCompletionSuggestionAction");
    }

    private final ActionCallStrategyKind currentStrategyKind() {
        return InlineCompletionRemDevUtils.INSTANCE.isRhizomeUsed() ? ActionCallStrategyKind.FrontendFirst : ActionCallStrategyKind.FrontendOnly;
    }
}

