/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.collaboration.api.util.LinkHttpHeaderValue;
import com.intellij.platform.templates.github.GithubTagInfo;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiContentHelper;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestOperation;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHCommitsCompareResult;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubBranch;
import org.jetbrains.plugins.github.api.data.GithubContent;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.data.GithubIssue;
import org.jetbrains.plugins.github.api.data.GithubIssueCommentWithHtml;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubOrg;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.api.data.GithubResponsePage;
import org.jetbrains.plugins.github.api.data.GithubSearchedIssue;
import org.jetbrains.plugins.github.api.data.GithubUser;
import org.jetbrains.plugins.github.api.data.GithubUserWithPermissions;
import org.jetbrains.plugins.github.api.data.commit.GHCommitFile;
import org.jetbrains.plugins.github.api.data.commit.GHCommitFiles;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestRestIdOnly;
import org.jetbrains.plugins.github.api.data.request.Affiliation;
import org.jetbrains.plugins.github.api.data.request.GithubAssigneesCollectionRequest;
import org.jetbrains.plugins.github.api.data.request.GithubChangeIssueStateRequest;
import org.jetbrains.plugins.github.api.data.request.GithubCreateIssueCommentRequest;
import org.jetbrains.plugins.github.api.data.request.GithubCreateIssueRequest;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.api.data.request.GithubLabelsCollectionRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullRequestMergeRebaseRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullRequestMergeRequest;
import org.jetbrains.plugins.github.api.data.request.GithubPullUpdateRequest;
import org.jetbrains.plugins.github.api.data.request.GithubRepoRequest;
import org.jetbrains.plugins.github.api.data.request.GithubRequestPagination;
import org.jetbrains.plugins.github.api.data.request.GithubReviewersCollectionRequest;
import org.jetbrains.plugins.github.api.data.request.Type;
import org.jetbrains.plugins.github.api.data.request.Visibility;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.api.util.GithubApiSearchQueryBuilder;
import org.jetbrains.plugins.github.api.util.GithubApiUrlQueryBuilder;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.GHPRSearchQuery;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0007\u0013\u0014\u0015\u0016\u0017\u0018\u0019B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002J)\u0010\t\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\bH\u0002\u00a2\u0006\u0002\u0010\u0011J'\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0010\"\u00020\b\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests;", "", "<init>", "()V", "getBytes", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "", "url", "", "getUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "suffix", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "suffixes", "", "(Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;[Ljava/lang/String;)Ljava/lang/String;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;[Ljava/lang/String;)Ljava/lang/String;", "CurrentUser", "Organisations", "Repos", "Gists", "Search", "Emojis", "Entity", "intellij.vcs.github"})
public final class GithubApiRequests {
    @NotNull
    public static final GithubApiRequests INSTANCE = new GithubApiRequests();

    private GithubApiRequests() {
    }

    @JvmStatic
    @NotNull
    public static final GithubApiRequest<byte[]> getBytes(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new GithubApiRequest.Get<byte[]>(url){

            public byte[] extractResult(GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                T t = response.handleBody(getBytes.1::extractResult$lambda$0);
                Intrinsics.checkNotNullExpressionValue(t, (String)"handleBody(...)");
                return (byte[])t;
            }

            private static final byte[] extractResult$lambda$0(InputStream it) {
                return it.readAllBytes();
            }
        };
    }

    private final String getUrl(GithubServerPath server, String suffix) {
        return server.toApiUrl() + suffix;
    }

    private final String getUrl(GHRepositoryCoordinates repository, String ... suffixes) {
        GithubServerPath githubServerPath = repository.getServerPath();
        SpreadBuilder spreadBuilder = new SpreadBuilder(4);
        spreadBuilder.add((Object)Repos.INSTANCE.getUrlSuffix());
        spreadBuilder.add((Object)"/");
        spreadBuilder.add((Object)repository.getRepositoryPath().toString());
        spreadBuilder.addSpread((Object)suffixes);
        return this.getUrl(githubServerPath, (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
    }

    @NotNull
    public final String getUrl(@NotNull GithubServerPath server, String ... suffixes) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)suffixes, (String)"suffixes");
        String string = StringsKt.append((StringBuilder)new StringBuilder(server.toApiUrl()), (String[])Arrays.copyOf(suffixes, suffixes.length)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\nH\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "url", "", "getAvatar", "Ljava/awt/image/BufferedImage;", "Repos", "Orgs", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n67#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser\n*L\n42#1:640,2\n*E\n"})
    public static final class CurrentUser
    extends Entity {
        @NotNull
        public static final CurrentUser INSTANCE = new CurrentUser();

        private CurrentUser() {
            super("/user");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthenticatedUser> get(@NotNull GithubServerPath server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return CurrentUser.get(INSTANCE.getUrl(server, CurrentUser.INSTANCE.getUrlSuffix()));
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubAuthenticatedUser> get(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GithubAuthenticatedUser>(url, GithubAuthenticatedUser.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetAuthenticatedUser).withOperationName("get profile information");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<BufferedImage> getAvatar(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new GithubApiRequest.Get<BufferedImage>(url){

                public BufferedImage extractResult(GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    T t = response.handleBody(getAvatar.1::extractResult$lambda$0);
                    Intrinsics.checkNotNullExpressionValue(t, (String)"handleBody(...)");
                    return (BufferedImage)t;
                }

                private static final BufferedImage extractResult$lambda$0(InputStream it) {
                    Intrinsics.checkNotNull((Object)it);
                    return GithubApiContentHelper.loadImage(it);
                }
            }.withOperation(GithubApiRequestOperation.RestGetAvatar).withOperationName("get profile avatar");
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J&\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Orgs;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubOrg;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Orgs\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n70#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Orgs\n*L\n113#1:640,2\n*E\n"})
        public static final class Orgs
        extends Entity {
            @NotNull
            public static final Orgs INSTANCE = new Orgs();

            private Orgs() {
                super("/orgs");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubOrg> pages(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubOrg>(INSTANCE.get(server, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubOrg>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubOrg>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return ((Orgs)this.receiver).get(p0);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    githubRequestPagination = null;
                }
                return Orgs.pages(githubServerPath, githubRequestPagination);
            }

            @NotNull
            public final GithubApiRequest<GithubResponsePage<GithubOrg>> get(@NotNull GithubServerPath server, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), this.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return this.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(Orgs orgs, GithubServerPath githubServerPath, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    githubRequestPagination = null;
                }
                return orgs.get(githubServerPath, githubRequestPagination);
            }

            @NotNull
            public final GithubApiRequest<GithubResponsePage<GithubOrg>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubOrg>(url, GithubOrg.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetOrganizations).withOperationName("get user organizations");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubOrg> pages(@NotNull GithubServerPath server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Orgs.pages$default(server, null, 2, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007JR\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00140\u00132\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u001c\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J?\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0007\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "type", "Lorg/jetbrains/plugins/github/api/data/request/Type;", "visibility", "Lorg/jetbrains/plugins/github/api/data/request/Visibility;", "affiliations", "", "Lorg/jetbrains/plugins/github/api/data/request/Affiliation;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "", "create", "name", "description", "private", "", "autoInit", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;ZLjava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Repos\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,639:1\n70#2,2:640\n129#3,2:642\n1#4:644\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$CurrentUser$Repos\n*L\n92#1:640,2\n98#1:642,2\n*E\n"})
        public static final class Repos
        extends Entity {
            @NotNull
            public static final Repos INSTANCE = new Repos();

            private Repos() {
                super("/repos");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @Nullable Type type, @Nullable Visibility visibility, @Nullable Set<? extends Affiliation> affiliations, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubRepo>(Repos.get(server, type, visibility, affiliations, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Repos.get(p0);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, Type type, Visibility visibility, Set set, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    type = null;
                }
                if ((n & 4) != 0) {
                    visibility = null;
                }
                if ((n & 8) != 0) {
                    set = null;
                }
                if ((n & 0x10) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.pages(githubServerPath, type, visibility, set, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @Nullable Type type, @Nullable Visibility visibility, @Nullable Set<? extends Affiliation> affiliations, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                if (type != null && (visibility != null || affiliations != null)) {
                    throw new IllegalArgumentException("Param 'type' should not be used together with 'visibility' or 'affiliation'");
                }
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> Repos.get$lambda$0(type, visibility, affiliations, pagination, arg_0)))};
                return Repos.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, Type type, Visibility visibility, Set set, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 2) != 0) {
                    type = null;
                }
                if ((n & 4) != 0) {
                    visibility = null;
                }
                if ((n & 8) != 0) {
                    set = null;
                }
                if ((n & 0x10) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.get(githubServerPath, type, visibility, set, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepositoriesForUser).withOperationName("get user repositories");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String name, @NotNull String description, boolean bl, @Nullable Boolean autoInit) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix()};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubRepoRequest githubRepoRequest = new GithubRepoRequest(name, description, bl, autoInit);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestCreateRepository).withOperationName("create user repository");
            }

            public static /* synthetic */ GithubApiRequest create$default(GithubServerPath githubServerPath, String string, String string2, boolean bl, Boolean bl2, int n, Object object) {
                if ((n & 0x10) != 0) {
                    bl2 = null;
                }
                return Repos.create(githubServerPath, string, string2, bl, bl2);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @Nullable Type type, @Nullable Visibility visibility, @Nullable Set<? extends Affiliation> affiliations) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.pages$default(server, type, visibility, affiliations, null, 16, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @Nullable Type type, @Nullable Visibility visibility) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.pages$default(server, type, visibility, null, null, 24, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @Nullable Type type) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.pages$default(server, type, null, null, null, 28, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.pages$default(server, null, null, null, null, 30, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @Nullable Type type, @Nullable Visibility visibility, @Nullable Set<? extends Affiliation> affiliations) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.get$default(server, type, visibility, affiliations, null, 16, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @Nullable Type type, @Nullable Visibility visibility) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.get$default(server, type, visibility, null, null, 24, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @Nullable Type type) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.get$default(server, type, null, null, null, 28, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return Repos.get$default(server, null, null, null, null, 30, null);
            }

            /*
             * WARNING - void declaration
             */
            private static final Unit get$lambda$0(Type $type, Visibility $visibility, Set $affiliations, GithubRequestPagination $pagination, GithubApiUrlQueryBuilder $this$urlQuery) {
                String string;
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                Type type = $type;
                $this$urlQuery.param("type", type != null ? type.getValue() : null);
                Visibility visibility = $visibility;
                $this$urlQuery.param("visibility", visibility != null ? visibility.getValue() : null);
                GithubApiUrlQueryBuilder githubApiUrlQueryBuilder = $this$urlQuery;
                String string2 = "affiliation";
                Set set = $affiliations;
                if (set != null) {
                    void p0;
                    Set set2 = set;
                    Affiliation.Companion companion = Affiliation.Companion;
                    Set set3 = set2;
                    String string3 = string2;
                    GithubApiUrlQueryBuilder githubApiUrlQueryBuilder2 = githubApiUrlQueryBuilder;
                    boolean bl = false;
                    String string4 = companion.combine((Set<? extends Affiliation>)p0);
                    githubApiUrlQueryBuilder = githubApiUrlQueryBuilder2;
                    string2 = string3;
                    string = string4;
                } else {
                    string = null;
                }
                githubApiUrlQueryBuilder.param(string2, string);
                $this$urlQuery.param($pagination);
                return Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010\f\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Emojis;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "loadNameToUrlMap", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "loadImage", "Ljava/awt/image/BufferedImage;", "url", "intellij.vcs.github"})
    public static final class Emojis
    extends Entity {
        @NotNull
        public static final Emojis INSTANCE = new Emojis();

        private Emojis() {
            super("/emojis");
        }

        @NotNull
        public final GithubApiRequest<Map<String, String>> loadNameToUrlMap(@NotNull GithubServerPath server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            return new GithubApiRequest.Get.JsonMap(INSTANCE.getUrl(server, this.getUrlSuffix()), null, 2, null).withOperation(GithubApiRequestOperation.RestGetEmojiMap).withOperationName("load emoji name-to-url map");
        }

        @NotNull
        public final GithubApiRequest<BufferedImage> loadImage(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return new GithubApiRequest.Get<BufferedImage>(url){

                public BufferedImage extractResult(GithubApiResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    return (BufferedImage)response.handleBody(GithubApiContentHelper::loadImage);
                }
            }.withOperation(GithubApiRequestOperation.RestGetEmojiImage).withOperationName("load emoji image");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "", "urlSuffix", "", "<init>", "(Ljava/lang/String;)V", "getUrlSuffix", "()Ljava/lang/String;", "intellij.vcs.github"})
    public static abstract class Entity {
        @NotNull
        private final String urlSuffix;

        public Entity(@NotNull String urlSuffix) {
            Intrinsics.checkNotNullParameter((Object)urlSuffix, (String)"urlSuffix");
            this.urlSuffix = urlSuffix;
        }

        @NotNull
        public final String getUrlSuffix() {
            return this.urlSuffix;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rH\u0007J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rH\u0007\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Gists;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubGist;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "contents", "", "Lorg/jetbrains/plugins/github/api/data/request/GithubGistRequest$FileContent;", "description", "", "public", "", "get", "id", "delete", "", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Gists\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Companion\n+ 4 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Companion\n*L\n1#1,639:1\n129#2,2:640\n55#3,2:642\n334#4:644\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Gists\n*L\n570#1:640,2\n576#1:642,2\n581#1:644\n*E\n"})
    public static final class Gists
    extends Entity {
        @NotNull
        public static final Gists INSTANCE = new Gists();

        private Gists() {
            super("/gists");
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubGist> create(@NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, @NotNull String description, boolean bl) {
            void body$iv;
            void url$iv;
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter(contents, (String)"contents");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
            String string = INSTANCE.getUrl(server, Gists.INSTANCE.getUrlSuffix());
            GithubGistRequest githubGistRequest = new GithubGistRequest(contents, description, bl);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubGist>((String)url$iv, body$iv, GithubGist.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestCreateGist).withOperationName("create gist");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubGist> get(@NotNull GithubServerPath server, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
            String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + id};
            String url$iv = INSTANCE.getUrl(server, stringArray);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubGist>(url$iv, GithubGist.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetGist).withOperationName("get gist " + id);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull GithubServerPath server, @NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            GithubApiRequest.Delete.Companion companion = GithubApiRequest.Delete.Companion;
            String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + id};
            String url$iv = INSTANCE.getUrl(server, stringArray);
            Object body$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Delete)new GithubApiRequest.Delete.Json<Unit>(url$iv, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestDeleteGist).withOperationName("delete gist " + id);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Organisations;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "Repos", "intellij.vcs.github"})
    public static final class Organisations
    extends Entity {
        @NotNull
        public static final Organisations INSTANCE = new Organisations();

        private Organisations() {
            super("/orgs");
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J0\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\nH\u0007J6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Organisations$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "organisation", "", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "url", "create", "name", "description", "private", "", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Organisations$Repos\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n*L\n1#1,639:1\n70#2,2:640\n129#3,2:642\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Organisations$Repos\n*L\n132#1:640,2\n138#1:642,2\n*E\n"})
        public static final class Repos
        extends Entity {
            @NotNull
            public static final Repos INSTANCE = new Repos();

            private Repos() {
                super("/repos");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull String organisation, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                return new GithubApiPagesLoader.Request<GithubRepo>(Repos.get(server, organisation, pagination), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Repos.get(p0);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, String string, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.pages(githubServerPath, string, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String organisation, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/", organisation, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Repos.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 4) != 0) {
                    githubRequestPagination = null;
                }
                return Repos.get(githubServerPath, string, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepositoriesForOrganization).withOperationName("get organisation repositories");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String organisation, @NotNull String name, @NotNull String description, boolean bl) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)description, (String)"description");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/", organisation, INSTANCE.getUrlSuffix()};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubRepoRequest githubRepoRequest = new GithubRepoRequest(name, description, bl, null);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestCreateRepositoryInOrganization).withOperationName("create organisation repository");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String organisation) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)organisation, (String)"organisation");
                return Repos.get$default(server, organisation, null, 4, null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\n\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0018\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\f\u001a\u00020\nH\u0007J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00052\u0006\u0010\f\u001a\u00020\nH\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubRepoDetailed;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "url", "delete", "", "Content", "Branches", "Tags", "Commits", "Forks", "Assignees", "Labels", "Collaborators", "Issues", "PullRequests", "intellij.vcs.github"})
    @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Companion\n*L\n1#1,639:1\n55#2,2:640\n55#2,2:642\n334#3:644\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos\n*L\n148#1:640,2\n154#1:642,2\n166#1:644\n*E\n"})
    public static final class Repos
    extends Entity {
        @NotNull
        public static final Repos INSTANCE = new Repos();

        private Repos() {
            super("/repos");
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<GithubRepoDetailed> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            GithubApiRequest.Get.Optional.Companion companion = GithubApiRequest.Get.Optional.Companion;
            String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName};
            String url$iv = INSTANCE.getUrl(server, stringArray);
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubRepoDetailed>(url$iv, GithubRepoDetailed.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepository).withOperationName("get information for repository " + username2 + "/" + repoName);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public static final GithubApiRequest<GithubRepoDetailed> get(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            GithubApiRequest.Get.Optional.Companion $this$iv = GithubApiRequest.Get.Optional.Companion;
            String acceptMimeType$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubRepoDetailed>(url, GithubRepoDetailed.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepositoryByUrl).withOperationName("get information for repository " + url);
        }

        @JvmStatic
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
            Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
            String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName};
            return Repos.delete(INSTANCE.getUrl(server, stringArray)).withOperation(GithubApiRequestOperation.RestDeleteRepository).withOperationName("delete repository " + username2 + "/" + repoName);
        }

        @JvmStatic
        @VisibleForTesting
        @NotNull
        public static final GithubApiRequest<Unit> delete(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            GithubApiRequest.Delete.Companion $this$iv = GithubApiRequest.Delete.Companion;
            Object body$iv = null;
            boolean $i$f$json = false;
            return ((GithubApiRequest.Delete)new GithubApiRequest.Delete.Json<Unit>(url, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestDeleteRepositoryByUrl).withOperationName("delete repository at " + url);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J8\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0011\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Assignees;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubUser;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Assignees\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n70#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Assignees\n*L\n308#1:640,2\n*E\n"})
        public static final class Assignees
        extends Entity {
            @NotNull
            public static final Assignees INSTANCE = new Assignees();

            private Assignees() {
                super("/assignees");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubUser> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubUser>(Assignees.get$default(server, username2, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubUser>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubUser>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Assignees.get(p0);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUser>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Assignees.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Assignees.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUser>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubUser>(url, GithubUser.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepositoryAssignees).withOperationName("get assignees");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUser>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Assignees.get$default(server, username2, repoName, null, 8, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J8\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0011\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Branches;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubBranch;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Branches\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n70#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Branches\n*L\n213#1:640,2\n*E\n"})
        public static final class Branches
        extends Entity {
            @NotNull
            public static final Branches INSTANCE = new Branches();

            private Branches() {
                super("/branches");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubBranch> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubBranch>(Branches.get$default(server, username2, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubBranch>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubBranch>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Branches.get(p0);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Branches.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Branches.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubBranch>(url, GithubBranch.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetBranches).withOperationName("get branches");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubBranch>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Branches.get$default(server, username2, repoName, null, 8, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J8\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0011\u001a\u00020\nH\u0007J.\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Collaborators;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubUserWithPermissions;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "add", "", "collaborator", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Collaborators\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Put$Companion\n*L\n1#1,639:1\n70#2,2:640\n282#3:642\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Collaborators\n*L\n342#1:640,2\n348#1:642\n*E\n"})
        public static final class Collaborators
        extends Entity {
            @NotNull
            public static final Collaborators INSTANCE = new Collaborators();

            private Collaborators() {
                super("/collaborators");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubUserWithPermissions> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubUserWithPermissions>(Collaborators.get$default(server, username2, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubUserWithPermissions>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Collaborators.get(p0);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Collaborators.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Collaborators.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubUserWithPermissions>(url, GithubUserWithPermissions.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepositoryCollaborators).withOperationName("get collaborators");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> add(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String collaborator) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)collaborator, (String)"collaborator");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", collaborator};
                String url$iv = GithubApiRequests.INSTANCE.getUrl(server, stringArray);
                Object body$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>(url$iv, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestAddCollaboratorToRepository).withOperationName("add collaborator");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubUserWithPermissions>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Collaborators.get$default(server, username2, repoName, null, 8, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J$\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\nH\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00052\u0006\u0010\u0010\u001a\u00020\nH\u0007J&\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Commits;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "compare", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GHCommitsCompareResult;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "refA", "", "refB", "getDiffFiles", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/commit/GHCommitFile;", "ref", "url", "getDiff", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Commits\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n67#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Commits\n*L\n238#1:640,2\n*E\n"})
        public static final class Commits
        extends Entity {
            @NotNull
            public static final Commits INSTANCE = new Commits();

            private Commits() {
                super("/commits");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GHCommitsCompareResult> compare(@NotNull GHRepositoryCoordinates repository, @NotNull String refA, @NotNull String refB) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)refA, (String)"refA");
                Intrinsics.checkNotNullParameter((Object)refB, (String)"refB");
                GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                String[] stringArray = new String[]{"/compare/" + refA + "..." + refB};
                String url$iv = GithubApiRequests.INSTANCE.getUrl(repository, stringArray);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GHCommitsCompareResult>(url$iv, GHCommitsCompareResult.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRefComparison).withOperationName("compare refs");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GHCommitFile>> getDiffFiles(@NotNull GHRepositoryCoordinates repository, @NotNull String ref) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + ref};
                return Commits.getDiffFiles(GithubApiRequests.INSTANCE.getUrl(repository, stringArray));
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GHCommitFile>> getDiffFiles(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                return new GithubApiRequest.Get<GithubResponsePage<GHCommitFile>>(url){

                    public GithubResponsePage<GHCommitFile> extractResult(GithubApiResponse response) {
                        LinkHttpHeaderValue linkHttpHeaderValue;
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        List<GHCommitFile> list = ((GHCommitFiles)response.readBody(getDiffFiles.1::extractResult$lambda$0)).getFiles();
                        String string = response.findHeader("Link");
                        if (string != null) {
                            String string2 = string;
                            LinkHttpHeaderValue.Companion companion = LinkHttpHeaderValue.Companion;
                            String p0 = string2;
                            boolean bl = false;
                            linkHttpHeaderValue = companion.parse(p0);
                        } else {
                            linkHttpHeaderValue = null;
                        }
                        LinkHttpHeaderValue linkHeader = linkHttpHeaderValue;
                        return new GithubResponsePage<GHCommitFile>(list, linkHeader);
                    }

                    private static final GHCommitFiles extractResult$lambda$0(Reader it) {
                        Intrinsics.checkNotNull((Object)it);
                        return (GHCommitFiles)GithubApiContentHelper.readJsonObject$default(it, GHCommitFiles.class, new Class[0], false, 8, null);
                    }
                }.withOperation(GithubApiRequestOperation.RestGetCommitDiffFiles).withOperationName("get files for ref");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<String> getDiff(@NotNull GHRepositoryCoordinates repository, @NotNull String refA, @NotNull String refB) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)refA, (String)"refA");
                Intrinsics.checkNotNullParameter((Object)refB, (String)"refB");
                String[] stringArray = new String[]{"/compare/" + refA + "..." + refB};
                String string = GithubApiRequests.INSTANCE.getUrl(repository, stringArray);
                return new GithubApiRequest.Get<String>(string){

                    public String extractResult(GithubApiResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        T t = response.handleBody(getDiff.1::extractResult$lambda$1);
                        Intrinsics.checkNotNullExpressionValue(t, (String)"handleBody(...)");
                        return (String)t;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private static final String extractResult$lambda$1(InputStream it) {
                        String string;
                        Intrinsics.checkNotNull((Object)it);
                        Closeable closeable = it;
                        Object object = Charsets.UTF_8;
                        closeable = new InputStreamReader((InputStream)closeable, (Charset)object);
                        object = null;
                        try {
                            InputStreamReader it2 = (InputStreamReader)closeable;
                            boolean bl = false;
                            string = TextStreamsKt.readText((Reader)it2);
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                        }
                        return string;
                    }
                }.withOperation(GithubApiRequestOperation.RestGetCommitDiff).withOperationName("get diff between refs");
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JH\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0007J\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\u0012\u001a\u00020\u000bH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u0012\u001a\u00020\u000bH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Content;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "list", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/GithubContent;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "path", "ref", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "get", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Content\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n70#2,2:640\n67#2,2:642\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Content\n*L\n190#1:640,2\n195#1:642,2\n*E\n"})
        public static final class Content
        extends Entity {
            @NotNull
            public static final Content INSTANCE = new Content();

            private Content() {
                super("/contents");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubContent>> list(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String path, @Nullable String ref, @NotNull GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)pagination, (String)"pagination");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/" + path, GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> Content.list$lambda$0(ref, pagination, arg_0)))};
                return Content.list(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest list$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                return Content.list(githubServerPath, string, string2, string3, string4, githubRequestPagination);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubContent> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String path, @Nullable String ref) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/" + path, GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> Content.get$lambda$1(ref, arg_0)))};
                return Content.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, int n, Object object) {
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                return Content.get(githubServerPath, string, string2, string3, string4);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubContent>> list(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubContent>(url, GithubContent.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetContents).withOperationName("get content");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubContent> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.Json<GithubContent>(url, GithubContent.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetContent).withOperationName("get file");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubContent>> list(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String path, @NotNull GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)pagination, (String)"pagination");
                return Content.list$default(server, username2, repoName, path, null, pagination, 16, null);
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubContent> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String path) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                return Content.get$default(server, username2, repoName, path, null, 16, null);
            }

            private static final Unit list$lambda$0(String $ref, GithubRequestPagination $pagination, GithubApiUrlQueryBuilder $this$urlQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                if ($ref != null) {
                    $this$urlQuery.param("ref", $ref);
                }
                $this$urlQuery.param($pagination);
                return Unit.INSTANCE;
            }

            private static final Unit get$lambda$1(String $ref, GithubApiUrlQueryBuilder $this$urlQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                if ($ref != null) {
                    $this$urlQuery.param("ref", $ref);
                }
                return Unit.INSTANCE;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J&\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J8\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f0\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0007J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000f0\u00052\u0006\u0010\u0012\u001a\u00020\nH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Forks;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubRepo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "get", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Forks\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n129#2,2:640\n70#3,2:642\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Forks\n*L\n277#1:640,2\n291#1:642,2\n*E\n"})
        public static final class Forks
        extends Entity {
            @NotNull
            public static final Forks INSTANCE = new Forks();

            private Forks() {
                super("/forks");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubRepo> create(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix()};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                Object body$iv = new Object();
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubRepo>((String)url$iv, body$iv, GithubRepo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestCreateFork).withOperationName("fork repository " + username2 + "/" + repoName + " for current user");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubRepo> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubRepo>(Forks.get$default(server, username2, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubRepo>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubRepo>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Forks.get(p0);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Forks.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Forks.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubRepo>(url, GithubRepo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetForks).withOperationName("get forks");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubRepo>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Forks.get$default(server, username2, repoName, null, 8, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002%&B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jo\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\b\u0002\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00112\u0010\b\u0002\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0011H\u0007\u00a2\u0006\u0002\u0010\u0013J>\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\nH\u0007JP\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001a0\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J\u001c\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001a0\u00192\u0006\u0010\u001d\u001a\u00020\nH\u0007J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0007J6\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0007J<\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00060\u00192\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0$H\u0007\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "Lorg/jetbrains/plugins/github/api/data/GithubIssue;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "title", "body", "milestone", "", "labels", "", "assignees", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Long;Ljava/util/List;Ljava/util/List;)Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "state", "assignee", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional;", "id", "updateState", "open", "", "updateAssignees", "", "Comments", "Labels", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n+ 4 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Optional$Companion\n+ 5 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Companion\n*L\n1#1,639:1\n129#2,2:640\n70#3,2:642\n55#4,2:644\n320#5:646\n320#5:647\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues\n*L\n366#1:640,2\n388#1:642,2\n394#1:644,2\n401#1:646\n408#1:647\n*E\n"})
        public static final class Issues
        extends Entity {
            @NotNull
            public static final Issues INSTANCE = new Issues();

            private Issues() {
                super("/issues");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Post<GithubIssue> create(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String title, @Nullable String body, @Nullable Long milestone, @Nullable List<String> labels, @Nullable List<String> assignees) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)title, (String)"title");
                Object object = GithubApiRequest.Post.Companion;
                Object object2 = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix()};
                object2 = GithubApiRequests.INSTANCE.getUrl(server, (String)object2);
                GithubCreateIssueRequest githubCreateIssueRequest = new GithubCreateIssueRequest(title, body, milestone, labels, assignees);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                Object $this$create_u24lambda_u240 = object = (GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class, acceptMimeType$iv);
                boolean bl = false;
                ((GithubApiRequest)$this$create_u24lambda_u240).withOperation(GithubApiRequestOperation.RestCreateIssue);
                ((GithubApiRequest)$this$create_u24lambda_u240).withOperationName("create issue");
                return object;
            }

            public static /* synthetic */ GithubApiRequest.Post create$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, Long l, List list, List list2, int n, Object object) {
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    l = null;
                }
                if ((n & 0x40) != 0) {
                    list = null;
                }
                if ((n & 0x80) != 0) {
                    list2 = null;
                }
                return Issues.create(githubServerPath, string, string2, string3, string4, l, list, list2);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubIssue> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable String state2, @Nullable String assignee) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubIssue>(Issues.get$default(server, username2, repoName, state2, assignee, null, 32, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssue>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubIssue>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Issues.get(p0);
                    }
                });
            }

            public static /* synthetic */ GithubApiPagesLoader.Request pages$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, int n, Object object) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                return Issues.pages(githubServerPath, string, string2, string3, string4);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssue>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable String state2, @Nullable String assignee, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> Issues.get$lambda$1(state2, assignee, pagination, arg_0)))};
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, String string4, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, string, string2, string3, string4, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssue>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssue>(url, GithubIssue.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetIssues).withOperationName("get issues in repository");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest.Get.Optional<GithubIssue> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Object object = GithubApiRequest.Get.Optional.Companion;
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", id};
                String url$iv = GithubApiRequests.INSTANCE.getUrl(server, stringArray);
                String acceptMimeType$iv = null;
                boolean $i$f$json = false;
                Object $this$get_u24lambda_u242 = object = (GithubApiRequest.Get.Optional)new GithubApiRequest.Get.Optional.Json<GithubIssue>(url$iv, GithubIssue.class, acceptMimeType$iv);
                boolean bl = false;
                ((GithubApiRequest)$this$get_u24lambda_u242).withOperation(GithubApiRequestOperation.RestGetIssue);
                ((GithubApiRequest)$this$get_u24lambda_u242).withOperationName("get issue");
                return object;
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubIssue> updateState(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String id, boolean open) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", id};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubChangeIssueStateRequest githubChangeIssueStateRequest = new GithubChangeIssueStateRequest(open ? "open" : "closed");
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Patch.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class)).withOperation(GithubApiRequestOperation.RestUpdateIssueState).withOperationName("update issue state");
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubIssue> updateAssignees(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String id, @NotNull Collection<String> assignees) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter(assignees, (String)"assignees");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", id};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubAssigneesCollectionRequest githubAssigneesCollectionRequest = new GithubAssigneesCollectionRequest(assignees);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Patch.Json<GithubIssue>((String)url$iv, body$iv, GithubIssue.class)).withOperation(GithubApiRequestOperation.RestUpdateIssueAssignees).withOperationName("update assignees for issue");
            }

            private static final Unit get$lambda$1(String $state, String $assignee, GithubRequestPagination $pagination, GithubApiUrlQueryBuilder $this$urlQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                $this$urlQuery.param("state", $state);
                $this$urlQuery.param("assignee", $assignee);
                $this$urlQuery.param($pagination);
                return Unit.INSTANCE;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J6\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0007J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\fH\u0007J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0007J@\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00160\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\f2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u001c\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00160\u00152\u0006\u0010\u0013\u001a\u00020\fH\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Comments;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "create", "Lorg/jetbrains/plugins/github/api/GithubApiRequest$Post;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueCommentWithHtml;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "issueId", "", "body", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "url", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "intellij.vcs.github"})
            @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Comments\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n130#2:640\n71#3:641\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Comments\n*L\n420#1:640\n445#1:641\n*E\n"})
            public static final class Comments
            extends Entity {
                @NotNull
                public static final Comments INSTANCE = new Comments();

                private Comments() {
                    super("/comments");
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Post<GithubIssueCommentWithHtml> create(@NotNull GHRepositoryCoordinates repository, long issueId, @NotNull String body) {
                    Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                    Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                    return Comments.create(repository.getServerPath(), repository.getRepositoryPath().getOwner(), repository.getRepositoryPath().getRepository(), String.valueOf(issueId), body);
                }

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest.Post<GithubIssueCommentWithHtml> create(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String issueId, @NotNull String body) {
                    void acceptMimeType$iv;
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    Intrinsics.checkNotNullParameter((Object)body, (String)"body");
                    Object object = GithubApiRequest.Post.Companion;
                    Object object2 = new String[]{Repos.INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix()};
                    object2 = GithubApiRequests.INSTANCE.getUrl(server, (String)object2);
                    GithubCreateIssueCommentRequest githubCreateIssueCommentRequest = new GithubCreateIssueCommentRequest(body);
                    String string = "application/vnd.github.v3.html+json";
                    boolean $i$f$json = false;
                    Object $this$create_u24lambda_u240 = object = (GithubApiRequest.Post)new GithubApiRequest.Post.Json<GithubIssueCommentWithHtml>((String)url$iv, body$iv, GithubIssueCommentWithHtml.class, (String)acceptMimeType$iv);
                    boolean bl = false;
                    ((GithubApiRequest)$this$create_u24lambda_u240).withOperation(GithubApiRequestOperation.RestCreateIssueComment);
                    ((GithubApiRequest)$this$create_u24lambda_u240).withOperationName("create comment for issue");
                    return object;
                }

                @JvmStatic
                @NotNull
                public static final GithubApiPagesLoader.Request<GithubIssueCommentWithHtml> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String issueId) {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    return new GithubApiPagesLoader.Request<GithubIssueCommentWithHtml>(Comments.get$default(server, username2, repoName, issueId, null, 16, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssueCommentWithHtml>>>((Object)INSTANCE){

                        public final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return Comments.get(p0);
                        }
                    });
                }

                @JvmStatic
                @NotNull
                public static final GithubApiPagesLoader.Request<GithubIssueCommentWithHtml> pages(@NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    return new GithubApiPagesLoader.Request<GithubIssueCommentWithHtml>(Comments.get(url), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssueCommentWithHtml>>>((Object)INSTANCE){

                        public final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> invoke(String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return Comments.get(p0);
                        }
                    });
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String issueId, @Nullable GithubRequestPagination pagination) {
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    String[] stringArray = new String[]{Repos.INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> Comments.get$lambda$1(pagination, arg_0)))};
                    return Comments.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
                }

                public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, String string3, GithubRequestPagination githubRequestPagination, int n, Object object) {
                    if ((n & 0x10) != 0) {
                        githubRequestPagination = null;
                    }
                    return Comments.get(githubServerPath, string, string2, string3, githubRequestPagination);
                }

                @JvmStatic
                @NotNull
                public static final GithubApiRequest<GithubResponsePage<GithubIssueCommentWithHtml>> get(@NotNull String url) {
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                    String acceptMimeType$iv = "application/vnd.github.v3.html+json";
                    boolean $i$f$jsonPage = false;
                    return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssueCommentWithHtml>(url, GithubIssueCommentWithHtml.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetIssueComment).withOperationName("get comments for issue");
                }

                private static final Unit get$lambda$1(GithubRequestPagination $pagination, GithubApiUrlQueryBuilder $this$urlQuery) {
                    Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                    $this$urlQuery.param($pagination);
                    return Unit.INSTANCE;
                }
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fH\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Labels;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "replace", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "issueId", "labels", "", "intellij.vcs.github"})
            @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Labels\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Put$Companion\n*L\n1#1,639:1\n284#2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Issues$Labels\n*L\n453#1:640\n*E\n"})
            public static final class Labels
            extends Entity {
                @NotNull
                public static final Labels INSTANCE = new Labels();

                private Labels() {
                    super("/labels");
                }

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest<List<GithubIssueLabel>> replace(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @NotNull String issueId, @NotNull Collection<String> labels) {
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
                    Intrinsics.checkNotNullParameter(labels, (String)"labels");
                    GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                    Object object = new String[]{Repos.INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/", issueId, INSTANCE.getUrlSuffix()};
                    object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                    GithubLabelsCollectionRequest githubLabelsCollectionRequest = new GithubLabelsCollectionRequest(labels);
                    boolean $i$f$jsonList = false;
                    return ((GithubApiRequest.Put)new GithubApiRequest.Put.JsonList<GithubIssueLabel>((String)url$iv, body$iv, GithubIssueLabel.class)).withOperation(GithubApiRequestOperation.RestUpdateIssueLabels).withOperationName("replace issue labels");
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J8\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0011\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Labels;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubIssueLabel;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Labels\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n70#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Labels\n*L\n325#1:640,2\n*E\n"})
        public static final class Labels
        extends Entity {
            @NotNull
            public static final Labels INSTANCE = new Labels();

            private Labels() {
                super("/labels");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubIssueLabel> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubIssueLabel>(Labels.get$default(server, username2, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubIssueLabel>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Labels.get(p0);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Labels.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Labels.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubIssueLabel>(url, GithubIssueLabel.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetRepositoryLabels).withOperationName("get labels");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubIssueLabel>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Labels.get$default(server, username2, repoName, null, 8, null);
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J@\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007Jo\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\r2\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ>\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0007J>\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\rH\u0007J.\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00052\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\rH\u0007J \u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00052\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0007J$\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010*\u001a\u00020+H\u0007J\u001c\u0010(\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020)0\u00060\u00052\u0006\u0010,\u001a\u00020\rH\u0007\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "find", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestRestIdOnly;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "state", "Lorg/jetbrains/plugins/github/api/data/GithubIssueState;", "baseRef", "", "headRef", "update", "", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "repoName", "number", "", "title", "body", "base", "maintainerCanModify", "", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Lorg/jetbrains/plugins/github/api/data/GithubIssueState;Ljava/lang/String;Ljava/lang/Boolean;)Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "merge", "", "server", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "commitSubject", "commitBody", "headSha", "squashMerge", "rebaseMerge", "getListETag", "getDiffFiles", "Lorg/jetbrains/plugins/github/api/data/commit/GHCommitFile;", "id", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "url", "Reviewers", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Patch$Companion\n+ 4 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Put$Companion\n*L\n1#1,639:1\n70#2,2:640\n70#2,2:646\n320#3:642\n282#4:643\n282#4:644\n282#4:645\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests\n*L\n469#1:640,2\n536#1:646,2\n486#1:642\n496#1:643\n506#1:644\n516#1:645\n*E\n"})
        public static final class PullRequests
        extends Entity {
            @NotNull
            public static final PullRequests INSTANCE = new PullRequests();

            private PullRequests() {
                super("/pulls");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GHPullRequestRestIdOnly>> find(@NotNull GHRepositoryCoordinates repository, @Nullable GithubIssueState state2, @Nullable String baseRef, @Nullable String headRef) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                GithubApiRequest.Get.Companion companion = GithubApiRequest.Get.Companion;
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> PullRequests.find$lambda$0(state2, baseRef, headRef, arg_0)))};
                String url$iv = GithubApiRequests.INSTANCE.getUrl(repository, stringArray);
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GHPullRequestRestIdOnly>(url$iv, GHPullRequestRestIdOnly.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetPullRequests).withOperationName("find pull requests");
            }

            public static /* synthetic */ GithubApiRequest find$default(GHRepositoryCoordinates gHRepositoryCoordinates, GithubIssueState githubIssueState, String string, String string2, int n, Object object) {
                if ((n & 2) != 0) {
                    githubIssueState = null;
                }
                if ((n & 4) != 0) {
                    string = null;
                }
                if ((n & 8) != 0) {
                    string2 = null;
                }
                return PullRequests.find(gHRepositoryCoordinates, githubIssueState, string, string2);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Object> update(@NotNull GithubServerPath serverPath, @NotNull String username2, @NotNull String repoName, long number, @Nullable String title, @Nullable String body, @Nullable GithubIssueState state2, @Nullable String base, @Nullable Boolean maintainerCanModify) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                GithubApiRequest.Patch.Companion companion = GithubApiRequest.Patch.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/" + number};
                object = GithubApiRequests.INSTANCE.getUrl(serverPath, (String)object);
                GithubPullUpdateRequest githubPullUpdateRequest = new GithubPullUpdateRequest(title, body, state2, base, maintainerCanModify);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Post)new GithubApiRequest.Patch.Json<Object>((String)url$iv, body$iv, Object.class)).withOperation(GithubApiRequestOperation.RestUpdatePullRequest).withOperationName("update pull request " + number);
            }

            public static /* synthetic */ GithubApiRequest update$default(GithubServerPath githubServerPath, String string, String string2, long l, String string3, String string4, GithubIssueState githubIssueState, String string5, Boolean bl, int n, Object object) {
                if ((n & 0x10) != 0) {
                    string3 = null;
                }
                if ((n & 0x20) != 0) {
                    string4 = null;
                }
                if ((n & 0x40) != 0) {
                    githubIssueState = null;
                }
                if ((n & 0x80) != 0) {
                    string5 = null;
                }
                if ((n & 0x100) != 0) {
                    bl = null;
                }
                return PullRequests.update(githubServerPath, string, string2, l, string3, string4, githubIssueState, string5, bl);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> merge(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath, long number, @NotNull String commitSubject, @NotNull String commitBody, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                Intrinsics.checkNotNullParameter((Object)commitSubject, (String)"commitSubject");
                Intrinsics.checkNotNullParameter((Object)commitBody, (String)"commitBody");
                Intrinsics.checkNotNullParameter((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + repoPath, INSTANCE.getUrlSuffix(), "/" + number, "/merge"};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubPullRequestMergeRequest githubPullRequestMergeRequest = new GithubPullRequestMergeRequest(commitSubject, commitBody, headSha, GithubPullRequestMergeMethod.merge);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestMergePullRequest).withOperationName("merge pull request " + number);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> squashMerge(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath, long number, @NotNull String commitSubject, @NotNull String commitBody, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                Intrinsics.checkNotNullParameter((Object)commitSubject, (String)"commitSubject");
                Intrinsics.checkNotNullParameter((Object)commitBody, (String)"commitBody");
                Intrinsics.checkNotNullParameter((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + repoPath, INSTANCE.getUrlSuffix(), "/" + number, "/merge"};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubPullRequestMergeRequest githubPullRequestMergeRequest = new GithubPullRequestMergeRequest(commitSubject, commitBody, headSha, GithubPullRequestMergeMethod.squash);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestSquashMergePullRequest).withOperationName("squash and merge pull request " + number);
            }

            /*
             * WARNING - void declaration
             */
            @JvmStatic
            @NotNull
            public static final GithubApiRequest<Unit> rebaseMerge(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath, long number, @NotNull String headSha) {
                void body$iv;
                void url$iv;
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                Intrinsics.checkNotNullParameter((Object)headSha, (String)"headSha");
                GithubApiRequest.Put.Companion companion = GithubApiRequest.Put.Companion;
                Object object = new String[]{INSTANCE.getUrlSuffix(), "/" + repoPath, INSTANCE.getUrlSuffix(), "/" + number, "/merge"};
                object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                GithubPullRequestMergeRebaseRequest githubPullRequestMergeRebaseRequest = new GithubPullRequestMergeRebaseRequest(headSha);
                boolean $i$f$json = false;
                return ((GithubApiRequest.Put)new GithubApiRequest.Put.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestRebaseMergePullRequest).withOperationName("rebase and merge pull request " + number);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<String> getListETag(@NotNull GithubServerPath server, @NotNull GHRepositoryPath repoPath) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + repoPath, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)PullRequests::getListETag$lambda$1))};
                String string = GithubApiRequests.INSTANCE.getUrl(server, stringArray);
                return new GithubApiRequest.Get<String>(string){

                    public String extractResult(GithubApiResponse response) {
                        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                        return response.findHeader("ETag");
                    }
                }.withOperation(GithubApiRequestOperation.RestGetPullRequestListETag).withOperationName("get pull request list ETag");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GHCommitFile>> getDiffFiles(@NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier id) {
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + id.getNumber(), "/files"};
                return PullRequests.getDiffFiles(GithubApiRequests.INSTANCE.getUrl(repository, stringArray));
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GHCommitFile>> getDiffFiles(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GHCommitFile>(url, GHCommitFile.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetPullRequestDiffFiles).withOperationName("get files for pull request");
            }

            private static final Unit find$lambda$0(GithubIssueState $state, String $baseRef, String $headRef, GithubApiUrlQueryBuilder $this$urlQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                GithubIssueState githubIssueState = $state;
                $this$urlQuery.param("state", githubIssueState != null ? githubIssueState.toString() : null);
                $this$urlQuery.param("base", $baseRef);
                $this$urlQuery.param("head", $headRef);
                return Unit.INSTANCE;
            }

            private static final Unit getListETag$lambda$1(GithubApiUrlQueryBuilder $this$urlQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                $this$urlQuery.param(new GithubRequestPagination(0, 1, 1, null));
                return Unit.INSTANCE;
            }

            @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JJ\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0007JJ\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\u0011H\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests$Reviewers;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "add", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "number", "", "reviewers", "", "teamReviewers", "", "remove", "intellij.vcs.github"})
            @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests$Reviewers\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Post$Companion\n+ 3 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Delete$Companion\n*L\n1#1,639:1\n129#2,2:640\n334#3:642\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$PullRequests$Reviewers\n*L\n546#1:640,2\n556#1:642\n*E\n"})
            public static final class Reviewers
            extends Entity {
                @NotNull
                public static final Reviewers INSTANCE = new Reviewers();

                private Reviewers() {
                    super("/requested_reviewers");
                }

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest<Unit> add(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, long number, @NotNull Collection<String> reviewers2, @NotNull List<String> teamReviewers) {
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter(reviewers2, (String)"reviewers");
                    Intrinsics.checkNotNullParameter(teamReviewers, (String)"teamReviewers");
                    GithubApiRequest.Post.Companion companion = GithubApiRequest.Post.Companion;
                    Object object = new String[]{Repos.INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/" + number, INSTANCE.getUrlSuffix()};
                    object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                    GithubReviewersCollectionRequest githubReviewersCollectionRequest = new GithubReviewersCollectionRequest(reviewers2, (Collection<String>)teamReviewers);
                    String acceptMimeType$iv = null;
                    boolean $i$f$json = false;
                    return ((GithubApiRequest.Post)new GithubApiRequest.Post.Json<Unit>((String)url$iv, body$iv, Unit.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestAddReviewerToPullRequest).withOperationName("add reviewer");
                }

                /*
                 * WARNING - void declaration
                 */
                @JvmStatic
                @NotNull
                public static final GithubApiRequest<Unit> remove(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, long number, @NotNull Collection<String> reviewers2, @NotNull List<String> teamReviewers) {
                    void body$iv;
                    void url$iv;
                    Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                    Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                    Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                    Intrinsics.checkNotNullParameter(reviewers2, (String)"reviewers");
                    Intrinsics.checkNotNullParameter(teamReviewers, (String)"teamReviewers");
                    GithubApiRequest.Delete.Companion companion = GithubApiRequest.Delete.Companion;
                    Object object = new String[]{Repos.INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), "/" + number, INSTANCE.getUrlSuffix()};
                    object = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
                    GithubReviewersCollectionRequest githubReviewersCollectionRequest = new GithubReviewersCollectionRequest(reviewers2, (Collection<String>)teamReviewers);
                    boolean $i$f$json = false;
                    return ((GithubApiRequest.Delete)new GithubApiRequest.Delete.Json<Unit>((String)url$iv, body$iv, Unit.class)).withOperation(GithubApiRequestOperation.RestRemoveReviewerFromPullRequest).withOperationName("remove reviewer");
                }
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0007J8\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007J\u001c\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\r2\u0006\u0010\u0011\u001a\u00020\nH\u0007\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Tags;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lcom/intellij/platform/templates/github/GithubTagInfo;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "username", "", "repoName", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Tags\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n70#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Repos$Tags\n*L\n229#1:640,2\n*E\n"})
        public static final class Tags
        extends Entity {
            @NotNull
            public static final Tags INSTANCE = new Tags();

            private Tags() {
                super("/tags");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubTagInfo> pages(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return new GithubApiPagesLoader.Request<GithubTagInfo>(Tags.get$default(server, username2, repoName, null, 8, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubTagInfo>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubTagInfo>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Tags.get(p0);
                    }
                });
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubTagInfo>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), "/" + username2 + "/" + repoName, INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.paginationQuery(pagination)};
                return Tags.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, String string, String string2, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 8) != 0) {
                    githubRequestPagination = null;
                }
                return Tags.get(githubServerPath, string, string2, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubTagInfo>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonPage<GithubTagInfo>(url, GithubTagInfo.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestGetTags).withOperationName("get tags");
            }

            @JvmStatic
            @JvmOverloads
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubTagInfo>> get(@NotNull GithubServerPath server, @NotNull String username2, @NotNull String repoName) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                Intrinsics.checkNotNullParameter((Object)username2, (String)"username");
                Intrinsics.checkNotNullParameter((Object)repoName, (String)"repoName");
                return Tags.get$default(server, username2, repoName, null, 8, null);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Search;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "Issues", "intellij.vcs.github"})
    public static final class Search
    extends Entity {
        @NotNull
        public static final Search INSTANCE = new Search();

        private Search() {
            super("/search");
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0007JP\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00110\u00102\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0007J\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00110\u00102\u0006\u0010\u0014\u001a\u00020\fH\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/api/GithubApiRequests$Search$Issues;", "Lorg/jetbrains/plugins/github/api/GithubApiRequests$Entity;", "<init>", "()V", "pages", "Lorg/jetbrains/plugins/github/api/util/GithubApiPagesLoader$Request;", "Lorg/jetbrains/plugins/github/api/data/GithubSearchedIssue;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "state", "", "assignee", "query", "get", "Lorg/jetbrains/plugins/github/api/GithubApiRequest;", "Lorg/jetbrains/plugins/github/api/data/GithubResponsePage;", "pagination", "Lorg/jetbrains/plugins/github/api/data/request/GithubRequestPagination;", "url", "intellij.vcs.github"})
        @SourceDebugExtension(value={"SMAP\nGithubApiRequests.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Search$Issues\n+ 2 GithubApiRequest.kt\norg/jetbrains/plugins/github/api/GithubApiRequest$Get$Companion\n*L\n1#1,639:1\n73#2,2:640\n*S KotlinDebug\n*F\n+ 1 GithubApiRequests.kt\norg/jetbrains/plugins/github/api/GithubApiRequests$Search$Issues\n*L\n610#1:640,2\n*E\n"})
        public static final class Issues
        extends Entity {
            @NotNull
            public static final Issues INSTANCE = new Issues();

            private Issues() {
                super("/issues");
            }

            @JvmStatic
            @NotNull
            public static final GithubApiPagesLoader.Request<GithubSearchedIssue> pages(@NotNull GithubServerPath server, @Nullable GHRepositoryPath repoPath, @Nullable String state2, @Nullable String assignee, @Nullable String query) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                return new GithubApiPagesLoader.Request<GithubSearchedIssue>(Issues.get$default(server, repoPath, state2, assignee, query, null, 32, null), (Function1)new Function1<String, GithubApiRequest<? extends GithubResponsePage<GithubSearchedIssue>>>((Object)INSTANCE){

                    public final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> invoke(String p0) {
                        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                        return Issues.get(p0);
                    }
                });
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull GithubServerPath server, @Nullable GHRepositoryPath repoPath, @Nullable String state2, @Nullable String assignee, @Nullable String query, @Nullable GithubRequestPagination pagination) {
                Intrinsics.checkNotNullParameter((Object)server, (String)"server");
                String[] stringArray = new String[]{INSTANCE.getUrlSuffix(), INSTANCE.getUrlSuffix(), GithubApiUrlQueryBuilder.Companion.urlQuery((Function1<? super GithubApiUrlQueryBuilder, Unit>)((Function1)arg_0 -> Issues.get$lambda$1(pagination, repoPath, state2, assignee, query, arg_0)))};
                return Issues.get(GithubApiRequests.INSTANCE.getUrl(server, stringArray));
            }

            public static /* synthetic */ GithubApiRequest get$default(GithubServerPath githubServerPath, GHRepositoryPath gHRepositoryPath, String string, String string2, String string3, GithubRequestPagination githubRequestPagination, int n, Object object) {
                if ((n & 0x20) != 0) {
                    githubRequestPagination = null;
                }
                return Issues.get(githubServerPath, gHRepositoryPath, string, string2, string3, githubRequestPagination);
            }

            @JvmStatic
            @NotNull
            public static final GithubApiRequest<GithubResponsePage<GithubSearchedIssue>> get(@NotNull String url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                GithubApiRequest.Get.Companion $this$iv = GithubApiRequest.Get.Companion;
                String acceptMimeType$iv = null;
                boolean $i$f$jsonSearchPage = false;
                return ((GithubApiRequest.Get)new GithubApiRequest.Get.JsonSearchPage<GithubSearchedIssue>(url, GithubSearchedIssue.class, acceptMimeType$iv)).withOperation(GithubApiRequestOperation.RestSearchIssues).withOperationName("search issues in repository");
            }

            private static final Unit get$lambda$1$lambda$0(GHRepositoryPath $repoPath, String $state, String $assignee, String $query, GithubApiSearchQueryBuilder $this$searchQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$searchQuery, (String)"$this$searchQuery");
                GHRepositoryPath gHRepositoryPath = $repoPath;
                String string = gHRepositoryPath != null ? gHRepositoryPath.toString() : null;
                if (string == null) {
                    string = "";
                }
                $this$searchQuery.term(GHPRSearchQuery.QualifierName.repo.createTerm(string));
                String string2 = $state;
                if (string2 == null) {
                    string2 = "";
                }
                $this$searchQuery.term(GHPRSearchQuery.QualifierName.state.createTerm(string2));
                String string3 = $assignee;
                if (string3 == null) {
                    string3 = "";
                }
                $this$searchQuery.term(GHPRSearchQuery.QualifierName.assignee.createTerm(string3));
                $this$searchQuery.query($query);
                return Unit.INSTANCE;
            }

            private static final Unit get$lambda$1(GithubRequestPagination $pagination, GHRepositoryPath $repoPath, String $state, String $assignee, String $query, GithubApiUrlQueryBuilder $this$urlQuery) {
                Intrinsics.checkNotNullParameter((Object)$this$urlQuery, (String)"$this$urlQuery");
                $this$urlQuery.param("q", GithubApiSearchQueryBuilder.Companion.searchQuery((Function1<? super GithubApiSearchQueryBuilder, Unit>)((Function1)arg_0 -> Issues.get$lambda$1$lambda$0($repoPath, $state, $assignee, $query, arg_0))));
                $this$urlQuery.param("advanced_search", "true");
                $this$urlQuery.param($pagination);
                return Unit.INSTANCE;
            }
        }
    }
}

