/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend;

import com.intellij.ide.ui.colors.ColorId;
import com.intellij.ide.ui.colors.ColorIdKt;
import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.recentFiles.frontend.SwitcherListItem;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0017H\u0016J\u0013\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010)H\u0096\u0002J\b\u0010*\u001a\u00020!H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0019\u0010\u0010\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u001b\u0010\u0012\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\rR\u001b\u0010\u0014\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherListItem;", "Lcom/intellij/ui/BackgroundSupplier;", "rpcModel", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;", "<init>", "(Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;)V", "getRpcModel", "()Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto$File;", "mainText", "", "Lcom/intellij/openapi/util/NlsSafe;", "getMainText", "()Ljava/lang/String;", "statusText", "getStatusText", "pathText", "getPathText", "mnemonic", "getMnemonic", "shortcutText", "getShortcutText", "separatorAbove", "", "getSeparatorAbove", "()Z", "virtualFileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "getVirtualFileId", "()Lcom/intellij/ide/vfs/VirtualFileId;", "getElementBackground", "Ljava/awt/Color;", "row", "", "prepareMainRenderer", "", "component", "Lcom/intellij/ui/SimpleColoredComponent;", "selected", "equals", "other", "", "hashCode", "intellij.platform.recentFiles.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSwitcherRendering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwitcherRendering.kt\ncom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
public final class SwitcherVirtualFile
implements SwitcherListItem,
BackgroundSupplier {
    @NotNull
    private final SwitcherRpcDto.File rpcModel;

    public SwitcherVirtualFile(@NotNull SwitcherRpcDto.File rpcModel) {
        Intrinsics.checkNotNullParameter((Object)rpcModel, (String)"rpcModel");
        this.rpcModel = rpcModel;
    }

    @NotNull
    public final SwitcherRpcDto.File getRpcModel() {
        return this.rpcModel;
    }

    @Override
    @NotNull
    public String getMainText() {
        return this.rpcModel.getMainText();
    }

    @Override
    @NotNull
    public String getStatusText() {
        return this.rpcModel.getStatusText();
    }

    @Override
    @NotNull
    public String getPathText() {
        return this.rpcModel.getPathText();
    }

    @Override
    @Nullable
    public String getMnemonic() {
        return null;
    }

    @Override
    @Nullable
    public String getShortcutText() {
        return null;
    }

    @Override
    public boolean getSeparatorAbove() {
        return false;
    }

    @NotNull
    public final VirtualFileId getVirtualFileId() {
        return this.rpcModel.getVirtualFileId();
    }

    @Nullable
    public Color getElementBackground(int row) {
        ColorId colorId = this.rpcModel.getBackgroundColorId();
        return colorId != null ? ColorIdKt.color((ColorId)colorId) : null;
    }

    @Override
    public void prepareMainRenderer(@NotNull SimpleColoredComponent component, boolean selected) {
        block6: {
            int n;
            Color color;
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            component.setIconTextGap(JBUI.scale((int)4));
            component.setIcon(Registry.Companion.is("ide.project.view.change.icon.on.selection", true) ? RenderingUtil.getIcon((Icon)IconIdKt.icon((IconId)this.rpcModel.getIconId()), (boolean)selected) : IconIdKt.icon((IconId)this.rpcModel.getIconId()));
            if (selected) {
                color = null;
            } else {
                ColorId colorId = this.rpcModel.getForegroundTextColorId();
                color = colorId != null ? ColorIdKt.color((ColorId)colorId) : null;
            }
            Color foreground = color;
            JBColor effectColor = this.rpcModel.getHasProblems() ? JBColor.red : null;
            int style = effectColor == null ? 0 : 8;
            component.append(this.getMainText(), new SimpleTextAttributes(style, foreground, (Color)effectColor));
            Font font = component.getFont();
            if (font == null) break block6;
            Font it = font;
            boolean bl = false;
            FontMetrics fontMetrics = component.getFontMetrics(it);
            int mainTextWidth = PaintUtil.getStringWidth((String)this.getMainText(), (Graphics)component.getGraphics(), (FontMetrics)fontMetrics);
            String string = this.getShortcutText();
            if (string != null) {
                String shortcut = string;
                boolean bl2 = false;
                n = PaintUtil.getStringWidth((String)shortcut, (Graphics)component.getGraphics(), (FontMetrics)fontMetrics);
            } else {
                n = 0;
            }
            int shortcutTextWidth = n;
            int width = component.getWidth() - mainTextWidth - shortcutTextWidth - component.getIconTextGap() - component.getIcon().getIconWidth() - component.getInsets().left - component.getInsets().right;
            if (width > 0) {
                String string2 = PaintUtil.cutContainerText((String)(" " + this.getPathText()), (int)width, (FontMetrics)fontMetrics);
                if (string2 != null) {
                    String fragment = string2;
                    boolean bl3 = false;
                    component.append(fragment, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        }
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwitcherVirtualFile)) {
            return false;
        }
        if (this.getSeparatorAbove() != ((SwitcherVirtualFile)other).getSeparatorAbove()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMainText(), (Object)((SwitcherVirtualFile)other).getMainText())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStatusText(), (Object)((SwitcherVirtualFile)other).getStatusText())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getPathText(), (Object)((SwitcherVirtualFile)other).getPathText())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getMnemonic(), (Object)((SwitcherVirtualFile)other).getMnemonic())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getShortcutText(), (Object)((SwitcherVirtualFile)other).getShortcutText());
    }

    public int hashCode() {
        int result = Boolean.hashCode(this.getSeparatorAbove());
        result = 31 * result + this.getMainText().hashCode();
        result = 31 * result + this.getStatusText().hashCode();
        result = 31 * result + this.getPathText().hashCode();
        String string = this.getMnemonic();
        result = 31 * result + (string != null ? string.hashCode() : 0);
        String string2 = this.getShortcutText();
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        return result;
    }
}

