/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.history.ActivityId;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import git4idea.GitActivity;
import git4idea.GitUtil;
import git4idea.branch.GitBranchUiHandlerImpl;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.reset.GitResetMode;
import git4idea.util.GitPreservingProcess;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;
import org.jetbrains.annotations.Unmodifiable;

public class GitResetOperation {
    @NotNull
    private final Project myProject;
    @NotNull
    private final @Unmodifiable @NotNull Map<GitRepository, @NotNull String> myCommits;
    @NotNull
    private final GitResetMode myMode;
    @NotNull
    private final ProgressIndicator myIndicator;
    @NotNull
    private final Git myGit;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitBranchUiHandlerImpl myUiHandler;
    @NotNull
    private final OperationPresentation myPresentation;

    public GitResetOperation(@NotNull Project project, @NotNull Map<GitRepository, Hash> targetCommits, @NotNull GitResetMode mode, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitResetOperation.$$$reportNull$$$0(0);
        }
        if (targetCommits == null) {
            GitResetOperation.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            GitResetOperation.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            GitResetOperation.$$$reportNull$$$0(3);
        }
        this(project, ContainerUtil.map2Map(targetCommits.entrySet(), e -> Pair.create((Object)((GitRepository)e.getKey()), (Object)((Hash)e.getValue()).asString())), mode, indicator, new OperationPresentation());
    }

    public GitResetOperation(@NotNull Project project, @NotNull @NotNull @Unmodifiable Map<GitRepository, @NotNull String> targetCommits, @NotNull GitResetMode mode, @NotNull ProgressIndicator indicator, @NotNull OperationPresentation operationPresentation) {
        if (project == null) {
            GitResetOperation.$$$reportNull$$$0(4);
        }
        if (targetCommits == null) {
            GitResetOperation.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            GitResetOperation.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            GitResetOperation.$$$reportNull$$$0(7);
        }
        if (operationPresentation == null) {
            GitResetOperation.$$$reportNull$$$0(8);
        }
        this.myProject = project;
        this.myCommits = targetCommits;
        this.myMode = mode;
        this.myIndicator = indicator;
        this.myPresentation = operationPresentation;
        this.myGit = Git.getInstance();
        this.myNotifier = VcsNotifier.getInstance((Project)project);
        this.myUiHandler = new GitBranchUiHandlerImpl(this.myProject, indicator);
    }

    public boolean execute() {
        GitResetOperation.saveAllDocuments();
        HashMap<GitRepository, GitCommandResult> results = new HashMap<GitRepository, GitCommandResult>();
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message(this.myPresentation.activityName, new Object[0]), (ActivityId)GitActivity.Reset);){
            for (Map.Entry<GitRepository, String> entry : this.myCommits.entrySet()) {
                GitCommandResult smartResult;
                GitRepository repository = entry.getKey();
                VirtualFile root = repository.getRoot();
                String target = entry.getValue();
                GitLocalChangesWouldBeOverwrittenDetector detector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.RESET);
                Hash startHash = GitUtil.getHead(repository);
                GitCommandResult result2 = this.myGit.reset(repository, this.myMode, target, detector);
                if (!result2.success() && detector.isDetected() && (smartResult = this.proposeSmartReset(detector, repository, target)) != null) {
                    result2 = smartResult;
                }
                results.put(repository, result2);
                GitUtil.updateAndRefreshChangedVfs(repository, startHash);
                VcsDirtyScopeManager.getInstance((Project)this.myProject).rootDirty(root);
                repository.getUntrackedFilesHolder().invalidate();
            }
        }
        this.notifyResult(results);
        return ContainerUtil.all(results.values(), GitCommandResult::success);
    }

    private GitCommandResult proposeSmartReset(@NotNull GitLocalChangesWouldBeOverwrittenDetector detector, @NotNull GitRepository repository, @NotNull @NlsSafe String target) {
        if (detector == null) {
            GitResetOperation.$$$reportNull$$$0(9);
        }
        if (repository == null) {
            GitResetOperation.$$$reportNull$$$0(10);
        }
        if (target == null) {
            GitResetOperation.$$$reportNull$$$0(11);
        }
        Collection<String> absolutePaths = GitUtil.toAbsolute(repository.getRoot(), detector.getRelativeFilePaths());
        List<Change> affectedChanges = GitUtil.findLocalChangesForPaths(this.myProject, repository.getRoot(), absolutePaths, false);
        GitSmartOperationDialog.Choice choice = this.myUiHandler.showSmartOperationDialog(this.myProject, affectedChanges, absolutePaths, GitBundle.message(this.myPresentation.operationTitle, new Object[0]), GitBundle.message(this.myPresentation.forceButtonTitle, new Object[0]));
        if (choice == GitSmartOperationDialog.Choice.SMART) {
            Ref result2 = Ref.create();
            GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(this.myProject).getSaveChangesPolicy();
            new GitPreservingProcess(this.myProject, this.myGit, Collections.singleton(repository.getRoot()), GitBundle.message(this.myPresentation.operationTitle, new Object[0]), target, saveMethod, this.myIndicator, () -> result2.set((Object)this.myGit.reset(repository, this.myMode, target, new GitLineHandlerListener[0]))).execute();
            return (GitCommandResult)result2.get();
        }
        if (choice == GitSmartOperationDialog.Choice.FORCE) {
            return this.myGit.reset(repository, GitResetMode.HARD, target, new GitLineHandlerListener[0]);
        }
        return null;
    }

    private void notifyResult(@NotNull Map<GitRepository, GitCommandResult> results) {
        if (results == null) {
            GitResetOperation.$$$reportNull$$$0(12);
        }
        HashMap<GitRepository, GitCommandResult> successes = new HashMap<GitRepository, GitCommandResult>();
        HashMap<GitRepository, GitCommandResult> errors = new HashMap<GitRepository, GitCommandResult>();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            GitCommandResult result2 = entry.getValue();
            GitRepository repository = entry.getKey();
            if (result2.success()) {
                successes.put(repository, result2);
                continue;
            }
            errors.put(repository, result2);
        }
        if (errors.isEmpty()) {
            this.myNotifier.notifySuccess("git.reset.successful", "", GitBundle.message(this.myPresentation.notificationSuccess, new Object[0]));
        } else if (!successes.isEmpty()) {
            this.myNotifier.notifyImportantWarning("git.reset.partially.failed", GitBundle.message(this.myPresentation.notificationPartialFailureTitle, new Object[0]), GitBundle.message(this.myPresentation.notificationPartialFailureMessage, GitResetOperation.joinRepos(successes.keySet()), GitResetOperation.joinRepos(errors.keySet()), GitResetOperation.formErrorReport(errors)));
        } else {
            this.myNotifier.notifyError("git.reset.failed", GitBundle.message(this.myPresentation.notificationFailure, new Object[0]), GitResetOperation.formErrorReport(errors), true);
        }
    }

    @NlsSafe
    @NotNull
    private static String formErrorReport(@NotNull Map<GitRepository, GitCommandResult> errorResults) {
        MultiMap<String, GitRepository> grouped;
        if (errorResults == null) {
            GitResetOperation.$$$reportNull$$$0(13);
        }
        if ((grouped = GitResetOperation.groupByResult(errorResults)).size() == 1) {
            String string = "<code>" + (String)grouped.keySet().iterator().next() + "</code>";
            if (string == null) {
                GitResetOperation.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = StringUtil.join((Collection)grouped.entrySet(), entry -> GitResetOperation.joinRepos((Collection)entry.getValue()) + ":<br/><code>" + (String)entry.getKey() + "</code>", (String)"<br/>");
        if (string == null) {
            GitResetOperation.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static MultiMap<String, GitRepository> groupByResult(@NotNull Map<GitRepository, GitCommandResult> results) {
        if (results == null) {
            GitResetOperation.$$$reportNull$$$0(16);
        }
        MultiMap grouped = MultiMap.create();
        for (Map.Entry<GitRepository, GitCommandResult> entry : results.entrySet()) {
            grouped.putValue((Object)entry.getValue().getErrorOutputAsHtmlString(), (Object)entry.getKey());
        }
        MultiMap multiMap = grouped;
        if (multiMap == null) {
            GitResetOperation.$$$reportNull$$$0(17);
        }
        return multiMap;
    }

    @NlsSafe
    @NotNull
    private static String joinRepos(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitResetOperation.$$$reportNull$$$0(18);
        }
        String string = StringUtil.join((Iterable)DvcsUtil.sortRepositories(repositories), (String)", ");
        if (string == null) {
            GitResetOperation.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void saveAllDocuments() {
        ApplicationManager.getApplication().invokeAndWait(() -> FileDocumentManager.getInstance().saveAllDocuments());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 15, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCommits";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationPresentation";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detector";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorResults";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/reset/GitResetOperation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/reset/GitResetOperation";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "formErrorReport";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "groupByResult";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "joinRepos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "proposeSmartReset";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyResult";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "formErrorReport";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "groupByResult";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "joinRepos";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 15, 17, 19 -> new IllegalStateException(string);
        };
    }

    @PropertyKey(resourceBundle="messages.GitBundle")
    public static class OperationPresentation {
        public String activityName = "activity.name.reset";
        public String operationTitle = "git.reset.operation";
        public String forceButtonTitle = "git.reset.hard.button";
        public String notificationSuccess = "git.reset.successful.notification.message";
        public String notificationFailure = "git.reset.failed.notification.title";
        public String notificationPartialFailureTitle = "git.reset.partially.failed.notification.title";
        public String notificationPartialFailureMessage = "git.reset.partially.failed.notification.msg";
    }
}

