/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.ui.BranchActionGroup;
import com.intellij.openapi.util.text.HtmlBuilder;
import git4idea.branch.IncomingOutgoingState;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import icons.DvcsImplIcons;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u0013\u0010\u0003\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005*\u00020\u0002H\u0000\u00a8\u0006\u0006"}, d2={"getIcon", "Ljavax/swing/Icon;", "Lgit4idea/branch/IncomingOutgoingState;", "calcTooltip", "", "Lcom/intellij/openapi/util/NlsContexts$Tooltip;", "intellij.vcs.git"})
public final class GitIncomingOutgoingStateKt {
    @Nullable
    public static final Icon getIcon(@NotNull IncomingOutgoingState $this$getIcon) {
        Intrinsics.checkNotNullParameter((Object)$this$getIcon, (String)"<this>");
        boolean hasIncomingIcon = $this$getIcon.hasIncoming() || $this$getIcon.hasUnfetched();
        boolean hasOutgoingIcon = $this$getIcon.hasOutgoing();
        return hasIncomingIcon && hasOutgoingIcon ? BranchActionGroup.getIncomingOutgoingIcon() : (hasIncomingIcon ? DvcsImplIcons.Incoming : (hasOutgoingIcon ? DvcsImplIcons.Outgoing : null));
    }

    @Nullable
    public static final String calcTooltip(@NotNull IncomingOutgoingState $this$calcTooltip) {
        Intrinsics.checkNotNullParameter((Object)$this$calcTooltip, (String)"<this>");
        if (Intrinsics.areEqual((Object)$this$calcTooltip, (Object)IncomingOutgoingState.EMPTY)) {
            return null;
        }
        Set<GitRepository> repositories = $this$calcTooltip.repositories();
        HtmlBuilder html = new HtmlBuilder();
        int totalIncoming = $this$calcTooltip.totalIncoming();
        int totalOutgoing = $this$calcTooltip.totalOutgoing();
        if (repositories.size() == 1) {
            Object[] objectArray;
            if (totalIncoming != 0) {
                objectArray = new Object[]{totalIncoming};
                html.append(GitBundle.message("branches.tooltip.number.incoming.commits", objectArray)).br();
            } else if ($this$calcTooltip.hasUnfetched()) {
                objectArray = new Object[]{totalIncoming};
                html.append(GitBundle.message("branches.tooltip.some.incoming.commits.not.fetched", objectArray)).br();
            }
            if (totalOutgoing != 0) {
                objectArray = new Object[]{totalOutgoing};
                html.append(GitBundle.message("branches.tooltip.number.outgoing.commits", objectArray)).br();
            }
        } else {
            Object[] objectArray;
            if (totalIncoming != 0) {
                objectArray = new Object[]{$this$calcTooltip.totalIncoming(), $this$calcTooltip.reposWithIncoming()};
                html.append(GitBundle.message("branches.tooltip.number.incoming.commits.in.repositories", objectArray)).br();
            } else if ($this$calcTooltip.hasUnfetched()) {
                objectArray = new Object[]{totalIncoming};
                html.append(GitBundle.message("branches.tooltip.some.incoming.commits.not.fetched", objectArray)).br();
            }
            if (totalOutgoing != 0) {
                objectArray = new Object[]{$this$calcTooltip.totalOutgoing(), $this$calcTooltip.reposWithOutgoing()};
                html.append(GitBundle.message("branches.tooltip.number.outgoing.commits.in.repositories", objectArray)).br();
            }
        }
        return html.toString();
    }
}

