/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\bH$J\b\u0010\u0013\u001a\u00020\u0014H$R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/progress/ProgressVisibilityManager;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "indicators", "", "Lcom/intellij/openapi/progress/ProgressIndicator;", "value", "", "disposed", "getDisposed", "()Z", "run", "task", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "dispose", "", "setProgressVisible", "visible", "getModalityState", "Lcom/intellij/openapi/application/ModalityState;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public abstract class ProgressVisibilityManager
implements Disposable {
    @NotNull
    private final List<ProgressIndicator> indicators = new ArrayList();
    private boolean disposed;

    public final boolean getDisposed() {
        return this.disposed;
    }

    @RequiresEdt
    @NotNull
    public final ProgressIndicator run(@NotNull Task.Backgroundable task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        EmptyProgressIndicator indicator = new EmptyProgressIndicator(this.getModalityState());
        this.indicators.add((ProgressIndicator)indicator);
        this.setProgressVisible(true);
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNull((Object)progressManager, (String)"null cannot be cast to non-null type com.intellij.openapi.progress.impl.CoreProgressManager");
        ((CoreProgressManager)progressManager).runProcessWithProgressAsynchronously(task2, (ProgressIndicator)indicator, () -> ProgressVisibilityManager.run$lambda$1(indicator, this));
        return (ProgressIndicator)indicator;
    }

    public void dispose() {
        for (ProgressIndicator indicator : this.indicators) {
            indicator.cancel();
        }
        this.disposed = true;
    }

    protected abstract void setProgressVisible(boolean var1);

    @NotNull
    protected abstract ModalityState getModalityState();

    private static final Unit run$lambda$1$lambda$0(ProgressVisibilityManager this$0, EmptyProgressIndicator $indicator) {
        this$0.indicators.remove($indicator);
        this$0.setProgressVisible(!((Collection)this$0.indicators).isEmpty());
        return Unit.INSTANCE;
    }

    private static final void run$lambda$1(EmptyProgressIndicator $indicator, ProgressVisibilityManager this$0) {
        ActionsKt.runInEdt((ModalityState)$indicator.getModalityState(), () -> ProgressVisibilityManager.run$lambda$1$lambda$0(this$0, $indicator));
    }
}

