/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.sh.ShDocumentationProvider;
import com.intellij.sh.ShTypes;
import com.intellij.sh.psi.ShGenericCommandDirective;
import com.intellij.sh.psi.ShLiteral;
import com.intellij.util.io.URLUtil;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0014\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"TIMEOUT_IN_MILLISECONDS", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "wordWithDocumentation", "", "o", "Lcom/intellij/psi/PsiElement;", "wrapIntoHtml", "", "s", "intellij.sh.core"})
public final class ShDocumentationProviderKt {
    private static final int TIMEOUT_IN_MILLISECONDS = 3000;
    @NotNull
    private static final Logger LOG;

    private static final boolean wordWithDocumentation(PsiElement o) {
        return o instanceof LeafPsiElement && ((LeafPsiElement)o).getElementType() == ShTypes.WORD && ((LeafPsiElement)o).getParent() instanceof ShLiteral && ((LeafPsiElement)o).getParent().getParent() instanceof ShGenericCommandDirective;
    }

    private static final String wrapIntoHtml(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("<html><body><pre>");
        try {
            Matcher matcher = URLUtil.URL_PATTERN.matcher(StringUtil.escapeXmlEntities((String)s));
            Intrinsics.checkNotNullExpressionValue((Object)matcher, (String)"matcher(...)");
            Matcher m = matcher;
            while (m.find()) {
                if (m.groupCount() <= 0) continue;
                String url = m.group(0);
                m.appendReplacement(sb, HtmlChunk.link((String)url, (String)url).toString());
            }
            m.appendTail(sb);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
        sb.append("</pre></body></html>");
        return sb.toString();
    }

    public static final /* synthetic */ boolean access$wordWithDocumentation(PsiElement o) {
        return ShDocumentationProviderKt.wordWithDocumentation(o);
    }

    public static final /* synthetic */ String access$wrapIntoHtml(String s) {
        return ShDocumentationProviderKt.wrapIntoHtml(s);
    }

    static {
        Logger logger = Logger.getInstance(ShDocumentationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

