/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.UriUtil;
import com.intellij.util.text.StringKt;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.FlatSourceMap;
import org.jetbrains.debugger.sourcemap.Offset;
import org.jetbrains.debugger.sourcemap.Section;
import org.jetbrains.debugger.sourcemap.SectionedSourceMap;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceMapV3;
import org.jetbrains.debugger.sourcemap.StringViewCharSequenceKt;
import org.jetbrains.io.JsonReaderEx;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000f"}, d2={"readMap", "Lorg/jetbrains/debugger/sourcemap/SourceMapV3;", "sourceMapData", "", "doParseMap", "reader", "Lorg/jetbrains/io/JsonReaderEx;", "parseSections", "", "Lorg/jetbrains/debugger/sourcemap/Section;", "parseSection", "readSourcePath", "", "readSources", "sourceRoot", "intellij.platform.scriptDebugger.backend"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\norg/jetbrains/debugger/sourcemap/ParserKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n15#2:204\n1#3:205\n*S KotlinDebug\n*F\n+ 1 Parser.kt\norg/jetbrains/debugger/sourcemap/ParserKt\n*L\n73#1:204\n*E\n"})
public final class ParserKt {
    @Nullable
    public static final SourceMapV3 readMap(@NotNull CharSequence sourceMapData) {
        Intrinsics.checkNotNullParameter((Object)sourceMapData, (String)"sourceMapData");
        JsonReaderEx reader = new JsonReaderEx(StringViewCharSequenceKt.wrapWithStringViewIfNeeded(sourceMapData));
        reader.setLenient(true);
        return ParserKt.doParseMap(reader);
    }

    private static final SourceMapV3 doParseMap(JsonReaderEx reader) {
        SourceMapV3 sourceMapV3;
        if (reader.peek() == JsonToken.NULL) {
            reader.close();
            return null;
        }
        int version = -1;
        String file = null;
        JsonReaderEx sectionsReader = null;
        String sourceRoot = null;
        JsonReaderEx sourcesReader = null;
        List sourcesContent = null;
        List names = null;
        CharSequence encodedMappings = null;
        List ignoreList = null;
        reader.beginObject();
        block27: while (reader.hasNext()) {
            block49: {
                String string = reader.nextName();
                if (string == null) break block49;
                int n = -1;
                switch (string.hashCode()) {
                    case -1111500899: {
                        if (string.equals("sourceRoot")) {
                            n = 1;
                        }
                        break;
                    }
                    case 194445669: {
                        if (string.equals("mappings")) {
                            n = 2;
                        }
                        break;
                    }
                    case 3143036: {
                        if (string.equals("file")) {
                            n = 3;
                        }
                        break;
                    }
                    case 104585032: {
                        if (string.equals("names")) {
                            n = 4;
                        }
                        break;
                    }
                    case -2021876808: {
                        if (string.equals("sources")) {
                            n = 5;
                        }
                        break;
                    }
                    case -1867796657: {
                        if (string.equals("x_google_ignoreList")) {
                            n = 6;
                        }
                        break;
                    }
                    case -252243551: {
                        if (string.equals("sourcesContent")) {
                            n = 7;
                        }
                        break;
                    }
                    case 880339344: {
                        if (string.equals("ignoreList")) {
                            n = 6;
                        }
                        break;
                    }
                    case 351608024: {
                        if (string.equals("version")) {
                            n = 8;
                        }
                        break;
                    }
                    case 947936814: {
                        if (string.equals("sections")) {
                            n = 9;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        version = reader.nextInt();
                        continue block27;
                    }
                    case 3: {
                        file = reader.nextNullableString();
                        continue block27;
                    }
                    case 9: {
                        sectionsReader = reader.createSubReaderAndSkipValue();
                        continue block27;
                    }
                    case 1: {
                        sourceRoot = StringKt.nullize$default((String)ParserKt.readSourcePath(reader), (boolean)false, (int)1, null);
                        if (sourceRoot == null || Intrinsics.areEqual((Object)sourceRoot, (Object)"/")) continue block27;
                        sourceRoot = UriUtil.trimTrailingSlashes((String)sourceRoot);
                        continue block27;
                    }
                    case 5: {
                        sourcesReader = reader.createSubReaderAndSkipValue();
                        continue block27;
                    }
                    case 7: {
                        if (reader.peek() == JsonToken.NULL) {
                            reader.nextNull();
                            continue block27;
                        }
                        reader.beginArray();
                        if (reader.peek() != JsonToken.END_ARRAY) {
                            sourcesContent = (List)new SmartList();
                            do {
                                JsonToken jsonToken = reader.peek();
                                switch (jsonToken == null ? -1 : WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                                    case 1: {
                                        ((SmartList)sourcesContent).add((Object)((Object)StringUtilRt.convertLineSeparators((CharSequence)reader.nextCharSequence(), (String)"\n")).toString());
                                        break;
                                    }
                                    case 2: {
                                        ((SmartList)sourcesContent).add(null);
                                        reader.nextNull();
                                        break;
                                    }
                                    default: {
                                        boolean $i$f$logger = false;
                                        Logger logger = Logger.getInstance(SourceMap.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                                        logger.warn("Unknown sourcesContent element: " + reader.peek().name());
                                        reader.skipValue();
                                    }
                                }
                            } while (reader.hasNext());
                        }
                        reader.endArray();
                        continue block27;
                    }
                    case 4: {
                        names = new ArrayList();
                        reader.beginArray();
                        while (reader.hasNext()) {
                            String string2 = reader.nextString(true);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"nextString(...)");
                            names.add(string2);
                        }
                        reader.endArray();
                        continue block27;
                    }
                    case 2: {
                        encodedMappings = reader.nextCharSequence();
                        continue block27;
                    }
                    case 6: {
                        ignoreList = new ArrayList();
                        reader.beginArray();
                        while (reader.hasNext()) {
                            ignoreList.add(reader.nextInt());
                        }
                        reader.endArray();
                        continue block27;
                    }
                }
            }
            reader.skipValue();
        }
        reader.close();
        if (version != 3) {
            throw new IOException("Unsupported sourcemap version: " + version);
        }
        if (sectionsReader != null) {
            List<Section> sections = ParserKt.parseSections(sectionsReader);
            sourceMapV3 = new SectionedSourceMap(version, file, sections);
        } else {
            if (encodedMappings == null) {
                throw new IOException("Source map doesn't contain 'mappings' field");
            }
            if (sourcesReader == null) {
                throw new IOException("Source map doesn't contain 'sources' field");
            }
            List<String> sources = ParserKt.readSources(sourcesReader, sourceRoot);
            sourceMapV3 = new FlatSourceMap(version, file, sources, sourcesContent, sourceRoot, names, encodedMappings, ignoreList);
        }
        return sourceMapV3;
    }

    private static final List<Section> parseSections(JsonReaderEx reader) {
        List result2 = new ArrayList();
        reader.beginArray();
        while (reader.hasNext()) {
            Section section;
            block4: {
                block3: {
                    JsonReaderEx jsonReaderEx = reader.createSubReaderAndSkipValue();
                    if (jsonReaderEx == null) break block3;
                    JsonReaderEx it = jsonReaderEx;
                    boolean bl = false;
                    section = ParserKt.parseSection(it);
                    if (section != null) break block4;
                }
                throw new IOException("Cannot parse source map section");
            }
            Section section2 = section;
            result2.add(section2);
        }
        reader.endArray();
        return result2;
    }

    private static final Section parseSection(JsonReaderEx reader) {
        reader.beginObject();
        Offset offset = null;
        SourceMapV3 map = null;
        while (reader.hasNext()) {
            String string = reader.nextName();
            if (Intrinsics.areEqual((Object)string, (Object)"offset")) {
                reader.beginObject();
                int line = 0;
                int column = 0;
                while (reader.hasNext()) {
                    String string2 = reader.nextName();
                    if (Intrinsics.areEqual((Object)string2, (Object)"line")) {
                        line = reader.nextInt();
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)string2, (Object)"column")) {
                        column = reader.nextInt();
                        continue;
                    }
                    reader.skipValue();
                }
                offset = new Offset(line, column);
                reader.endObject();
                continue;
            }
            if (Intrinsics.areEqual((Object)string, (Object)"map")) {
                SourceMapV3 sourceMapV3;
                if (reader.createSubReaderAndSkipValue() != null) {
                    JsonReaderEx it;
                    boolean bl = false;
                    sourceMapV3 = ParserKt.doParseMap(it);
                } else {
                    sourceMapV3 = null;
                }
                map = sourceMapV3;
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        if (offset == null || map == null) {
            return null;
        }
        return new Section(offset, map);
    }

    private static final String readSourcePath(JsonReaderEx reader) {
        String string = reader.nextNullableString();
        return PathUtil.toSystemIndependentName((String)(string != null ? ((Object)StringsKt.trim((CharSequence)string)).toString() : null));
    }

    private static final List<String> readSources(JsonReaderEx reader, String sourceRoot) {
        reader.beginArray();
        List sources = null;
        if (reader.peek() == JsonToken.END_ARRAY) {
            sources = CollectionsKt.emptyList();
        } else {
            sources = (List)new SmartList();
            do {
                CharSequence charSequence;
                Object sourceUrl;
                Object object;
                if ((object = ParserKt.readSourcePath(reader)) == null) {
                    object = sourceUrl = "";
                }
                if (!((charSequence = (CharSequence)sourceRoot) == null || charSequence.length() == 0)) {
                    sourceUrl = Intrinsics.areEqual((Object)sourceRoot, (Object)"/") ? "/" + (String)sourceUrl : sourceRoot + "/" + (String)sourceUrl;
                }
                ((SmartList)sources).add(sourceUrl);
            } while (reader.hasNext());
        }
        reader.endArray();
        return sources;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsonToken.values().length];
            try {
                nArray[JsonToken.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsonToken.NULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

