/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.refactoring;

import com.intellij.codeInsight.completion.TagNameReferenceCompletionProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XmlTagRenameDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance(XmlTagRenameDialog.class);
    private final PsiElement myElement;
    private final Editor myEditor;
    private JLabel myTitleLabel;
    private NameSuggestionsField myNameSuggestionsField;
    private final XmlTag myTag;
    private NameSuggestionsField.DataChanged myNameChangedListener;

    public XmlTagRenameDialog(@NotNull Editor editor, @NotNull PsiElement element, @NotNull XmlTag tag) {
        if (editor == null) {
            XmlTagRenameDialog.$$$reportNull$$$0(0);
        }
        if (element == null) {
            XmlTagRenameDialog.$$$reportNull$$$0(1);
        }
        if (tag == null) {
            XmlTagRenameDialog.$$$reportNull$$$0(2);
        }
        super(element.getProject(), true);
        this.myEditor = editor;
        this.myElement = element;
        this.myTag = tag;
        this.setTitle(RefactoringBundle.message((String)"rename.title"));
        this.createNewNameComponent();
        this.init();
        this.myTitleLabel.setText(XmlBundle.message((String)"xml.refactor.rename.current.tag", (Object[])new Object[]{XmlTagRenameDialog.getFullName(tag)}));
        this.validateButtons();
    }

    protected void dispose() {
        this.myNameSuggestionsField.removeDataChangedListener(this.myNameChangedListener);
        super.dispose();
    }

    protected boolean hasHelpAction() {
        return false;
    }

    private static String getFullName(@NotNull XmlTag tag) {
        if (tag == null) {
            XmlTagRenameDialog.$$$reportNull$$$0(3);
        }
        String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)tag);
        return (UsageViewUtil.getType((PsiElement)tag) + " " + name).trim();
    }

    public static void renameXmlTag(Editor editor, @NotNull PsiElement element, @NotNull XmlTag tag) {
        if (element == null) {
            XmlTagRenameDialog.$$$reportNull$$$0(4);
        }
        if (tag == null) {
            XmlTagRenameDialog.$$$reportNull$$$0(5);
        }
        XmlTagRenameDialog dialog = new XmlTagRenameDialog(editor, element, tag);
        dialog.show();
    }

    private void createNewNameComponent() {
        this.myNameSuggestionsField = new NameSuggestionsField(new String[]{this.myTag.getName()}, this.myProject, (FileType)FileTypes.PLAIN_TEXT, this.myEditor);
        this.myNameChangedListener = () -> this.validateButtons();
        this.myNameSuggestionsField.addDataChangedListener(this.myNameChangedListener);
        this.myNameSuggestionsField.getComponent().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                XmlTagRenameDialog.this.completeVariable(XmlTagRenameDialog.this.myNameSuggestionsField.getEditor());
            }
        }, KeyStroke.getKeyStroke(32, 2), 2);
    }

    private void completeVariable(Editor editor) {
        String prefix = this.myNameSuggestionsField.getEnteredName();
        PsiReference reference = this.myTag.getReference();
        if (reference instanceof TagNameReference) {
            LookupElement[] lookupItems = TagNameReferenceCompletionProvider.getTagNameVariants(this.myTag, this.myTag.getNamespacePrefix());
            editor.getCaretModel().moveToOffset(prefix.length());
            editor.getSelectionModel().removeSelection();
            LookupManager.getInstance((Project)this.getProject()).showLookup(editor, lookupItems, prefix);
        }
    }

    protected void doAction() {
        LOG.assertTrue(this.myElement.isValid());
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                this.myTag.setName(this.getNewName());
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }), RefactoringBundle.message((String)"rename.title"), null);
        this.close(0);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameSuggestionsField.getFocusableComponent();
    }

    protected JComponent createNorthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        this.myTitleLabel = new JLabel();
        panel.add(this.myTitleLabel);
        panel.add(Box.createVerticalStrut(8));
        panel.add(this.myNameSuggestionsField.getComponent());
        return panel;
    }

    public String getNewName() {
        return this.myNameSuggestionsField.getEnteredName().trim();
    }

    protected void validateButtons() {
        super.validateButtons();
        this.getPreviewAction().setEnabled(false);
    }

    protected boolean areButtonsValid() {
        String newName = this.getNewName();
        return !StringUtil.containsAnyChar((String)newName, (String)"\t ;*'\"\\/,()^&<>={}");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xml/refactoring/XmlTagRenameDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getFullName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "renameXmlTag";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

