/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webSymbols.highlighting.impl;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.webSymbols.WebSymbol;
import com.intellij.webSymbols.WebSymbolNameSegment;
import com.intellij.webSymbols.WebSymbolQualifiedKind;
import com.intellij.webSymbols.declarations.WebSymbolDeclaration;
import com.intellij.webSymbols.declarations.WebSymbolDeclarationProvider;
import com.intellij.webSymbols.highlighting.WebSymbolHighlightingCustomizer;
import com.intellij.webSymbols.highlighting.WebSymbolsHighlightingUtilsKt;
import com.intellij.webSymbols.highlighting.impl.InspectionToolInfo;
import com.intellij.webSymbols.highlighting.impl.WebSymbolsHighlightingAnnotatorKt;
import com.intellij.webSymbols.impl.WebSymbolNameSegmentImpl;
import com.intellij.webSymbols.impl.WebSymbolsImplUtilsKt;
import com.intellij.webSymbols.inspections.impl.WebSymbolsInspectionToolMappingEP;
import com.intellij.webSymbols.references.WebSymbolReference;
import com.intellij.webSymbols.references.WebSymbolReferenceProblem;
import com.intellij.webSymbols.references.impl.PsiWebSymbolReferenceProviderImpl;
import com.intellij.webSymbols.utils.WebSymbolUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J.\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000bH\u0002J6\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00190\u001e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/webSymbols/highlighting/impl/WebSymbolsHighlightingAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "symbolReferencesProvider", "Lcom/intellij/webSymbols/references/impl/PsiWebSymbolReferenceProviderImpl;", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "highlightSymbols", "offsetInFile", "", "topLevelSymbols", "", "Lcom/intellij/webSymbols/WebSymbol;", "host", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "annotateReference", "reference", "Lcom/intellij/webSymbols/references/WebSymbolReference;", "getInspectionInfo", "", "Lcom/intellij/webSymbols/highlighting/impl/InspectionToolInfo;", "Lcom/intellij/webSymbols/references/WebSymbolReferenceProblem;", "problemKind", "Lcom/intellij/webSymbols/references/WebSymbolReferenceProblem$ProblemKind;", "map", "", "", "createToolInfo", "toolShortName", "psiFile", "Lcom/intellij/psi/PsiFile;", "SegmentHighlightingInfo", "intellij.platform.webSymbols"})
@SourceDebugExtension(value={"SMAP\nWebSymbolsHighlightingAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSymbolsHighlightingAnnotator.kt\ncom/intellij/webSymbols/highlighting/impl/WebSymbolsHighlightingAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 6 WebSymbolUtils.kt\ncom/intellij/webSymbols/utils/WebSymbolUtils\n*L\n1#1,304:1\n774#2:305\n865#2,2:306\n1863#2,2:308\n1863#2,2:310\n1863#2,2:312\n1557#2:314\n1628#2,3:315\n1755#2,3:319\n1863#2:322\n1557#2:323\n1628#2,3:324\n1864#2:327\n1863#2:336\n1755#2,3:337\n1557#2:340\n1628#2,3:341\n1864#2:350\n1611#2,9:351\n1863#2:360\n1864#2:362\n1620#2:363\n1557#2:364\n1628#2,3:365\n774#2:368\n865#2,2:369\n1663#2,8:371\n1#3:318\n1#3:361\n1317#4,2:328\n68#5,6:330\n43#6,3:344\n43#6,3:347\n*S KotlinDebug\n*F\n+ 1 WebSymbolsHighlightingAnnotator.kt\ncom/intellij/webSymbols/highlighting/impl/WebSymbolsHighlightingAnnotator\n*L\n65#1:305\n65#1:306,2\n66#1:308,2\n72#1:310,2\n77#1:312,2\n95#1:314\n95#1:315,3\n116#1:319,3\n139#1:322\n141#1:323\n141#1:324,3\n139#1:327\n195#1:336\n197#1:337,3\n212#1:340\n212#1:341,3\n195#1:350\n239#1:351,9\n239#1:360\n239#1:362\n239#1:363\n241#1:364\n241#1:365,3\n169#1:368\n169#1:369,2\n170#1:371,8\n239#1:361\n177#1:328,2\n191#1:330,6\n221#1:344,3\n227#1:347,3\n*E\n"})
public final class WebSymbolsHighlightingAnnotator
implements Annotator {
    @NotNull
    private final PsiWebSymbolReferenceProviderImpl symbolReferencesProvider = new PsiWebSymbolReferenceProviderImpl();

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (element instanceof PsiExternalReferenceHost) {
            Iterator $this$filterTo$iv$iv;
            Collection collection = PsiSymbolReferenceService.getService().getReferences(element, WebSymbolReference.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getReferences(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv$iv = iterator.next();
                WebSymbolReference it = (WebSymbolReference)element$iv$iv;
                boolean bl = false;
                boolean bl2 = !it.getProblems().isEmpty();
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WebSymbolReference ref = (WebSymbolReference)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)ref);
                this.annotateReference(ref, holder);
            }
            MultiMap multiMap = ((MultiMap)this.symbolReferencesProvider.getSymbolOffsetsAndReferences$intellij_platform_webSymbols((PsiExternalReferenceHost)element).getFirst()).copy();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"copy(...)");
            MultiMap multiMap2 = multiMap;
            Iterable $this$forEach$iv2 = WebSymbolDeclarationProvider.Companion.getAllDeclarations(element, -1);
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                WebSymbolDeclaration declaration = (WebSymbolDeclaration)element$iv;
                boolean bl = false;
                multiMap2.putValue((Object)declaration.getRangeInDeclaringElement().getStartOffset(), (Object)declaration.getSymbol());
            }
            int elementOffset = ((PsiExternalReferenceHost)element).getTextOffset();
            Set set = multiMap2.entrySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
            Iterable $this$forEach$iv3 = set;
            boolean $i$f$forEach3 = false;
            for (Object element$iv : $this$forEach$iv3) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)entry);
                Integer offset = (Integer)entry.getKey();
                Collection symbols = (Collection)entry.getValue();
                Intrinsics.checkNotNull((Object)offset);
                int n = elementOffset + offset;
                Intrinsics.checkNotNull((Object)symbols);
                this.highlightSymbols(n, symbols, (PsiExternalReferenceHost)element, holder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void highlightSymbols(int offsetInFile, Collection<? extends WebSymbol> topLevelSymbols, PsiExternalReferenceHost host, AnnotationHolder holder) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        MultiMap result2 = new MultiMap();
        Iterable $this$map$iv = topLevelSymbols;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WebSymbol webSymbol = (WebSymbol)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SegmentHighlightingInfo(WebSymbolNameSegment.Companion.create((WebSymbol)it), offsetInFile, 0, null, WebSymbolHighlightingCustomizer.Companion.getDefaultHostTextAttributes$intellij_platform_webSymbols(host), CollectionsKt.emptyList()));
        }
        Collection collection = (List)destination$iv$iv;
        LinkedList<SegmentHighlightingInfo> queue = new LinkedList<SegmentHighlightingInfo>(collection);
        Set processedSymbols = new LinkedHashSet();
        while (!((Collection)queue).isEmpty()) {
            TextAttributesKey textAttributesKey;
            boolean bl;
            TextRange range;
            List<WebSymbol> symbols;
            List<Pair<Integer, WebSymbolNameSegment>> additionalChildSegments;
            TextAttributesKey parentTextAttributesKey;
            WebSymbolQualifiedKind parentKind;
            int depth;
            int offset;
            WebSymbolNameSegment nameSegment;
            block16: {
                TextAttributesKey it;
                SegmentHighlightingInfo $i$f$map2 = (SegmentHighlightingInfo)queue.removeFirst();
                nameSegment = $i$f$map2.component1();
                offset = $i$f$map2.component2();
                depth = $i$f$map2.component3();
                parentKind = $i$f$map2.component4();
                parentTextAttributesKey = $i$f$map2.component5();
                additionalChildSegments = $i$f$map2.component6();
                symbols = nameSegment.getSymbols();
                int n = nameSegment.getStart() + offset;
                Intrinsics.checkNotNull((Object)nameSegment, (String)"null cannot be cast to non-null type com.intellij.webSymbols.impl.WebSymbolNameSegmentImpl");
                WebSymbolNameSegmentImpl webSymbolNameSegmentImpl = (WebSymbolNameSegmentImpl)nameSegment;
                int n2 = n;
                boolean bl22 = false;
                Integer n3 = it.getHighlightingEnd$intellij_platform_webSymbols();
                int n4 = n3 != null ? n3.intValue() : it.getEnd();
                int n5 = n4 + offset;
                int n6 = n2;
                range = new TextRange(n6, n5);
                if (symbols.isEmpty()) {
                    WebSymbolQualifiedKind segmentKind = (WebSymbolQualifiedKind)CollectionsKt.singleOrNull((Iterable)((WebSymbolNameSegmentImpl)nameSegment).getSymbolKinds());
                    if (((WebSymbolNameSegmentImpl)nameSegment).getProblem() != WebSymbolNameSegment.MatchProblem.UNKNOWN_SYMBOL || segmentKind == null || (it = WebSymbolHighlightingCustomizer.Companion.getTextAttributesFor$intellij_platform_webSymbols(segmentKind)) == null) continue;
                    TextAttributesKey textAttributesKey2 = it;
                    TextAttributesKey it2 = textAttributesKey2;
                    boolean bl3 = false;
                    Object bl22 = !Intrinsics.areEqual((Object)it2, (Object)parentTextAttributesKey) ? textAttributesKey2 : null;
                    if (bl22 == null) continue;
                    it2 = bl22;
                    boolean bl4 = false;
                    result2.putValue((Object)range, (Object)new Pair((Object)depth, (Object)it2));
                    continue;
                }
                Iterable $this$any$iv = symbols;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        WebSymbol it3 = (WebSymbol)element$iv;
                        boolean bl5 = false;
                        if (!Intrinsics.areEqual((Object)it3.getProperties().get("ij-no-psi-refs"), (Object)true)) continue;
                        bl = true;
                        break block16;
                    }
                    bl = false;
                }
            }
            if (bl || WebSymbolUtils.hasOnlyExtensions(symbols) || range.getLength() <= 0) continue;
            TextAttributesKey $i$f$any = (TextAttributesKey)SequencesKt.singleOrNull((Sequence)SequencesKt.distinct((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)symbols), WebSymbolsHighlightingAnnotator::highlightSymbols$lambda$9), arg_0 -> WebSymbolsHighlightingAnnotator.highlightSymbols$lambda$12(host, depth, parentKind, arg_0))));
            if ($i$f$any != null) {
                TextAttributesKey bl22;
                TextAttributesKey it = bl22 = $i$f$any;
                boolean bl6 = false;
                v3 = !Intrinsics.areEqual((Object)it, (Object)parentTextAttributesKey) ? bl22 : null;
            } else {
                v3 = textAttributesKey = null;
            }
            if (textAttributesKey != null) {
                TextAttributesKey it;
                boolean bl7 = false;
                result2.putValue((Object)range, (Object)new Pair((Object)depth, (Object)it));
            }
            Iterable $this$forEach$iv2 = symbols;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv2) {
                void $this$mapTo$iv$iv2;
                WebSymbol s = (WebSymbol)element$iv;
                boolean bl8 = false;
                if (!processedSymbols.add(s)) continue;
                Iterable $this$map$iv2 = WebSymbolUtils.getNameSegments(s);
                boolean $i$f$map3 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    WebSymbolNameSegment webSymbolNameSegment = (WebSymbolNameSegment)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl9 = false;
                    collection2.add(TuplesKt.to((Object)(offset + ((WebSymbolNameSegmentImpl)nameSegment).getStart()), (Object)it));
                }
                List allNestedSegments = CollectionsKt.plus((Collection)((List)destination$iv$iv2), (Iterable)additionalChildSegments);
                int i = 0;
                while (i < allNestedSegments.size()) {
                    Pair pair = (Pair)allNestedSegments.get(i++);
                    int nestedOffset = ((Number)pair.component1()).intValue();
                    WebSymbolNameSegment segment = (WebSymbolNameSegment)pair.component2();
                    if (segment.getStart() == segment.getEnd()) continue;
                    SmartList segmentNestedSegments = new SmartList();
                    Integer n = WebSymbolsImplUtilsKt.getHighlightingEnd(segment);
                    if ((n != null ? n.intValue() : segment.getEnd()) != segment.getEnd() && !((Collection)segment.getSymbols()).isEmpty()) {
                        while (i < allNestedSegments.size()) {
                            Pair pair2 = (Pair)allNestedSegments.get(i);
                            int offset2 = ((Number)pair2.component1()).intValue();
                            WebSymbolNameSegment segment2 = (WebSymbolNameSegment)pair2.component2();
                            int n7 = segment2.getEnd() + offset2;
                            Integer n8 = WebSymbolsImplUtilsKt.getHighlightingEnd(segment);
                            Intrinsics.checkNotNull((Object)n8);
                            if (n7 > n8 + nestedOffset) break;
                            segmentNestedSegments.add((Object)TuplesKt.to((Object)offset2, (Object)segment2));
                            ++i;
                        }
                    }
                    WebSymbolQualifiedKind webSymbolQualifiedKind = WebSymbolUtils.getQualifiedKind(s);
                    TextAttributesKey textAttributesKey3 = textAttributesKey;
                    if (textAttributesKey3 == null) {
                        textAttributesKey3 = parentTextAttributesKey;
                    }
                    queue.add(new SegmentHighlightingInfo(segment, nestedOffset, depth + 1, webSymbolQualifiedKind, textAttributesKey3, (List)segmentNestedSegments));
                }
            }
        }
        Set set = result2.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entrySet(...)");
        Sequence sequence = SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)set), WebSymbolsHighlightingAnnotator::highlightSymbols$lambda$21);
        Comparator<Object> comparator2 = Comparator.comparingInt(arg_0 -> WebSymbolsHighlightingAnnotator.highlightSymbols$lambda$23(WebSymbolsHighlightingAnnotator::highlightSymbols$lambda$22, arg_0)).thenComparingInt(arg_0 -> WebSymbolsHighlightingAnnotator.highlightSymbols$lambda$25(WebSymbolsHighlightingAnnotator::highlightSymbols$lambda$24, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator2, (String)"thenComparingInt(...)");
        Sequence $i$f$map2 = SequencesKt.sortedWith((Sequence)sequence, comparator2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            TextRange range = (TextRange)pair.component1();
            TextAttributesKey textAttributesKey = (TextAttributesKey)pair.component2();
            HighlightSeverity highlightSeverity = HighlightInfoType.SYMBOL_TYPE_SEVERITY;
            Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"SYMBOL_TYPE_SEVERITY");
            String string = textAttributesKey.getExternalName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExternalName(...)");
            WebSymbolsHighlightingUtilsKt.newSilentAnnotationWithDebugInfo(holder, highlightSeverity, string).textAttributes(textAttributesKey).needsUpdateOnTyping().range(range).create();
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void annotateReference(WebSymbolReference reference, AnnotationHolder holder) {
        v0 = holder.getCurrentAnnotationSession();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCurrentAnnotationSession(...)");
        var4_3 = (UserDataHolder)v0;
        key$iv = WebSymbolsHighlightingAnnotatorKt.access$getINSPECTION_TOOL_INFO_CACHE$p();
        $i$f$getOrCreateUserDataUnsafe = false;
        existing$iv = $this$getOrCreateUserDataUnsafe$iv.getUserData(key$iv);
        v1 = existing$iv;
        if (v1 == null) {
            $i$a$-getOrCreateUserDataUnsafe-WebSymbolsHighlightingAnnotator$annotateReference$map$1 = false;
            value$iv = new LinkedHashMap<K, V>();
            $this$getOrCreateUserDataUnsafe$iv.putUserData(key$iv, (Object)value$iv);
            v1 = value$iv;
        }
        map = (Map)v1;
        v2 = reference.getElement().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getProject(...)");
        project = v2;
        v3 = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getCurrentProfile(...)");
        inspectionProfile = v3;
        $this$forEach$iv = reference.getProblems();
        $i$f$forEach = false;
        for (T element$iv : $this$forEach$iv) {
            block28: {
                block26: {
                    block25: {
                        block27: {
                            problem = (WebSymbolReferenceProblem)element$iv;
                            $i$a$-forEach-WebSymbolsHighlightingAnnotator$annotateReference$1 = false;
                            v4 = problem.getKind();
                            Intrinsics.checkNotNull((Object)map);
                            inspectionInfos = this.getInspectionInfo(problem, v4, map, holder);
                            if (!(((Collection)inspectionInfos).isEmpty() == false)) break block26;
                            $this$any$iv = inspectionInfos;
                            $i$f$any = false;
                            if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block27;
                            v5 = false;
                            break block25;
                        }
                        for (T element$iv : $this$any$iv) {
                            it = (InspectionToolInfo)element$iv;
                            $i$a$-any-WebSymbolsHighlightingAnnotator$annotateReference$1$1 = false;
                            if (!it.getEnabled()) ** GOTO lbl-1000
                            v6 = reference.getElement();
                            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getElement(...)");
                            if (it.isSuppressedFor(v6)) lbl-1000:
                            // 2 sources

                            {
                                v7 = true;
                            } else {
                                v7 = false;
                            }
                            if (!v7) continue;
                            v5 = true;
                            break block25;
                        }
                        v5 = false;
                    }
                    if (v5) continue;
                }
                firstTool = (InspectionToolInfo)CollectionsKt.firstOrNull(inspectionInfos);
                descriptor = problem.getDescriptor();
                v8 = descriptor instanceof ProblemDescriptorBase != false ? (ProblemDescriptorBase)descriptor : null;
                if (v8 == null || (v8 = v8.getEnforcedTextAttributes()) == null) {
                    if (descriptor.getHighlightType() == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
                        if (firstTool != null) {
                            $i$a$-let-WebSymbolsHighlightingAnnotator$annotateReference$1$attributesKey$1 = false;
                            v8 = inspectionProfile.getEditorAttributes(it.getShortName(), reference.getElement());
                        } else {
                            v8 = null;
                        }
                    } else {
                        v8 = null;
                    }
                }
                attributesKey = v8;
                v9 = firstTool;
                highlightDisplayKey = v9 != null ? v9.getHighlightDisplayKey() : null;
                $i$a$-any-WebSymbolsHighlightingAnnotator$annotateReference$1$1 = descriptor.getFixes();
                if ($i$a$-any-WebSymbolsHighlightingAnnotator$annotateReference$1$1 != null && (it = ArraysKt.getIndices((Object[])$i$a$-any-WebSymbolsHighlightingAnnotator$annotateReference$1$1)) != null) {
                    var21_27 = (Iterable)it;
                    $i$f$map = false;
                    var23_34 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    var26_49 = $this$mapTo$iv$iv.iterator();
                    while (var26_49.hasNext()) {
                        var28_52 = item$iv$iv = ((IntIterator)var26_49).nextInt();
                        var29_53 = destination$iv$iv;
                        $i$a$-map-WebSymbolsHighlightingAnnotator$annotateReference$1$descriptorFixes$1 = false;
                        var29_53.add(QuickFixWrapper.wrap((ProblemDescriptor)descriptor, (int)it));
                    }
                    it = $this$map$iv = (List)destination$iv$iv;
                    $i$a$-takeIf-WebSymbolsHighlightingAnnotator$annotateReference$1$descriptorFixes$2 = false;
                    v10 = !((Collection)it).isEmpty() ? $this$map$iv : null;
                } else {
                    v10 = null;
                }
                descriptorFixes = v10;
                $this$map$iv = ((Iterable)inspectionInfos).iterator();
                if (!$this$map$iv.hasNext()) {
                    v11 = null;
                } else {
                    it = (InspectionToolInfo)$this$map$iv.next();
                    $i$a$-minOfOrNull-WebSymbolsHighlightingAnnotator$annotateReference$1$severity$1 = false;
                    it = (Comparable)it.getSeverity();
                    while ($this$map$iv.hasNext()) {
                        it = (InspectionToolInfo)$this$map$iv.next();
                        $i$a$-minOfOrNull-WebSymbolsHighlightingAnnotator$annotateReference$1$severity$1 = false;
                        if (it.compareTo(it = (Comparable)it.getSeverity()) <= 0) continue;
                        it = it;
                    }
                    v11 = it;
                }
                if ((v12 = (HighlightSeverity)v11) == null) {
                    v12 = WebSymbolsHighlightingAnnotatorKt.access$getDefaultSeverity(problem.getKind());
                }
                severity = v12;
                Intrinsics.checkNotNullExpressionValue((Object)ProblemDescriptorUtil.renderDescriptionMessage((CommonProblemDescriptor)((CommonProblemDescriptor)descriptor), (PsiElement)reference.getElement(), (int)0), (String)"renderDescriptionMessage(...)");
                $i$a$-let-WebSymbolsHighlightingAnnotator$annotateReference$1$attributesKey$1 = holder.newAnnotation(severity, message).range(reference.getAbsoluteRange()).highlightType(descriptor.getHighlightType()).tooltip(message).needsUpdateOnTyping();
                $i$f$applyIfNotNull = false;
                if (attributesKey != null) {
                    it = attributesKey;
                    $this$annotateReference_u24lambda_u2438_u24lambda_u2433 = $this$applyIfNotNull$iv;
                    $i$a$-applyIfNotNull-WebSymbolsHighlightingAnnotator$annotateReference$1$2 = false;
                    v13 = $this$annotateReference_u24lambda_u2438_u24lambda_u2433.textAttributes((TextAttributesKey)it);
                } else {
                    v13 = $this$applyIfNotNull$iv;
                }
                $this$annotateReference_u24lambda_u2438_u24lambda_u2437 = var20_25 = v13;
                $i$a$-apply-WebSymbolsHighlightingAnnotator$annotateReference$1$3 = false;
                v14 = descriptorFixes;
                if (v14 != null) break block28;
                if (highlightDisplayKey == null) ** GOTO lbl-1000
                it /* !! */  = highlightDisplayKey;
                $i$a$-let-WebSymbolsHighlightingAnnotator$annotateReference$1$3$1 = false;
                $i$f$mapTo = HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)it /* !! */ );
                if ($i$f$mapTo != null) {
                    it /* !! */  = $i$f$mapTo;
                    $i$a$-let-WebSymbolsHighlightingAnnotator$annotateReference$1$3$2 = false;
                    v15 = CollectionsKt.listOf((Object)new EmptyIntentionAction((String)it /* !! */ ));
                } else lbl-1000:
                // 2 sources

                {
                    v15 = v14 = null;
                }
                if (v15 == null) {
                    v14 = CollectionsKt.emptyList();
                }
            }
            var26_49 = v14.iterator();
            while (var26_49.hasNext()) {
                v16 = var26_49.next();
                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"next(...)");
                fix = (IntentionAction)v16;
                $i$f$mapTo = $this$annotateReference_u24lambda_u2438_u24lambda_u2437.newFix(fix).range(reference.getAbsoluteRange());
                $i$f$applyIfNotNull = false;
                if (highlightDisplayKey != null) {
                    it = highlightDisplayKey;
                    $this$annotateReference_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436 = $this$applyIfNotNull$iv;
                    $i$a$-applyIfNotNull-WebSymbolsHighlightingAnnotator$annotateReference$1$3$3 = false;
                    v17 = $this$annotateReference_u24lambda_u2438_u24lambda_u2437_u24lambda_u2436.key(it);
                } else {
                    v17 = $this$applyIfNotNull$iv;
                }
                v17.registerFix();
            }
            var20_25.create();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<InspectionToolInfo> getInspectionInfo(WebSymbolReferenceProblem $this$getInspectionInfo, WebSymbolReferenceProblem.ProblemKind problemKind, Map<String, InspectionToolInfo> map, AnnotationHolder holder) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Iterable iterable = $this$getInspectionInfo.getSymbolKinds();
        boolean $i$f$mapNotNull = false;
        void var7_7 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            WebSymbolQualifiedKind symbolType = (WebSymbolQualifiedKind)element$iv$iv;
            boolean bl2 = false;
            WebSymbolsInspectionToolMappingEP webSymbolsInspectionToolMappingEP = WebSymbolsInspectionToolMappingEP.Companion.get(symbolType.getNamespace(), symbolType.getKind(), problemKind);
            if ((webSymbolsInspectionToolMappingEP != null ? webSymbolsInspectionToolMappingEP.toolShortName : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(map.computeIfAbsent((String)it, arg_0 -> WebSymbolsHighlightingAnnotator.getInspectionInfo$lambda$42$lambda$41(arg_0 -> WebSymbolsHighlightingAnnotator.getInspectionInfo$lambda$42$lambda$40(this, holder, arg_0), arg_0)));
        }
        return (List)destination$iv$iv;
    }

    private final InspectionToolInfo createToolInfo(String toolShortName, PsiFile psiFile) {
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)psiFile.getProject()).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper = profile.getInspectionTool(toolShortName, (PsiElement)psiFile);
        if (inspectionToolWrapper == null) {
            WebSymbolsHighlightingAnnotator $this$createToolInfo_u24lambda_u2443 = this;
            boolean bl = false;
            if (ApplicationManager.getApplication().isUnitTestMode() && !InspectionProfileImpl.INIT_INSPECTIONS) {
                HighlightSeverity highlightSeverity = HighlightSeverity.WEAK_WARNING;
                Intrinsics.checkNotNullExpressionValue((Object)highlightSeverity, (String)"WEAK_WARNING");
                return new InspectionToolInfo(toolShortName, false, null, null, highlightSeverity);
            }
            throw new IllegalStateException("Cannot find inspection tool with name " + toolShortName);
        }
        InspectionToolWrapper tool = inspectionToolWrapper;
        HighlightDisplayKey highlightDisplayKey = HighlightDisplayKey.find((String)toolShortName);
        if (highlightDisplayKey == null) {
            throw new IllegalStateException("Cannot find HighlightDisplayKey for " + toolShortName);
        }
        HighlightDisplayKey highlightDisplayKey2 = highlightDisplayKey;
        HighlightDisplayLevel highlightDisplayLevel = profile.getErrorLevel(highlightDisplayKey2, (PsiElement)psiFile);
        Intrinsics.checkNotNullExpressionValue((Object)highlightDisplayLevel, (String)"getErrorLevel(...)");
        HighlightDisplayLevel errorLevel = highlightDisplayLevel;
        return new InspectionToolInfo(toolShortName, profile.isToolEnabled(highlightDisplayKey2, (PsiElement)psiFile) && !Intrinsics.areEqual((Object)errorLevel, (Object)HighlightDisplayLevel.DO_NOT_SHOW), highlightDisplayKey2, tool, errorLevel.getSeverity());
    }

    private static final boolean highlightSymbols$lambda$9(WebSymbol it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isExtension();
    }

    private static final TextAttributesKey highlightSymbols$lambda$12(PsiExternalReferenceHost $host, int $depth, WebSymbolQualifiedKind $parentKind, WebSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        TextAttributesKey textAttributesKey = WebSymbolHighlightingCustomizer.Companion.getSymbolTextAttributes$intellij_platform_webSymbols($host, symbol, $depth);
        if (textAttributesKey != null) {
            TextAttributesKey it = textAttributesKey;
            boolean bl = false;
            return it;
        }
        if (!Intrinsics.areEqual((Object)WebSymbolUtils.getQualifiedKind(symbol), (Object)$parentKind) && (textAttributesKey = WebSymbolHighlightingCustomizer.Companion.getTextAttributesFor$intellij_platform_webSymbols(WebSymbolUtils.getQualifiedKind(symbol))) != null) {
            TextAttributesKey it = textAttributesKey;
            boolean bl = false;
            return it;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair highlightSymbols$lambda$21(Map.Entry entry) {
        Pair pair;
        void $this$distinctBy$iv;
        void $this$filterTo$iv$iv;
        Object it;
        Object object;
        Intrinsics.checkNotNull((Object)entry);
        TextRange range = (TextRange)entry.getKey();
        Collection infos = (Collection)entry.getValue();
        Intrinsics.checkNotNull((Object)infos);
        Iterator iterator = ((Iterable)infos).iterator();
        if (!iterator.hasNext()) {
            object = null;
        } else {
            it = (Pair)iterator.next();
            boolean bl = false;
            it = ((Number)it.getFirst()).intValue();
            while (iterator.hasNext()) {
                Object it2 = (Pair)iterator.next();
                $i$a$-maxOfOrNull-WebSymbolsHighlightingAnnotator$highlightSymbols$6$maxDepth$1 = false;
                if (it.compareTo(it2 = (Comparable)Integer.valueOf(((Number)it2.getFirst()).intValue())) >= 0) continue;
                it = it2;
            }
            object = it;
        }
        Integer n = (Integer)object;
        if (n == null) {
            return null;
        }
        int maxDepth = n;
        Iterable $this$filter$iv = infos;
        boolean $i$f$filter = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair it3 = (Pair)element$iv$iv;
            boolean bl = false;
            if (!(((Number)it3.getFirst()).intValue() == maxDepth)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$distinctBy = false;
        HashSet<TextAttributesKey> set$iv = new HashSet<TextAttributesKey>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Pair it4 = (Pair)e$iv;
            boolean bl = false;
            TextAttributesKey key$iv = (TextAttributesKey)it4.getSecond();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Pair pair2 = (Pair)CollectionsKt.singleOrNull((List)list$iv);
        if (pair2 != null) {
            Pair it5 = pair2;
            boolean bl = false;
            pair = new Pair((Object)range, it5.getSecond());
        } else {
            pair = null;
        }
        return pair;
    }

    private static final int highlightSymbols$lambda$22(Pair it) {
        return ((TextRange)it.getFirst()).getStartOffset();
    }

    private static final int highlightSymbols$lambda$23(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final int highlightSymbols$lambda$24(Pair it) {
        return ((TextRange)it.getFirst()).getLength();
    }

    private static final int highlightSymbols$lambda$25(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final InspectionToolInfo getInspectionInfo$lambda$42$lambda$40(WebSymbolsHighlightingAnnotator this$0, AnnotationHolder $holder, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PsiFile psiFile = $holder.getCurrentAnnotationSession().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        return this$0.createToolInfo(it, psiFile);
    }

    private static final InspectionToolInfo getInspectionInfo$lambda$42$lambda$41(Function1 $tmp0, Object p0) {
        return (InspectionToolInfo)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\u001f\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u001b\u0010 \u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\r0\fH\u00c6\u0003J[\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\u001a\b\u0002\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\r0\fH\u00c6\u0001J\u0013\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00030\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006("}, d2={"Lcom/intellij/webSymbols/highlighting/impl/WebSymbolsHighlightingAnnotator$SegmentHighlightingInfo;", "", "segment", "Lcom/intellij/webSymbols/WebSymbolNameSegment;", "offset", "", "depth", "parentKind", "Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "parentTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "additionalChildSegments", "", "Lkotlin/Pair;", "<init>", "(Lcom/intellij/webSymbols/WebSymbolNameSegment;IILcom/intellij/webSymbols/WebSymbolQualifiedKind;Lcom/intellij/openapi/editor/colors/TextAttributesKey;Ljava/util/List;)V", "getSegment", "()Lcom/intellij/webSymbols/WebSymbolNameSegment;", "getOffset", "()I", "getDepth", "getParentKind", "()Lcom/intellij/webSymbols/WebSymbolQualifiedKind;", "getParentTextAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAdditionalChildSegments", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.platform.webSymbols"})
    private static final class SegmentHighlightingInfo {
        @NotNull
        private final WebSymbolNameSegment segment;
        private final int offset;
        private final int depth;
        @Nullable
        private final WebSymbolQualifiedKind parentKind;
        @Nullable
        private final TextAttributesKey parentTextAttributesKey;
        @NotNull
        private final List<Pair<Integer, WebSymbolNameSegment>> additionalChildSegments;

        public SegmentHighlightingInfo(@NotNull WebSymbolNameSegment segment, int offset, int depth, @Nullable WebSymbolQualifiedKind parentKind, @Nullable TextAttributesKey parentTextAttributesKey, @NotNull List<? extends Pair<Integer, ? extends WebSymbolNameSegment>> additionalChildSegments) {
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            Intrinsics.checkNotNullParameter(additionalChildSegments, (String)"additionalChildSegments");
            this.segment = segment;
            this.offset = offset;
            this.depth = depth;
            this.parentKind = parentKind;
            this.parentTextAttributesKey = parentTextAttributesKey;
            this.additionalChildSegments = additionalChildSegments;
        }

        @NotNull
        public final WebSymbolNameSegment getSegment() {
            return this.segment;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final int getDepth() {
            return this.depth;
        }

        @Nullable
        public final WebSymbolQualifiedKind getParentKind() {
            return this.parentKind;
        }

        @Nullable
        public final TextAttributesKey getParentTextAttributesKey() {
            return this.parentTextAttributesKey;
        }

        @NotNull
        public final List<Pair<Integer, WebSymbolNameSegment>> getAdditionalChildSegments() {
            return this.additionalChildSegments;
        }

        @NotNull
        public final WebSymbolNameSegment component1() {
            return this.segment;
        }

        public final int component2() {
            return this.offset;
        }

        public final int component3() {
            return this.depth;
        }

        @Nullable
        public final WebSymbolQualifiedKind component4() {
            return this.parentKind;
        }

        @Nullable
        public final TextAttributesKey component5() {
            return this.parentTextAttributesKey;
        }

        @NotNull
        public final List<Pair<Integer, WebSymbolNameSegment>> component6() {
            return this.additionalChildSegments;
        }

        @NotNull
        public final SegmentHighlightingInfo copy(@NotNull WebSymbolNameSegment segment, int offset, int depth, @Nullable WebSymbolQualifiedKind parentKind, @Nullable TextAttributesKey parentTextAttributesKey, @NotNull List<? extends Pair<Integer, ? extends WebSymbolNameSegment>> additionalChildSegments) {
            Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
            Intrinsics.checkNotNullParameter(additionalChildSegments, (String)"additionalChildSegments");
            return new SegmentHighlightingInfo(segment, offset, depth, parentKind, parentTextAttributesKey, additionalChildSegments);
        }

        public static /* synthetic */ SegmentHighlightingInfo copy$default(SegmentHighlightingInfo segmentHighlightingInfo, WebSymbolNameSegment webSymbolNameSegment, int n, int n2, WebSymbolQualifiedKind webSymbolQualifiedKind, TextAttributesKey textAttributesKey, List list2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                webSymbolNameSegment = segmentHighlightingInfo.segment;
            }
            if ((n3 & 2) != 0) {
                n = segmentHighlightingInfo.offset;
            }
            if ((n3 & 4) != 0) {
                n2 = segmentHighlightingInfo.depth;
            }
            if ((n3 & 8) != 0) {
                webSymbolQualifiedKind = segmentHighlightingInfo.parentKind;
            }
            if ((n3 & 0x10) != 0) {
                textAttributesKey = segmentHighlightingInfo.parentTextAttributesKey;
            }
            if ((n3 & 0x20) != 0) {
                list2 = segmentHighlightingInfo.additionalChildSegments;
            }
            return segmentHighlightingInfo.copy(webSymbolNameSegment, n, n2, webSymbolQualifiedKind, textAttributesKey, list2);
        }

        @NotNull
        public String toString() {
            return "SegmentHighlightingInfo(segment=" + this.segment + ", offset=" + this.offset + ", depth=" + this.depth + ", parentKind=" + this.parentKind + ", parentTextAttributesKey=" + this.parentTextAttributesKey + ", additionalChildSegments=" + this.additionalChildSegments + ")";
        }

        public int hashCode() {
            int result2 = this.segment.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.offset);
            result2 = result2 * 31 + Integer.hashCode(this.depth);
            result2 = result2 * 31 + (this.parentKind == null ? 0 : this.parentKind.hashCode());
            result2 = result2 * 31 + (this.parentTextAttributesKey == null ? 0 : this.parentTextAttributesKey.hashCode());
            result2 = result2 * 31 + ((Object)this.additionalChildSegments).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SegmentHighlightingInfo)) {
                return false;
            }
            SegmentHighlightingInfo segmentHighlightingInfo = (SegmentHighlightingInfo)other;
            if (!Intrinsics.areEqual((Object)this.segment, (Object)segmentHighlightingInfo.segment)) {
                return false;
            }
            if (this.offset != segmentHighlightingInfo.offset) {
                return false;
            }
            if (this.depth != segmentHighlightingInfo.depth) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentKind, (Object)segmentHighlightingInfo.parentKind)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.parentTextAttributesKey, (Object)segmentHighlightingInfo.parentTextAttributesKey)) {
                return false;
            }
            return Intrinsics.areEqual(this.additionalChildSegments, segmentHighlightingInfo.additionalChildSegments);
        }
    }
}

