/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.outputs.NotebookOutputComponentFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000b\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterExecutionCountGutterPainter;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputComponentFactory$GutterPainter;", "executionCount", "", "topBorderHeight", "<init>", "(Ljava/lang/Integer;I)V", "getExecutionCount", "()Ljava/lang/Integer;", "setExecutionCount", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "paintGutter", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "paintExecutionCountOutGutter", "rWidth", "yTop", "intellij.jupyter.core"})
public final class JupyterExecutionCountGutterPainter
implements NotebookOutputComponentFactory.GutterPainter {
    @Nullable
    private Integer executionCount;
    private final int topBorderHeight;

    public JupyterExecutionCountGutterPainter(@Nullable Integer executionCount, int topBorderHeight) {
        this.executionCount = executionCount;
        this.topBorderHeight = topBorderHeight;
    }

    public /* synthetic */ JupyterExecutionCountGutterPainter(Integer n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        this(n, n2);
    }

    @Nullable
    public final Integer getExecutionCount() {
        return this.executionCount;
    }

    public final void setExecutionCount(@Nullable Integer n) {
        this.executionCount = n;
    }

    public void paintGutter(@NotNull EditorImpl editor, @NotNull Graphics g, @NotNull Rectangle r) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            Integer n = this.executionCount;
            if (n == null) break block0;
            int it = ((Number)n).intValue();
            boolean bl = false;
            this.paintExecutionCountOutGutter(editor, it, g, r.width, r.y + this.topBorderHeight);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void paintExecutionCountOutGutter(EditorImpl editor, int executionCount, Graphics g, int rWidth, int yTop) {
        void it;
        NotebookEditorAppearance appearance = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)editor);
        if (editor.getEditorKind() == EditorKind.DIFF || !appearance.shouldShowOutExecutionCounts()) {
            return;
        }
        String text = "[" + executionCount + "]";
        Font font = editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        Graphics graphics = g;
        boolean bl = false;
        graphics.setFont(it.deriveFont(Math.max(1.0f, it.getSize2D() - 1.0f)));
        FontLayoutService fontLayoutService = FontLayoutService.Companion.getInstance();
        FontMetrics fontMetrics = g.getFontMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"getFontMetrics(...)");
        int left = rWidth - fontLayoutService.stringWidth(fontMetrics, text) - appearance.getLineNumbersMargin() - appearance.getLeftBorderWidth() - appearance.getExtraPaddingExecutionCount();
        EditorColorsScheme editorColorsScheme = editor.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        g.setColor(appearance.getGutterOutputExecutionCountForegroundColor(editorColorsScheme));
        g.drawString(text, left, yTop + editor.getAscent());
    }
}

