/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.actions;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.actions.JupyterExecutionData;
import com.intellij.jupyter.core.jupyter.actions.utils.JupyterDebugger;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.context.NotebookDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"getJupyterExecutionData", "Lcom/intellij/jupyter/core/jupyter/actions/JupyterExecutionData;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.jupyter.core"})
public final class CellExecutionListenerKt {
    @Nullable
    public static final JupyterExecutionData getJupyterExecutionData(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        DataContext dataContext2 = dataContext;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterDataContextExtensionsKt.getJupyterNotebookFile(dataContext2);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile;
        NotebookCellLines.Interval interval = NotebookDataContext.INSTANCE.getSelectedCellInterval(dataContext2);
        Integer cellIndex = interval != null ? Integer.valueOf(interval.getOrdinal()) : null;
        Editor editor = JupyterDataContextExtensionsKt.getEditor(dataContext2);
        if (editor == null || (editor = editor.getProject()) == null) {
            return null;
        }
        Editor project = editor;
        if (cellIndex != null && JupyterDebugger.INSTANCE.showWarningIfUnderDebugger((Project)project, jupyterVirtualFile)) {
            return null;
        }
        return new JupyterExecutionData((Project)project, cellIndex, jupyterVirtualFile);
    }
}

