/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.editor.actions.edit.mode;

import com.intellij.jupyter.core.editor.actions.edit.mode.HorizontalDirection;
import com.intellij.jupyter.core.editor.actions.edit.mode.VerticalDirection;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0000\u001a(\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a\u001c\u0010\r\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\u000f\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u000e*\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"isAtVisibleCellBorder", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "direction", "Lcom/intellij/jupyter/core/editor/actions/edit/mode/VerticalDirection;", "isAtVisibleCellBorderLine", "Lcom/intellij/jupyter/core/editor/actions/edit/mode/HorizontalDirection;", "moveCaretToVisualCellBorder", "", "withSelection", "getCellVisualBorder", "Lcom/intellij/openapi/editor/VisualPosition;", "getContentStartVisualPosition", "cell", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "getContentEndVisualPosition", "intellij.jupyter.core"})
public final class JupyterCustomCaretMoveUtilKt {
    public static final boolean isAtVisibleCellBorder(@NotNull Editor editor, @NotNull Caret caret, @NotNull VerticalDirection direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        return Intrinsics.areEqual((Object)JupyterCustomCaretMoveUtilKt.getCellVisualBorder(editor, caret, direction), (Object)caret.getVisualPosition());
    }

    public static final boolean isAtVisibleCellBorderLine(@NotNull Editor editor, @NotNull Caret caret, @NotNull VerticalDirection direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        return JupyterCustomCaretMoveUtilKt.getCellVisualBorder((Editor)editor, (Caret)caret, (VerticalDirection)direction).line == caret.getVisualPosition().line;
    }

    public static final boolean isAtVisibleCellBorder(@NotNull Editor editor, @NotNull Caret caret, @NotNull HorizontalDirection direction) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        NotebookCellLines.Interval cell = NotebookVisualizationUiUtilKt.getCell((Editor)editor, (int)caret.getLogicalPosition().line);
        return switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
            case 1 -> Intrinsics.areEqual((Object)JupyterCustomCaretMoveUtilKt.getContentStartVisualPosition(editor, cell), (Object)caret.getVisualPosition());
            case 2 -> Intrinsics.areEqual((Object)JupyterCustomCaretMoveUtilKt.getContentEndVisualPosition(editor, cell), (Object)caret.getVisualPosition());
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static final void moveCaretToVisualCellBorder(@NotNull Editor editor, @NotNull Caret caret, @NotNull VerticalDirection direction, boolean withSelection) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        VisualPosition visualPosition = caret.getVisualPosition();
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
        VisualPosition caretVisualPos = visualPosition;
        VisualPosition targetVisualPosition = JupyterCustomCaretMoveUtilKt.getCellVisualBorder(editor, caret, direction);
        int dColumn = targetVisualPosition.column - caretVisualPos.column;
        int dLine = targetVisualPosition.line - caretVisualPos.line;
        boolean scrollToCaret = caret == editor.getCaretModel().getPrimaryCaret();
        caret.moveCaretRelatively(dColumn, dLine, withSelection, scrollToCaret);
    }

    private static final VisualPosition getCellVisualBorder(Editor $this$getCellVisualBorder, Caret caret, VerticalDirection direction) {
        NotebookCellLines.Interval cell = NotebookVisualizationUiUtilKt.getCell((Editor)$this$getCellVisualBorder, (int)caret.getLogicalPosition().line);
        return switch (WhenMappings.$EnumSwitchMapping$1[direction.ordinal()]) {
            case 1 -> JupyterCustomCaretMoveUtilKt.getContentStartVisualPosition($this$getCellVisualBorder, cell);
            case 2 -> JupyterCustomCaretMoveUtilKt.getContentEndVisualPosition($this$getCellVisualBorder, cell);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final VisualPosition getContentStartVisualPosition(Editor $this$getContentStartVisualPosition, NotebookCellLines.Interval cell) {
        VisualPosition visualPosition = $this$getContentStartVisualPosition.offsetToVisualPosition($this$getContentStartVisualPosition.getDocument().getLineStartOffset(cell.getFirstContentLine()));
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        return visualPosition;
    }

    private static final VisualPosition getContentEndVisualPosition(Editor $this$getContentEndVisualPosition, NotebookCellLines.Interval cell) {
        VisualPosition visualPosition = $this$getContentEndVisualPosition.offsetToVisualPosition($this$getContentEndVisualPosition.getDocument().getLineEndOffset(cell.getLastContentLine()));
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        return visualPosition;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[HorizontalDirection.values().length];
            try {
                nArray[HorizontalDirection.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HorizontalDirection.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[VerticalDirection.values().length];
            try {
                nArray[VerticalDirection.UP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VerticalDirection.DOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

