/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.language.syntax.lexer;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.language.syntax.SyntaxNodeDescriptor;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateLexerState;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateSyntaxMatcher;
import org.jetbrains.plugins.textmate.language.syntax.selector.TextMateWeigh;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.TextMateString;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0002\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004JJ\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016JB\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u00062\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateCachingSyntaxMatcher;", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateSyntaxMatcher;", "delegate", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateSyntaxMatcher;)V", "matchRule", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState;", "syntaxNodeDescriptor", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "byteOffset", "", "matchBeginPosition", "", "matchBeginString", "priority", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;", "currentScope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "checkCancelledCallback", "Ljava/lang/Runnable;", "matchStringRegex", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "keyName", "Lorg/jetbrains/plugins/textmate/Constants$StringKey;", "lexerState", "createStringToMatch", "s", "", "Companion", "MatchKey", "intellij.textmate"})
public final class TextMateCachingSyntaxMatcher
implements TextMateSyntaxMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextMateSyntaxMatcher delegate;
    private static final Cache<MatchKey, TextMateLexerState> CACHE = Caffeine.newBuilder().maximumSize(100000L).expireAfterAccess(1L, TimeUnit.MINUTES).executor(ExecutorsKt.asExecutor((CoroutineDispatcher)Dispatchers.getDefault())).build();

    public TextMateCachingSyntaxMatcher(@NotNull TextMateSyntaxMatcher delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public TextMateLexerState matchRule(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope, @Nullable Runnable checkCancelledCallback) {
        Intrinsics.checkNotNullParameter((Object)syntaxNodeDescriptor, (String)"syntaxNodeDescriptor");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        Intrinsics.checkNotNullParameter((Object)currentScope, (String)"currentScope");
        Object object = CACHE.get((Object)new MatchKey(syntaxNodeDescriptor, string, byteOffset, matchBeginPosition, matchBeginString, priority, currentScope), arg_0 -> TextMateCachingSyntaxMatcher.matchRule$lambda$1(arg_0 -> TextMateCachingSyntaxMatcher.matchRule$lambda$0(this, checkCancelledCallback, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (TextMateLexerState)object;
    }

    @Override
    @NotNull
    public MatchData matchStringRegex(@NotNull Constants.StringKey keyName, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateLexerState lexerState, @Nullable Runnable checkCancelledCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)keyName), (String)"keyName");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)lexerState, (String)"lexerState");
        return this.delegate.matchStringRegex(keyName, string, byteOffset, matchBeginPosition, matchBeginString, lexerState, checkCancelledCallback);
    }

    @Override
    @NotNull
    public TextMateString createStringToMatch(@NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.delegate.createStringToMatch(s);
    }

    private static final TextMateLexerState matchRule$lambda$0(TextMateCachingSyntaxMatcher this$0, Runnable $checkCancelledCallback, MatchKey it) {
        if (it == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        return this$0.delegate.matchRule(it.getSyntaxNodeDescriptor(), it.getString(), it.getByteOffset(), it.getMatchBeginPosition(), it.getMatchBeginString(), it.getPriority(), it.getCurrentScope(), $checkCancelledCallback);
    }

    private static final TextMateLexerState matchRule$lambda$1(Function1 $tmp0, Object p0) {
        return (TextMateLexerState)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003RP\u0010\u0004\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateCachingSyntaxMatcher$Companion;", "", "<init>", "()V", "CACHE", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateCachingSyntaxMatcher$MatchKey;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateLexerState;", "Lcom/github/benmanes/caffeine/cache/Cache;", "intellij.textmate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003J\t\u0010#\u001a\u00020\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u000eH\u00c6\u0003JO\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010&\u001a\u00020\t2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0007H\u00d6\u0001J\t\u0010)\u001a\u00020*H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateCachingSyntaxMatcher$MatchKey;", "", "syntaxNodeDescriptor", "Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "byteOffset", "", "matchBeginPosition", "", "matchBeginString", "priority", "Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;", "currentScope", "Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "<init>", "(Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;Lorg/jetbrains/plugins/textmate/regex/TextMateString;IZZLorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;)V", "getSyntaxNodeDescriptor", "()Lorg/jetbrains/plugins/textmate/language/syntax/SyntaxNodeDescriptor;", "getString", "()Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "getByteOffset", "()I", "getMatchBeginPosition", "()Z", "getMatchBeginString", "getPriority", "()Lorg/jetbrains/plugins/textmate/language/syntax/selector/TextMateWeigh$Priority;", "getCurrentScope", "()Lorg/jetbrains/plugins/textmate/language/syntax/lexer/TextMateScope;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "other", "hashCode", "toString", "", "intellij.textmate"})
    private static final class MatchKey {
        @NotNull
        private final SyntaxNodeDescriptor syntaxNodeDescriptor;
        @NotNull
        private final TextMateString string;
        private final int byteOffset;
        private final boolean matchBeginPosition;
        private final boolean matchBeginString;
        @NotNull
        private final TextMateWeigh.Priority priority;
        @NotNull
        private final TextMateScope currentScope;

        public MatchKey(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope) {
            Intrinsics.checkNotNullParameter((Object)syntaxNodeDescriptor, (String)"syntaxNodeDescriptor");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
            Intrinsics.checkNotNullParameter((Object)currentScope, (String)"currentScope");
            this.syntaxNodeDescriptor = syntaxNodeDescriptor;
            this.string = string;
            this.byteOffset = byteOffset;
            this.matchBeginPosition = matchBeginPosition;
            this.matchBeginString = matchBeginString;
            this.priority = priority;
            this.currentScope = currentScope;
        }

        @NotNull
        public final SyntaxNodeDescriptor getSyntaxNodeDescriptor() {
            return this.syntaxNodeDescriptor;
        }

        @NotNull
        public final TextMateString getString() {
            return this.string;
        }

        public final int getByteOffset() {
            return this.byteOffset;
        }

        public final boolean getMatchBeginPosition() {
            return this.matchBeginPosition;
        }

        public final boolean getMatchBeginString() {
            return this.matchBeginString;
        }

        @NotNull
        public final TextMateWeigh.Priority getPriority() {
            return this.priority;
        }

        @NotNull
        public final TextMateScope getCurrentScope() {
            return this.currentScope;
        }

        @NotNull
        public final SyntaxNodeDescriptor component1() {
            return this.syntaxNodeDescriptor;
        }

        @NotNull
        public final TextMateString component2() {
            return this.string;
        }

        public final int component3() {
            return this.byteOffset;
        }

        public final boolean component4() {
            return this.matchBeginPosition;
        }

        public final boolean component5() {
            return this.matchBeginString;
        }

        @NotNull
        public final TextMateWeigh.Priority component6() {
            return this.priority;
        }

        @NotNull
        public final TextMateScope component7() {
            return this.currentScope;
        }

        @NotNull
        public final MatchKey copy(@NotNull SyntaxNodeDescriptor syntaxNodeDescriptor, @NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @NotNull TextMateWeigh.Priority priority, @NotNull TextMateScope currentScope) {
            Intrinsics.checkNotNullParameter((Object)syntaxNodeDescriptor, (String)"syntaxNodeDescriptor");
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
            Intrinsics.checkNotNullParameter((Object)currentScope, (String)"currentScope");
            return new MatchKey(syntaxNodeDescriptor, string, byteOffset, matchBeginPosition, matchBeginString, priority, currentScope);
        }

        public static /* synthetic */ MatchKey copy$default(MatchKey matchKey, SyntaxNodeDescriptor syntaxNodeDescriptor, TextMateString textMateString, int n, boolean bl, boolean bl2, TextMateWeigh.Priority priority, TextMateScope textMateScope, int n2, Object object) {
            if ((n2 & 1) != 0) {
                syntaxNodeDescriptor = matchKey.syntaxNodeDescriptor;
            }
            if ((n2 & 2) != 0) {
                textMateString = matchKey.string;
            }
            if ((n2 & 4) != 0) {
                n = matchKey.byteOffset;
            }
            if ((n2 & 8) != 0) {
                bl = matchKey.matchBeginPosition;
            }
            if ((n2 & 0x10) != 0) {
                bl2 = matchKey.matchBeginString;
            }
            if ((n2 & 0x20) != 0) {
                priority = matchKey.priority;
            }
            if ((n2 & 0x40) != 0) {
                textMateScope = matchKey.currentScope;
            }
            return matchKey.copy(syntaxNodeDescriptor, textMateString, n, bl, bl2, priority, textMateScope);
        }

        @NotNull
        public String toString() {
            return "MatchKey(syntaxNodeDescriptor=" + this.syntaxNodeDescriptor + ", string=" + this.string + ", byteOffset=" + this.byteOffset + ", matchBeginPosition=" + this.matchBeginPosition + ", matchBeginString=" + this.matchBeginString + ", priority=" + this.priority + ", currentScope=" + this.currentScope + ")";
        }

        public int hashCode() {
            int result = this.syntaxNodeDescriptor.hashCode();
            result = result * 31 + this.string.hashCode();
            result = result * 31 + Integer.hashCode(this.byteOffset);
            result = result * 31 + Boolean.hashCode(this.matchBeginPosition);
            result = result * 31 + Boolean.hashCode(this.matchBeginString);
            result = result * 31 + this.priority.hashCode();
            result = result * 31 + this.currentScope.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchKey)) {
                return false;
            }
            MatchKey matchKey = (MatchKey)other;
            if (!Intrinsics.areEqual((Object)this.syntaxNodeDescriptor, (Object)matchKey.syntaxNodeDescriptor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.string, (Object)matchKey.string)) {
                return false;
            }
            if (this.byteOffset != matchKey.byteOffset) {
                return false;
            }
            if (this.matchBeginPosition != matchKey.matchBeginPosition) {
                return false;
            }
            if (this.matchBeginString != matchKey.matchBeginString) {
                return false;
            }
            if (this.priority != matchKey.priority) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.currentScope, (Object)matchKey.currentScope);
        }
    }
}

