/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.editor;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtilEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.TextMateBundle;
import org.jetbrains.plugins.textmate.TextMateService;
import org.jetbrains.plugins.textmate.editor.TextMateEditorUtils;
import org.jetbrains.plugins.textmate.language.preferences.SnippetsRegistry;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.syntax.lexer.TextMateScope;
import org.jetbrains.plugins.textmate.psi.TextMateFile;

public class TextMateCustomLiveTemplate
extends CustomLiveTemplateBase {
    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(0);
        }
        CharSequence result = "";
        Editor editor = callback.getEditor();
        CharSequence sequence = editor.getDocument().getImmutableCharSequence();
        Collection<TextMateSnippet> availableSnippets = TextMateCustomLiveTemplate.getAvailableSnippets(editor);
        for (TextMateSnippet snippet : availableSnippets) {
            CharSequence prefix = TextMateCustomLiveTemplate.getPrefixForSnippet(sequence, editor.getCaretModel().getOffset(), snippet);
            if (prefix == null || prefix.length() <= result.length()) continue;
            result = prefix;
        }
        return !availableSnippets.isEmpty() ? result.toString() : null;
    }

    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        if (callback == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(1);
        }
        int offset = callback.getEditor().getCaretModel().getOffset();
        CharSequence charsSequence = callback.getEditor().getDocument().getImmutableCharSequence();
        for (TextMateSnippet snippet : TextMateCustomLiveTemplate.getAvailableSnippets(callback.getEditor())) {
            String key = snippet.getKey();
            if (key.length() > offset || !StringUtil.equals((CharSequence)key, (CharSequence)charsSequence.subSequence(offset - key.length(), offset))) continue;
            return key;
        }
        return null;
    }

    public void expand(@NotNull String key, @NotNull CustomTemplateCallback callback) {
        TextMateService service;
        if (key == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(2);
        }
        if (callback == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(3);
        }
        if ((service = TextMateService.getInstance()) != null) {
            Editor editor;
            TextMateScope scope;
            SnippetsRegistry snippetsRegistry = service.getSnippetRegistry();
            Collection<TextMateSnippet> snippets = snippetsRegistry.findSnippet(key, scope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)(editor = callback.getEditor())));
            if (snippets.size() > 1) {
                LookupImpl lookup = (LookupImpl)LookupManager.getInstance((Project)callback.getProject()).createLookup(editor, LookupElement.EMPTY_ARRAY, "", (LookupArranger)new LookupArranger.DefaultArranger());
                for (TextMateSnippet snippet : snippets) {
                    lookup.addItem((LookupElement)new TextMateSnippetLookupElement(snippet), (PrefixMatcher)new PlainPrefixMatcher(key));
                }
                Project project = editor.getProject();
                lookup.addLookupListener((LookupListener)new MyLookupAdapter(project, editor, callback.getFile()));
                lookup.refreshUi(false, true);
                lookup.showLookup();
            } else if (snippets.size() == 1) {
                TextMateSnippet snippet = (TextMateSnippet)ContainerUtil.getFirstItem(snippets);
                assert (snippet != null);
                TextMateCustomLiveTemplate.expand(editor, snippet);
            }
        }
    }

    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback) {
        if (selection == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(4);
        }
        if (callback == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file, @NotNull Editor editor, int offset) {
        TextMateService service;
        if (file == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(7);
        }
        if ((service = TextMateService.getInstance()) == null) {
            Collection collection = super.getLookupElements(file, editor, offset);
            if (collection == null) {
                TextMateCustomLiveTemplate.$$$reportNull$$$0(8);
            }
            return collection;
        }
        List list = ContainerUtil.map(TextMateCustomLiveTemplate.getAvailableSnippets(editor), snippet -> new TextMateSnippetLookupElement((TextMateSnippet)snippet));
        if (list == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(9);
        }
        return list;
    }

    public void addCompletions(CompletionParameters parameters, CompletionResultSet result) {
        int endOffset = parameters.getOffset();
        Editor editor = parameters.getEditor();
        CharSequence sequence = editor.getDocument().getImmutableCharSequence();
        for (TextMateSnippet snippet : TextMateCustomLiveTemplate.getAvailableSnippets(editor)) {
            CharSequence prefix = TextMateCustomLiveTemplate.getPrefixForSnippet(sequence, endOffset, snippet);
            if (prefix == null || !StringUtil.startsWith((CharSequence)snippet.getKey(), (CharSequence)prefix)) continue;
            result.withPrefixMatcher(result.getPrefixMatcher().cloneWithPrefix(prefix.toString())).addElement((LookupElement)new TextMateSnippetLookupElement(snippet));
        }
    }

    public boolean isApplicable(@NotNull CustomTemplateCallback callback, int offset, boolean wrapping) {
        PsiFile file;
        if (callback == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(10);
        }
        return (file = callback.getFile()) instanceof TextMateFile && ApplicationManager.getApplication().isInternal();
    }

    public boolean hasCompletionItem(@NotNull CustomTemplateCallback callback, int offset) {
        if (callback == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(11);
        }
        return this.isApplicable(callback, offset, false);
    }

    public char getShortcut() {
        return '\t';
    }

    public boolean supportsWrapping() {
        return true;
    }

    @NotNull
    public String getTitle() {
        String string = TextMateBundle.message("textmate.live.template.name", new Object[0]);
        if (string == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    private static Collection<TextMateSnippet> getAvailableSnippets(@NotNull Editor editor) {
        TextMateService service;
        if (editor == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(13);
        }
        if ((service = TextMateService.getInstance()) != null) {
            SnippetsRegistry snippetsRegistry = service.getSnippetRegistry();
            TextMateScope scope = TextMateEditorUtils.getCurrentScopeSelector((EditorEx)editor);
            Collection<TextMateSnippet> collection = snippetsRegistry.getAvailableSnippets(scope);
            if (collection == null) {
                TextMateCustomLiveTemplate.$$$reportNull$$$0(14);
            }
            return collection;
        }
        List<TextMateSnippet> list = Collections.emptyList();
        if (list == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(15);
        }
        return list;
    }

    @Nullable
    private static CharSequence getPrefixForSnippet(@NotNull CharSequence sequence, int offset, @NotNull TextMateSnippet snippet) {
        int startOffset;
        if (sequence == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(16);
        }
        if (snippet == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(17);
        }
        for (int i = startOffset = Math.max(offset - snippet.getKey().length(), 0); i <= offset; ++i) {
            if (i != 0 && !StringUtil.isWhiteSpace((char)sequence.charAt(i - 1))) continue;
            CharSequence prefix = sequence.subSequence(i, offset);
            if (!StringUtil.startsWith((CharSequence)snippet.getKey(), (CharSequence)prefix)) continue;
            return prefix;
        }
        return null;
    }

    private static void expand(@NotNull Editor editor, @NotNull TextMateSnippet snippet) {
        if (editor == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(18);
        }
        if (snippet == null) {
            TextMateCustomLiveTemplate.$$$reportNull$$$0(19);
        }
        String key = snippet.getKey();
        int offset = editor.getCaretModel().getOffset();
        int newOffset = Math.max(offset - key.length(), 0);
        editor.getDocument().deleteString(newOffset, offset);
        editor.getCaretModel().moveToOffset(newOffset);
        EditorModificationUtilEx.insertStringAtCaret((Editor)editor, (String)snippet.getContent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 12, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/textmate/editor/TextMateCustomLiveTemplate";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snippet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateCustomLiveTemplate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableSnippets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKeyWithoutContextChecking";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeTemplateKey";
                break;
            }
            case 2: 
            case 3: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: 
            case 15: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasCompletionItem";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableSnippets";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixForSnippet";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 12, 14, 15 -> new IllegalStateException(string);
        };
    }

    private class TextMateSnippetLookupElement
    extends CustomLiveTemplateLookupElement {
        private final TextMateSnippet mySnippet;

        TextMateSnippetLookupElement(TextMateSnippet snippet) {
            if (snippet == null) {
                TextMateSnippetLookupElement.$$$reportNull$$$0(0);
            }
            super((CustomLiveTemplateBase)TextMateCustomLiveTemplate.this, snippet.getKey(), snippet.getKey(), snippet.getDescription(), false, true);
            this.mySnippet = snippet;
        }

        public void expandTemplate(@NotNull Editor editor, @NotNull PsiFile file) {
            if (editor == null) {
                TextMateSnippetLookupElement.$$$reportNull$$$0(1);
            }
            if (file == null) {
                TextMateSnippetLookupElement.$$$reportNull$$$0(2);
            }
            TextMateCustomLiveTemplate.expand(editor, this.mySnippet);
        }

        public void renderElement(@NotNull LookupElementPresentation presentation) {
            if (presentation == null) {
                TextMateSnippetLookupElement.$$$reportNull$$$0(3);
            }
            super.renderElement(presentation);
            presentation.setTypeText(this.mySnippet.getName());
            presentation.setTypeGrayed(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "snippet";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/textmate/editor/TextMateCustomLiveTemplate$TextMateSnippetLookupElement";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "expandTemplate";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "renderElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyLookupAdapter
    implements LookupListener {
        private final Project myProject;
        private final Editor myEditor;
        private final PsiFile myFile;

        MyLookupAdapter(Project project, Editor editor, PsiFile file) {
            this.myProject = project;
            this.myEditor = editor;
            this.myFile = file;
        }

        public void itemSelected(@NotNull LookupEvent event) {
            if (event == null) {
                MyLookupAdapter.$$$reportNull$$$0(0);
            }
            LookupElement item = event.getItem();
            assert (item instanceof CustomLiveTemplateLookupElement);
            if (this.myFile != null) {
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)TextMateBundle.message("textmate.expand.live.template.command.name", new Object[0]), null, () -> ((CustomLiveTemplateLookupElement)item).expandTemplate(this.myEditor, this.myFile), (PsiFile[])new PsiFile[]{this.myFile});
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/textmate/editor/TextMateCustomLiveTemplate$MyLookupAdapter", "itemSelected"));
        }
    }
}

