/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.textmate.bundles;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.Constants;
import org.jetbrains.plugins.textmate.bundles.BundleReaderKt;
import org.jetbrains.plugins.textmate.bundles.TextMateBundleReader;
import org.jetbrains.plugins.textmate.bundles.TextMateFileNameMatcher;
import org.jetbrains.plugins.textmate.bundles.TextMateGrammar;
import org.jetbrains.plugins.textmate.bundles.TextMatePreferences;
import org.jetbrains.plugins.textmate.language.PreferencesReadUtil;
import org.jetbrains.plugins.textmate.language.preferences.IndentationRules;
import org.jetbrains.plugins.textmate.language.preferences.TextMateAutoClosingPair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateBracePair;
import org.jetbrains.plugins.textmate.language.preferences.TextMateShellVariable;
import org.jetbrains.plugins.textmate.language.preferences.TextMateSnippet;
import org.jetbrains.plugins.textmate.language.preferences.TextMateTextAttributes;
import org.jetbrains.plugins.textmate.plist.CompositePlistReader;
import org.jetbrains.plugins.textmate.plist.PListValue;
import org.jetbrains.plugins.textmate.plist.Plist;
import org.jetbrains.plugins.textmate.plist.PlistReader;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\"\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0001H\u0000*\n\u0010\u0000\"\u00020\u00012\u00020\u0001\u00a8\u0006\u0018"}, d2={"TextMateScopeName", "", "readTextMateBundle", "Lorg/jetbrains/plugins/textmate/bundles/TextMateBundleReader;", "path", "Ljava/nio/file/Path;", "readSublimeBundle", "readSnippetFromPlist", "Lorg/jetbrains/plugins/textmate/language/preferences/TextMateSnippet;", "plist", "Lorg/jetbrains/plugins/textmate/plist/Plist;", "explicitUuid", "readPreferencesFromPlist", "Lorg/jetbrains/plugins/textmate/bundles/TextMatePreferences;", "readPlistInDirectory", "Lkotlin/sequences/Sequence;", "directory", "plistReader", "Lorg/jetbrains/plugins/textmate/plist/PlistReader;", "glob", "readPlist", "inputStream", "Ljava/io/InputStream;", "debugName", "intellij.textmate.core"})
@SourceDebugExtension(value={"SMAP\nBundleReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BundleReader.kt\norg/jetbrains/plugins/textmate/bundles/BundleReaderKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,181:1\n1#2:182\n1557#3:183\n1628#3,3:184\n1557#3:187\n1628#3,3:188\n*S KotlinDebug\n*F\n+ 1 BundleReader.kt\norg/jetbrains/plugins/textmate/bundles/BundleReaderKt\n*L\n135#1:183\n135#1:184,3\n139#1:187\n139#1:188,3\n*E\n"})
public final class BundleReaderKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final TextMateBundleReader readTextMateBundle(@NotNull Path path) {
        Plist plist;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CompositePlistReader plistReader = new CompositePlistReader();
        Path infoPlistPath = path.resolve("info.plist");
        Intrinsics.checkNotNull((Object)infoPlistPath);
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(infoPlistPath, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        Closeable closeable = inputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedInputStream it = (BufferedInputStream)closeable;
            boolean bl = false;
            plist = plistReader.read(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Plist infoPlist = plist;
        String string = infoPlist.getPlistValue("name", PathsKt.getName((Path)path)).getString();
        Intrinsics.checkNotNull((Object)string);
        String bundleName = string;
        return new TextMateBundleReader(bundleName, path, plistReader){
            private final String bundleName;
            final /* synthetic */ Path $path;
            final /* synthetic */ CompositePlistReader $plistReader;
            {
                this.$path = $path;
                this.$plistReader = $plistReader;
                this.bundleName = $bundleName;
            }

            public String getBundleName() {
                return this.bundleName;
            }

            public Sequence<TextMateGrammar> readGrammars() {
                Path path = this.$path.resolve("Syntaxes");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                return SequencesKt.map((Sequence)BundleReaderKt.access$readPlistInDirectory(path, this.$plistReader, "*.{tmLanguage,plist,tmLanguage.json}"), readTextMateBundle.1::readGrammars$lambda$2);
            }

            public Sequence<TextMatePreferences> readPreferences() {
                Path path = this.$path.resolve("Preferences");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(path, this.$plistReader, "*.{tmPreferences,plist}"), readTextMateBundle.1::readPreferences$lambda$3);
            }

            public Sequence<TextMateSnippet> readSnippets() {
                Path path = this.$path.resolve("Snippets");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(path, this.$plistReader, "*.{tmSnippet,plist}"), arg_0 -> readTextMateBundle.1.readSnippets$lambda$4(this.$path, arg_0));
            }

            private static final Plist readGrammars$lambda$2$lambda$1(Plist $plist) {
                return $plist;
            }

            /*
             * WARNING - void declaration
             */
            private static final TextMateGrammar readGrammars$lambda$2(Plist plist) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)plist.getPlistValue("fileTypes", CollectionsKt.emptyList()).getStringArray());
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new TextMateFileNameMatcher[]{new TextMateFileNameMatcher.Name(s), new TextMateFileNameMatcher.Extension(s)};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List fileNameMatchers = (List)destination$iv$iv;
                PListValue pListValue = plist.getPlistValue("firstLineMatch");
                String firstLinePattern = pListValue != null ? pListValue.getString() : null;
                return new TextMateGrammar(fileNameMatchers, firstLinePattern, (Lazy<Plist>)LazyKt.lazy(() -> readTextMateBundle.1.readGrammars$lambda$2$lambda$1(plist)), null, null);
            }

            private static final TextMatePreferences readPreferences$lambda$3(Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderKt.access$readPreferencesFromPlist(plist);
            }

            private static final TextMateSnippet readSnippets$lambda$4(Path $path, Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderKt.access$readSnippetFromPlist(plist, ((Object)$path).toString());
            }
        };
    }

    @NotNull
    public static final TextMateBundleReader readSublimeBundle(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        CompositePlistReader plistReader = new CompositePlistReader();
        return new TextMateBundleReader(path, plistReader){
            private final String bundleName;
            final /* synthetic */ Path $path;
            final /* synthetic */ CompositePlistReader $plistReader;
            {
                this.$path = $path;
                this.$plistReader = $plistReader;
                this.bundleName = PathsKt.getName((Path)$path);
            }

            public String getBundleName() {
                return this.bundleName;
            }

            public Sequence<TextMateGrammar> readGrammars() {
                return SequencesKt.map((Sequence)BundleReaderKt.access$readPlistInDirectory(this.$path, this.$plistReader, "*.{tmLanguage,plist,tmLanguage.json}"), readSublimeBundle.1::readGrammars$lambda$2);
            }

            public Sequence<TextMatePreferences> readPreferences() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(this.$path, this.$plistReader, "*.{tmPreferences,plist}"), readSublimeBundle.1::readPreferences$lambda$3);
            }

            public Sequence<TextMateSnippet> readSnippets() {
                return SequencesKt.mapNotNull((Sequence)BundleReaderKt.access$readPlistInDirectory(this.$path, this.$plistReader, "*.plist"), arg_0 -> readSublimeBundle.1.readSnippets$lambda$4(this.$path, arg_0));
            }

            private static final Plist readGrammars$lambda$2$lambda$1(Plist $plist) {
                return $plist;
            }

            /*
             * WARNING - void declaration
             */
            private static final TextMateGrammar readGrammars$lambda$2(Plist plist) {
                void $this$flatMapTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                Iterable $this$flatMap$iv = CollectionsKt.filterNotNull((Iterable)plist.getPlistValue("fileTypes", CollectionsKt.emptyList()).getStringArray());
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    String s = (String)element$iv$iv;
                    boolean bl = false;
                    Object[] objectArray = new TextMateFileNameMatcher[]{new TextMateFileNameMatcher.Name(s), new TextMateFileNameMatcher.Extension(s)};
                    Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                List fileNameMatchers = (List)destination$iv$iv;
                PListValue pListValue = plist.getPlistValue("firstLineMatch");
                String firstLinePattern = pListValue != null ? pListValue.getString() : null;
                return new TextMateGrammar(fileNameMatchers, firstLinePattern, (Lazy<Plist>)LazyKt.lazy(() -> readSublimeBundle.1.readGrammars$lambda$2$lambda$1(plist)), null, null);
            }

            private static final TextMatePreferences readPreferences$lambda$3(Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderKt.access$readPreferencesFromPlist(plist);
            }

            private static final TextMateSnippet readSnippets$lambda$4(Path $path, Plist plist) {
                Intrinsics.checkNotNullParameter((Object)plist, (String)"plist");
                return BundleReaderKt.access$readSnippetFromPlist(plist, ((Object)$path).toString());
            }
        };
    }

    private static final TextMateSnippet readSnippetFromPlist(Plist plist, String explicitUuid) {
        String string;
        String it = string = plist.getPlistValue("tabTrigger", "").getString();
        boolean bl = false;
        CharSequence charSequence = it;
        String string2 = !(charSequence == null || charSequence.length() == 0) ? string : null;
        if (string2 == null) {
            return null;
        }
        String key = string2;
        String it2 = it = plist.getPlistValue(Constants.StringKey.CONTENT.getValue(), "").getString();
        boolean bl2 = false;
        CharSequence charSequence2 = it2;
        String string3 = !(charSequence2 == null || charSequence2.length() == 0) ? it : null;
        if (string3 == null) {
            return null;
        }
        String content = string3;
        String it3 = it2 = plist.getPlistValue("name", "").getString();
        boolean bl3 = false;
        CharSequence charSequence3 = it3;
        String string4 = !(charSequence3 == null || charSequence3.length() == 0) ? it2 : null;
        if (string4 == null) {
            string4 = key;
        }
        String name = string4;
        String string5 = plist.getPlistValue("scope", "").getString();
        Intrinsics.checkNotNull((Object)string5);
        String scope = string5;
        String string6 = plist.getPlistValue("description", "").getString();
        Intrinsics.checkNotNull((Object)string6);
        String description = string6;
        String string7 = plist.getPlistValue("uuid", explicitUuid).getString();
        Intrinsics.checkNotNull((Object)string7);
        String uuid = string7;
        return new TextMateSnippet(key, content, scope, name, description, uuid);
    }

    /*
     * WARNING - void declaration
     */
    private static final TextMatePreferences readPreferencesFromPlist(Plist plist) {
        TextMatePreferences textMatePreferences;
        Object object = plist.getPlistValue("scope");
        if (object != null && (object = ((PListValue)object).getString()) != null) {
            Object scopeName = object;
            boolean bl = false;
            Object object2 = plist.getPlistValue("settings");
            if (object2 != null && (object2 = ((PListValue)object2).getPlist()) != null) {
                Set set;
                Set<TextMateBracePair> set2;
                List list;
                Set set3;
                Iterable it;
                Set set4;
                Object settings = object2;
                boolean bl2 = false;
                Set<TextMateBracePair> highlightingPairs = PreferencesReadUtil.INSTANCE.readPairs(((Plist)settings).getPlistValue("highlightPairs"));
                Set<TextMateBracePair> set5 = PreferencesReadUtil.INSTANCE.readPairs(((Plist)settings).getPlistValue("smartTypingPairs"));
                if (set5 != null) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Iterable iterable = set5;
                    boolean $i$f$map = false;
                    set4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        TextMateBracePair textMateBracePair = (TextMateBracePair)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(new TextMateAutoClosingPair(((TextMateBracePair)((Object)it)).getLeft(), ((TextMateBracePair)((Object)it)).getRight(), 0));
                    }
                    set3 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                } else {
                    set3 = null;
                }
                Set smartTypingPairs = set3;
                IndentationRules indentationRules = PreferencesReadUtil.INSTANCE.loadIndentationRules((Plist)settings);
                PListValue pListValue = ((Plist)settings).getPlistValue("shellVariables");
                if (pListValue != null) {
                    void $this$mapTo$iv$iv;
                    PListValue variables = pListValue;
                    boolean bl4 = false;
                    Iterable $this$map$iv = variables.getArray();
                    boolean $i$f$map = false;
                    it = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void variable;
                        PListValue pListValue2 = (PListValue)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl5 = false;
                        Plist variablePlist = variable.getPlist();
                        CharSequence charSequence = (CharSequence)scopeName;
                        String string = variablePlist.getPlistValue("name", "").getString();
                        Intrinsics.checkNotNull((Object)string);
                        String string2 = variablePlist.getPlistValue("value", "").getString();
                        Intrinsics.checkNotNull((Object)string2);
                        collection.add(new TextMateShellVariable(charSequence, string, string2));
                    }
                    list = (List)destination$iv$iv;
                } else {
                    list = CollectionsKt.emptyList();
                }
                List variables = list;
                TextMateTextAttributes customHighlightingAttributes = TextMateTextAttributes.Companion.fromPlist((Plist)settings);
                Set<TextMateBracePair> set6 = highlightingPairs;
                if (set6 == null) {
                    set6 = set2 = Constants.Companion.getDEFAULT_HIGHLIGHTING_BRACE_PAIRS();
                }
                if ((set = smartTypingPairs) == null) {
                    set = Constants.Companion.getDEFAULT_SMART_TYPING_BRACE_PAIRS();
                }
                set4 = set;
                textMatePreferences = new TextMatePreferences((String)scopeName, variables, set2, set4, null, null, indentationRules, customHighlightingAttributes, null);
            } else {
                textMatePreferences = null;
            }
        } else {
            textMatePreferences = null;
        }
        return textMatePreferences;
    }

    private static final Sequence<Plist> readPlistInDirectory(Path directory, PlistReader plistReader, String glob) {
        Object object;
        Object object2;
        try {
            boolean bl = false;
            object2 = Result.constructor-impl((Object)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)PathsKt.listDirectoryEntries((Path)directory, (String)glob)), arg_0 -> BundleReaderKt.readPlistInDirectory$lambda$10$lambda$9(plistReader, arg_0)));
        }
        catch (Throwable throwable) {
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable e = throwable;
            boolean bl = false;
            if (!(e instanceof NoSuchFileException)) {
                TextMateBundleReader.Companion.getLogger$intellij_textmate_core().warn("Can't load plists from directory: " + ((Object)directory).toString(), e);
            }
            object = SequencesKt.emptySequence();
        }
        return (Sequence)object;
    }

    static /* synthetic */ Sequence readPlistInDirectory$default(Path path, PlistReader plistReader, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = "*";
        }
        return BundleReaderKt.readPlistInDirectory(path, plistReader, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Plist readPlist(@NotNull InputStream inputStream, @NotNull PlistReader plistReader, @NotNull String debugName) {
        Object object;
        block8: {
            Object object2;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Intrinsics.checkNotNullParameter((Object)plistReader, (String)"plistReader");
            Intrinsics.checkNotNullParameter((Object)debugName, (String)"debugName");
            try {
                Object it;
                boolean bl = false;
                object2 = inputStream;
                Throwable throwable = null;
                try {
                    it = (InputStream)object2;
                    boolean bl2 = false;
                    it = plistReader.read((InputStream)it);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)it);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block8;
            Object e = object2 = throwable;
            boolean bl = false;
            TextMateBundleReader.Companion.getLogger$intellij_textmate_core().warn("Can't load plist from file: " + debugName, (Throwable)e);
        }
        return (Plist)(Result.isFailure-impl((Object)object) ? null : object);
    }

    private static final Plist readPlistInDirectory$lambda$10$lambda$9(PlistReader $plistReader, Path child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        OpenOption[] openOptionArray = new OpenOption[]{};
        InputStream inputStream = Files.newInputStream(child, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        InputStream inputStream2 = inputStream;
        int n = 8192;
        return BundleReaderKt.readPlist(inputStream2 instanceof BufferedInputStream ? (BufferedInputStream)inputStream2 : new BufferedInputStream(inputStream2, n), $plistReader, ((Object)child).toString());
    }

    public static final /* synthetic */ Sequence access$readPlistInDirectory(Path directory, PlistReader plistReader, String glob) {
        return BundleReaderKt.readPlistInDirectory(directory, plistReader, glob);
    }

    public static final /* synthetic */ TextMatePreferences access$readPreferencesFromPlist(Plist plist) {
        return BundleReaderKt.readPreferencesFromPlist(plist);
    }

    public static final /* synthetic */ TextMateSnippet access$readSnippetFromPlist(Plist plist, String explicitUuid) {
        return BundleReaderKt.readSnippetFromPlist(plist, explicitUuid);
    }
}

