/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.lang.DirectByteBufferBackedInputStream;
import com.intellij.util.lang.DirectByteBufferPool;
import com.intellij.util.lang.HashMapZipFile;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.function.IntFunction;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ImmutableZipEntry {
    static final byte STORED = 0;
    static final byte DEFLATED = 8;
    final int uncompressedSize;
    final int compressedSize;
    private final byte method;
    public final String name;
    private final long offsets;
    private int dataOffset = -1;

    ImmutableZipEntry(String name, int compressedSize, int uncompressedSize, int headerOffset, int nameLengthInBytes, byte method) {
        this.name = name;
        this.offsets = (long)headerOffset << 32 | (long)nameLengthInBytes & 0xFFFFFFFFL;
        this.compressedSize = compressedSize;
        this.uncompressedSize = uncompressedSize;
        this.method = method;
    }

    public boolean isCompressed() {
        return this.method != 0;
    }

    void setDataOffset(int dataOffset) {
        this.dataOffset = dataOffset;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirectory() {
        return this.uncompressedSize == -2;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public byte[] getData(@NotNull HashMapZipFile file) throws IOException {
        if (file == null) {
            ImmutableZipEntry.$$$reportNull$$$0(0);
        }
        if (this.uncompressedSize < 0) {
            throw new IOException("no data");
        }
        if (file.fileSize < this.dataOffset + this.compressedSize) {
            throw new EOFException();
        }
        switch (this.method) {
            case 0: {
                ByteBuffer inputBuffer = this.computeDataOffsetIfNeededAndReadInputBuffer(file.mappedBuffer);
                byte[] result = new byte[this.uncompressedSize];
                inputBuffer.get(result);
                return result;
            }
            case 8: {
                int count;
                ByteBuffer inputBuf = this.computeDataOffsetIfNeededAndReadInputBuffer(file.mappedBuffer);
                Inflater inflater = new Inflater(true);
                inflater.setInput(inputBuf);
                byte[] bytes = new byte[count];
                int offset = 0;
                try {
                    int n2;
                    for (count = this.uncompressedSize; count > 0; count -= n2) {
                        n2 = inflater.inflate(bytes, offset, count);
                        if (n2 == 0) {
                            throw new IllegalStateException("Inflater wants input, but input was already set");
                        }
                        offset += n2;
                    }
                    byte[] n2 = bytes;
                    return n2;
                }
                catch (DataFormatException e) {
                    String s = e.getMessage();
                    throw new ZipException(s == null ? "Invalid ZLIB data format" : s);
                }
                finally {
                    inflater.end();
                }
            }
        }
        throw new ZipException("Found unsupported compression method " + this.method);
    }

    @ApiStatus.Internal
    public InputStream getInputStream(@NotNull HashMapZipFile file) throws IOException {
        if (file == null) {
            ImmutableZipEntry.$$$reportNull$$$0(1);
        }
        return new DirectByteBufferBackedInputStream(this.getByteBuffer(file, null), this.method == 8);
    }

    @ApiStatus.Internal
    public ByteBuffer getByteBuffer(@NotNull HashMapZipFile file, @Nullable IntFunction<ByteBuffer> allocator) throws IOException {
        if (file == null) {
            ImmutableZipEntry.$$$reportNull$$$0(2);
        }
        if (this.uncompressedSize < 0) {
            throw new IOException("no data");
        }
        if (file.fileSize < this.dataOffset + this.compressedSize) {
            throw new EOFException();
        }
        switch (this.method) {
            case 0: {
                return this.computeDataOffsetIfNeededAndReadInputBuffer(file.mappedBuffer);
            }
            case 8: {
                ByteBuffer inputBuffer = this.computeDataOffsetIfNeededAndReadInputBuffer(file.mappedBuffer);
                Inflater inflater = new Inflater(true);
                inflater.setInput(inputBuffer);
                try {
                    ByteBuffer result;
                    ByteBuffer byteBuffer = result = allocator == null ? DirectByteBufferPool.DEFAULT_POOL.allocate(this.uncompressedSize) : allocator.apply(this.uncompressedSize);
                    while (result.hasRemaining()) {
                        if (inflater.inflate(result) != 0) continue;
                        throw new IllegalStateException("Inflater wants input, but input was already set");
                    }
                    result.rewind();
                    ByteBuffer byteBuffer2 = result;
                    return byteBuffer2;
                }
                catch (DataFormatException e) {
                    String s = e.getMessage();
                    throw new ZipException(s == null ? "Invalid ZLIB data format" : s);
                }
                finally {
                    inflater.end();
                }
            }
        }
        throw new ZipException("Found unsupported compression method " + this.method);
    }

    @NotNull
    private ByteBuffer computeDataOffsetIfNeededAndReadInputBuffer(ByteBuffer mappedBuffer) {
        int dataOffset = this.dataOffset;
        if (dataOffset == -1) {
            dataOffset = this.computeDataOffset(mappedBuffer);
        }
        ByteBuffer inputBuffer = mappedBuffer.asReadOnlyBuffer();
        inputBuffer.position(dataOffset);
        inputBuffer.limit(dataOffset + this.compressedSize);
        ByteBuffer byteBuffer = inputBuffer;
        if (byteBuffer == null) {
            ImmutableZipEntry.$$$reportNull$$$0(3);
        }
        return byteBuffer;
    }

    private int computeDataOffset(ByteBuffer mappedBuffer) {
        int result;
        int headerOffset = (int)(this.offsets >> 32);
        int start = headerOffset + 28;
        int extraFieldLength = mappedBuffer.getShort(start) & 0xFFFF;
        if (extraFieldLength > 128) {
            throw new UnsupportedOperationException("extraFieldLength expected to be less than 128 bytes but " + extraFieldLength + " (name=" + this.name + ")");
        }
        int nameLengthInBytes = (int)this.offsets;
        this.dataOffset = result = start + 2 + nameLengthInBytes + extraFieldLength;
        return result;
    }

    public String toString() {
        return this.name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/lang/ImmutableZipEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/lang/ImmutableZipEntry";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDataOffsetIfNeededAndReadInputBuffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getByteBuffer";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

