/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.toolwindow.preview;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.model.RemoteConfigService;
import com.intellij.packageChecker.service.PackageStatus;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.packageChecker.toolwindow.preview.PackageHtmlRenderer;
import com.intellij.packageChecker.toolwindow.preview.TextDescriptionRenderer;
import com.intellij.ui.BrowserHyperlinkListener;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBFont;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.util.Locale;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.problems.vulnerabilities.CallToAction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0003J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0002J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0003J\u0012\u0010\u0019\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0003J\u0012\u0010\u001a\u001a\u00020\u00152\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0003J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0015H\u0002J\u0006\u0010\u001d\u001a\u00020\u0015R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/packageChecker/toolwindow/preview/PackageTitlePanel;", "Lcom/intellij/ui/components/JBPanel;", "packageStatus", "Lcom/intellij/packageChecker/service/PackageStatus;", "descriptionRenderer", "Lcom/intellij/packageChecker/toolwindow/preview/TextDescriptionRenderer;", "<init>", "(Lcom/intellij/packageChecker/service/PackageStatus;Lcom/intellij/packageChecker/toolwindow/preview/TextDescriptionRenderer;)V", "getPackageStatus", "()Lcom/intellij/packageChecker/service/PackageStatus;", "setPackageStatus", "(Lcom/intellij/packageChecker/service/PackageStatus;)V", "packageLabel", "Ljavax/swing/JEditorPane;", "copyDescriptionLink", "Lcom/intellij/ui/components/ActionLink;", "copySafeVersionTitle", "copySafeVersionLink", "setPackageStatusAndUpdateSafeVersion", "", "packageText", "", "pkgStatus", "getSafeVersion", "copySafeVersionTitleText", "copySafeVersionLinkText", "copyDescriptionLinkText", "copySafeVersionToClipboard", "urlDescription", "getContentAsText", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageTitlePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageTitlePanel.kt\ncom/intellij/packageChecker/toolwindow/preview/PackageTitlePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public final class PackageTitlePanel
extends JBPanel<PackageTitlePanel> {
    @Nullable
    private PackageStatus packageStatus;
    @NotNull
    private final JEditorPane packageLabel;
    @NotNull
    private final ActionLink copyDescriptionLink;
    @NotNull
    private final JEditorPane copySafeVersionTitle;
    @NotNull
    private final JEditorPane copySafeVersionLink;

    /*
     * WARNING - void declaration
     */
    public PackageTitlePanel(@Nullable PackageStatus packageStatus, @NotNull TextDescriptionRenderer descriptionRenderer) {
        void it;
        JEditorPane jEditorPane;
        Intrinsics.checkNotNullParameter((Object)descriptionRenderer, (String)"descriptionRenderer");
        super((LayoutManager)new GridBagLayout());
        this.packageStatus = packageStatus;
        JEditorPane jEditorPane2 = jEditorPane = ComponentsKt.htmlComponent$default((String)this.packageText(this.packageStatus), (Font)((Font)JBFont.label()), null, null, (boolean)false, null, (int)60, null);
        PackageTitlePanel packageTitlePanel = this;
        boolean bl = false;
        it.setFocusable(true);
        packageTitlePanel.packageLabel = jEditorPane;
        this.copyDescriptionLink = new ActionLink(this.copyDescriptionLinkText(this.packageStatus), arg_0 -> PackageTitlePanel.copyDescriptionLink$lambda$1(descriptionRenderer, this, arg_0));
        this.copySafeVersionTitle = ComponentsKt.htmlComponent$default((String)this.copySafeVersionTitleText(this.packageStatus), null, null, null, (boolean)false, null, (int)62, null);
        this.copySafeVersionLink = ComponentsKt.htmlComponent$default((String)this.copySafeVersionLinkText(this.packageStatus), null, null, null, (boolean)false, arg_0 -> PackageTitlePanel.copySafeVersionLink$lambda$3(this, arg_0), (int)30, null);
        GridBag gridBag = new GridBag().setDefaultAnchor(0, 17).setDefaultAnchor(1, 13).setDefaultInsets(16, 20, 0, 0).setDefaultFill(2);
        Intrinsics.checkNotNullExpressionValue((Object)gridBag, (String)"setDefaultFill(...)");
        GridBag gridBag2 = gridBag;
        this.add(this.packageLabel, gridBag2.nextLine().next().weightx(1.0).anchor(21));
        String copyright = RemoteConfigService.getCopyright$default(RemoteConfigService.Companion.getInstance(), false, 1, null);
        if (copyright != null) {
            void it2;
            JEditorPane jEditorPane3;
            JEditorPane jEditorPane4 = jEditorPane3 = ComponentsKt.htmlComponent$default((String)copyright, null, null, null, (boolean)false, null, (int)62, null);
            packageTitlePanel = this;
            boolean bl2 = false;
            it2.setFocusable(true);
            packageTitlePanel.add(jEditorPane3, gridBag2.next().coverLine().weightx(0.0).anchor(22));
        }
        this.add((Component)this.copyDescriptionLink, gridBag2.nextLine().next().coverLine());
        this.add(this.copySafeVersionTitle, gridBag2.nextLine().next());
        this.add(this.copySafeVersionLink, gridBag2.nextLine().next().coverLine());
    }

    @Nullable
    public final PackageStatus getPackageStatus() {
        return this.packageStatus;
    }

    public final void setPackageStatus(@Nullable PackageStatus packageStatus) {
        this.packageStatus = packageStatus;
    }

    public final void setPackageStatusAndUpdateSafeVersion(@Nullable PackageStatus packageStatus) {
        this.packageStatus = packageStatus;
        ApplicationManager.getApplication().invokeLater(() -> PackageTitlePanel.setPackageStatusAndUpdateSafeVersion$lambda$5(this, packageStatus));
    }

    @NlsSafe
    private final String packageText(PackageStatus pkgStatus2) {
        Object object = pkgStatus2;
        if (object == null || (object = ((PackageStatus)object).getPkg()) == null) {
            String string = PackageCheckerBundle.message("dependency.tree.select.dependency.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        Object pkg = object;
        Object[] objectArray = new Object[2];
        objectArray[0] = ((Package)pkg).getHumanReadableCoordinates();
        String string = pkgStatus2.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
        String string2 = PackageCheckerBundle.message("dependency.tree.package.html.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    private final String getSafeVersion(PackageStatus pkgStatus2) {
        Object object;
        return pkgStatus2 instanceof Vulnerable ? ((object = ((Vulnerable)pkgStatus2).getVulnerablePackage().getCallToAction()) != null && (object = ((CallToAction)object).getNewVersion()) != null ? ((SingleVersion)object).getValue() : null) : null;
    }

    @NlsSafe
    private final String copySafeVersionTitleText(PackageStatus pkgStatus2) {
        String string = this.getSafeVersion(pkgStatus2);
        if (string == null) {
            return "";
        }
        String safeVersion = string;
        Object[] objectArray = new Object[]{safeVersion};
        String string2 = PackageCheckerBundle.message("dependency.safe.version.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NlsSafe
    private final String copySafeVersionLinkText(PackageStatus pkgStatus2) {
        String string = this.getSafeVersion(pkgStatus2);
        if (string == null) {
            return "";
        }
        String safeVersion = string;
        Object[] objectArray = new Object[]{"#copyCall2action", safeVersion, "Copy safe version to clipboard"};
        String string2 = PackageCheckerBundle.message("dependency.safe.version.link", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        return string2;
    }

    @NlsSafe
    private final String copyDescriptionLinkText(PackageStatus packageStatus) {
        String string;
        if (packageStatus instanceof Vulnerable) {
            String string2 = PackageCheckerBundle.message("dependency.copy.description.link", new Object[0]);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            string = "";
        }
        return string;
    }

    private final void copySafeVersionToClipboard(String urlDescription) {
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(PackageHtmlRenderer.INSTANCE.getCallToAction(urlDescription)));
    }

    @NotNull
    public final String getContentAsText() {
        Object object;
        block3: {
            block2: {
                StringBuilder stringBuilder;
                PackageStatus packageStatus = this.packageStatus;
                object = packageStatus instanceof Vulnerable ? (Vulnerable)packageStatus : null;
                if (object == null) break block2;
                Vulnerable it = object;
                boolean bl = false;
                String newLine = System.lineSeparator();
                StringBuilder $this$getContentAsText_u24lambda_u247_u24lambda_u246 = stringBuilder = new StringBuilder();
                boolean bl2 = false;
                Object[] objectArray = new Object[2];
                objectArray[0] = it.getPkg().getHumanReadableCoordinates();
                String string = it.getClass().getSimpleName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                $this$getContentAsText_u24lambda_u247_u24lambda_u246.append(PackageCheckerBundle.message("dependency.tree.package.text.message", objectArray));
                $this$getContentAsText_u24lambda_u247_u24lambda_u246.append(newLine);
                $this$getContentAsText_u24lambda_u247_u24lambda_u246.append(newLine);
                $this$getContentAsText_u24lambda_u247_u24lambda_u246.append(this.copySafeVersionTitleText(this.packageStatus));
                String string2 = stringBuilder.toString();
                object = string2;
                if (string2 != null) break block3;
            }
            object = "";
        }
        return object;
    }

    private static final Unit copyDescriptionLink$lambda$1(TextDescriptionRenderer $descriptionRenderer, PackageTitlePanel this$0, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        String contentAsText = $descriptionRenderer.getContentAsText(this$0);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(contentAsText));
        return Unit.INSTANCE;
    }

    private static final void copySafeVersionLink$lambda$3(PackageTitlePanel this$0, HyperlinkEvent e) {
        if (Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            String $this$copySafeVersionLink_u24lambda_u243_u24lambda_u242 = e.getDescription();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$copySafeVersionLink_u24lambda_u243_u24lambda_u242);
            if (PackageHtmlRenderer.INSTANCE.isCallToActionUrlDescription($this$copySafeVersionLink_u24lambda_u243_u24lambda_u242)) {
                this$0.copySafeVersionToClipboard($this$copySafeVersionLink_u24lambda_u243_u24lambda_u242);
                return;
            }
        }
        BrowserHyperlinkListener.INSTANCE.hyperlinkUpdate(e);
    }

    private static final void setPackageStatusAndUpdateSafeVersion$lambda$5(PackageTitlePanel this$0, PackageStatus $packageStatus) {
        this$0.packageLabel.setText(this$0.packageText($packageStatus));
        this$0.packageLabel.setFocusable(true);
        this$0.copySafeVersionTitle.setText(this$0.copySafeVersionTitleText($packageStatus));
        this$0.copySafeVersionTitle.setFocusable(true);
        this$0.copySafeVersionLink.setText(this$0.copySafeVersionLinkText($packageStatus));
        this$0.copySafeVersionLink.setFocusable(true);
        this$0.copyDescriptionLink.setText(this$0.copyDescriptionLinkText($packageStatus));
        this$0.copyDescriptionLink.setFocusable(true);
        this$0.invalidate();
    }
}

