/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.service;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.inspection.VulnerableLibrariesLocalInspection;
import com.intellij.packageChecker.service.IgnoreReason;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.Package;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\r"}, d2={"ignoreVulnerability", "", "project", "Lcom/intellij/openapi/project/Project;", "pkg", "Lorg/jetbrains/security/package/Package;", "moduleName", "", "reason", "getInspectionInstanceIfIgnoringEnabled", "Lcom/intellij/packageChecker/inspection/VulnerableLibrariesLocalInspection;", "isPackageIgnored", "", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nIgnorableDependenciesService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IgnorableDependenciesService.kt\ncom/intellij/packageChecker/service/IgnorableDependenciesServiceKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public final class IgnorableDependenciesServiceKt {
    public static final void ignoreVulnerability(@NotNull Project project, @NotNull Package pkg, @NotNull String moduleName, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        ApplicationManager.getApplication().runWriteAction(() -> IgnorableDependenciesServiceKt.ignoreVulnerability$lambda$0(project, pkg, moduleName, reason));
    }

    @Nullable
    public static final VulnerableLibrariesLocalInspection getInspectionInstanceIfIgnoringEnabled(@NotNull Project project) {
        VulnerableLibrariesLocalInspection vulnerableLibrariesLocalInspection;
        VulnerableLibrariesLocalInspection instance;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper = profile.getInspectionTool("VulnerableLibrariesLocal", project);
        if (inspectionToolWrapper == null || (inspectionToolWrapper = inspectionToolWrapper.getTool()) == null) {
            return null;
        }
        InspectionToolWrapper inspectionInstance = inspectionToolWrapper;
        VulnerableLibrariesLocalInspection vulnerableLibrariesLocalInspection2 = instance = inspectionInstance instanceof VulnerableLibrariesLocalInspection ? (VulnerableLibrariesLocalInspection)inspectionInstance : null;
        if (vulnerableLibrariesLocalInspection2 != null) {
            VulnerableLibrariesLocalInspection vulnerableLibrariesLocalInspection3;
            VulnerableLibrariesLocalInspection it = vulnerableLibrariesLocalInspection3 = vulnerableLibrariesLocalInspection2;
            boolean bl = false;
            vulnerableLibrariesLocalInspection = it.isIgnoringEnabled ? vulnerableLibrariesLocalInspection3 : null;
        } else {
            vulnerableLibrariesLocalInspection = null;
        }
        return vulnerableLibrariesLocalInspection;
    }

    public static final boolean isPackageIgnored(@NotNull Project project, @NotNull Package pkg, @NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        VulnerableLibrariesLocalInspection vulnerableLibrariesLocalInspection = IgnorableDependenciesServiceKt.getInspectionInstanceIfIgnoringEnabled(project);
        if (vulnerableLibrariesLocalInspection == null) {
            return false;
        }
        VulnerableLibrariesLocalInspection instance = vulnerableLibrariesLocalInspection;
        return instance.isIgnorable(pkg, moduleName);
    }

    private static final void ignoreVulnerability$lambda$0(Project $project, Package $pkg, String $moduleName, String $reason) {
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)$project).getCurrentProfile();
        Intrinsics.checkNotNullExpressionValue((Object)inspectionProfileImpl, (String)"getCurrentProfile(...)");
        InspectionProfileImpl profile = inspectionProfileImpl;
        InspectionToolWrapper inspectionToolWrapper = profile.getInspectionTool("VulnerableLibrariesLocal", $project);
        InspectionProfileEntry inspectionInstance = inspectionToolWrapper != null ? inspectionToolWrapper.getTool() : null;
        Intrinsics.checkNotNull((Object)inspectionInstance, (String)"null cannot be cast to non-null type com.intellij.packageChecker.inspection.VulnerableLibrariesLocalInspection");
        VulnerableLibrariesLocalInspection instance = (VulnerableLibrariesLocalInspection)inspectionInstance;
        instance.ignoreVulnerability($project, $pkg, $moduleName, $reason);
        PackageCheckerUsageStat.INSTANCE.getDependencyIsIgnored().log((Object)IgnoreReason.Companion.getOriginalReason($reason));
    }
}

