/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFormattedStringElement;
import com.jetbrains.python.psi.PyPlainStringElement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class PyQuotesUtil {
    private PyQuotesUtil() {
    }

    public static boolean canBeConverted(@NotNull PyStringElement stringElement, boolean checkContainingFString) {
        Collection innerStrings;
        PyFormattedStringElement fStringElement;
        if (stringElement == null) {
            PyQuotesUtil.$$$reportNull$$$0(0);
        }
        if (stringElement.isTripleQuoted() || !stringElement.isTerminated()) {
            return false;
        }
        if (checkContainingFString) {
            PyFormattedStringElement parentFString = (PyFormattedStringElement)PsiTreeUtil.getParentOfType((PsiElement)stringElement, PyFormattedStringElement.class, (boolean)true, (Class[])new Class[]{PyStatement.class});
            char targetQuote = PyStringLiteralUtil.flipQuote((char)stringElement.getQuote().charAt(0));
            if (parentFString != null && LanguageLevel.forElement((PsiElement)stringElement).isOlderThan(LanguageLevel.PYTHON312)) {
                boolean parentFStringUsesTargetQuotes = parentFString.getQuote().equals(Character.toString(targetQuote));
                if (parentFStringUsesTargetQuotes) {
                    return false;
                }
                boolean conversionIntroducesBackslashEscapedQuote = stringElement.textContains(targetQuote);
                if (conversionIntroducesBackslashEscapedQuote) {
                    return false;
                }
            }
        }
        return (fStringElement = PyUtil.as(stringElement, PyFormattedStringElement.class)) == null || !ContainerUtil.exists((Iterable)(innerStrings = PsiTreeUtil.findChildrenOfType((PsiElement)fStringElement, PyStringElement.class)), s -> !PyQuotesUtil.canBeConverted(s, false));
    }

    @NotNull
    public static PyStringElement createCopyWithConvertedQuotes(@NotNull PyStringElement element) {
        if (element == null) {
            PyQuotesUtil.$$$reportNull$$$0(1);
        }
        StringBuilder builder = new StringBuilder();
        PyQuotesUtil.processStringElement(builder, element);
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(element.getProject());
        PyStringElement pyStringElement = (PyStringElement)elementGenerator.createStringLiteralAlreadyEscaped(builder.toString()).getFirstChild();
        if (pyStringElement == null) {
            PyQuotesUtil.$$$reportNull$$$0(2);
        }
        return pyStringElement;
    }

    private static void processStringElement(final @NotNull StringBuilder builder, @NotNull PyStringElement stringElement) {
        if (builder == null) {
            PyQuotesUtil.$$$reportNull$$$0(3);
        }
        if (stringElement == null) {
            PyQuotesUtil.$$$reportNull$$$0(4);
        }
        final char originalQuote = stringElement.getQuote().charAt(0);
        if (stringElement instanceof PyPlainStringElement) {
            PyQuotesUtil.processStringElementText(builder, stringElement.getText(), originalQuote);
        } else {
            final boolean fStringCanIncludeArbitraryStringLiterals = LanguageLevel.forElement((PsiElement)stringElement).isAtLeast(LanguageLevel.PYTHON312);
            stringElement.acceptChildren(new PyRecursiveElementVisitor(){

                @Override
                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (element instanceof PyStringElement) {
                        if (fStringCanIncludeArbitraryStringLiterals) {
                            builder.append(element.getText());
                        } else {
                            PyQuotesUtil.processStringElement(builder, (PyStringElement)element);
                        }
                    } else if (PyTokenTypes.FSTRING_TOKENS.contains(element.getNode().getElementType())) {
                        PyQuotesUtil.processStringElementText(builder, element.getText(), originalQuote);
                    } else if (element.getNode().getChildren(null).length == 0) {
                        builder.append(element.getText());
                    } else {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/psi/PyQuotesUtil$1", "visitElement"));
                }
            });
        }
    }

    private static void processStringElementText(@NotNull StringBuilder builder, @NotNull String stringText, char originalQuote) {
        if (builder == null) {
            PyQuotesUtil.$$$reportNull$$$0(5);
        }
        if (stringText == null) {
            PyQuotesUtil.$$$reportNull$$$0(6);
        }
        char targetQuote = PyStringLiteralUtil.flipQuote((char)originalQuote);
        char[] charArr = stringText.toCharArray();
        for (int i = 0; i != charArr.length; ++i) {
            char ch2;
            char ch1 = charArr[i];
            char c = ch2 = i + 1 < charArr.length ? charArr[i + 1] : (char)'\u0000';
            if (ch1 == originalQuote) {
                builder.append(targetQuote);
                continue;
            }
            if (ch1 == targetQuote) {
                builder.append("\\").append(targetQuote);
                continue;
            }
            if (ch1 == '\\') {
                if (ch2 == originalQuote) {
                    builder.append(ch2);
                    ++i;
                    continue;
                }
                if (ch2 == '\u0000') {
                    builder.append(ch1);
                    continue;
                }
                builder.append(ch1).append(ch2);
                ++i;
                continue;
            }
            builder.append(ch1);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyQuotesUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyQuotesUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyWithConvertedQuotes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeConverted";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createCopyWithConvertedQuotes";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processStringElement";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processStringElementText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

