/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.pip;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.statistics.PyStatisticToolsKt;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\u000bH\u0002J\u0006\u0010\r\u001a\u00020\u000bJ\b\u0010\u000e\u001a\u00020\u000bH\u0002J\u001e\u0010\u000f\u001a\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J!\u0010\u0014\u001a\u00020\u000b2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0016\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0016\u0010\u0018\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0002J/\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0016\"\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010 R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/python/packaging/pip/PipManagementInstaller;", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "manager", "Lcom/jetbrains/python/packaging/management/PythonPackageManager;", "<init>", "(Lcom/intellij/openapi/projectRoots/Sdk;Lcom/jetbrains/python/packaging/management/PythonPackageManager;)V", "languageLevel", "Lcom/jetbrains/python/psi/LanguageLevel;", "installManagementIfNeeded", "", "performManagementInstallation", "hasManagement", "installManagement", "installWheelIfMissing", "requirementCheck", "Lkotlin/Function0;", "wheelNameToInstall", "", "installUsingPipWheel", "additionalArgs", "", "([Ljava/lang/String;)Z", "executeCommand", "commandArguments", "", "hasPip", "hasSetuptools", "buildCommandArguments", "wheelPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;[Ljava/lang/String;)Ljava/util/List;", "WheelFiles", "Companion", "intellij.python.community.impl"})
@ApiStatus.Internal
public final class PipManagementInstaller {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final PythonPackageManager manager;
    @NotNull
    private final LanguageLevel languageLevel;
    @NotNull
    private static final PythonPackage PIP_PACKAGE = new PythonPackage("pip", "24.3.1", false);
    @NotNull
    private static final PythonPackage SETUPTOOLS_PACKAGE = new PythonPackage("setuptools", "44.1.1", false);
    @NotNull
    private static final PythonPackage DISTRIBUTE_PACKAGE = new PythonPackage("distribute", "", false);

    public PipManagementInstaller(@NotNull Sdk sdk2, @NotNull PythonPackageManager manager) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.sdk = sdk2;
        this.manager = manager;
        this.languageLevel = PyStatisticToolsKt.getVersion(this.sdk);
    }

    public final boolean installManagementIfNeeded() {
        if (this.hasManagement()) {
            return true;
        }
        return this.performManagementInstallation();
    }

    private final boolean performManagementInstallation() {
        return this.installManagement();
    }

    public final boolean hasManagement() {
        return this.languageLevel.compareTo((Enum)LanguageLevel.PYTHON27) < 0 || this.manager.packageExists(PIP_PACKAGE) && this.hasSetuptools();
    }

    private final boolean installManagement() {
        return this.installWheelIfMissing((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

            public final Boolean invoke() {
                return PipManagementInstaller.access$hasPip((PipManagementInstaller)this.receiver);
            }
        }), "pip-24.3.1-py2.py3-none-any.whl") && this.installWheelIfMissing((Function0<Boolean>)((Function0)new Function0<Boolean>((Object)this){

            public final Boolean invoke() {
                return PipManagementInstaller.access$hasSetuptools((PipManagementInstaller)this.receiver);
            }
        }), "setuptools-44.1.1-py2.py3-none-any.whl");
    }

    private final boolean installWheelIfMissing(Function0<Boolean> requirementCheck, String wheelNameToInstall) {
        if (!((Boolean)requirementCheck.invoke()).booleanValue()) {
            Object object = PythonHelpersLocator.Companion.findPathInHelpers(wheelNameToInstall);
            if (object == null || (object = object.toString()) == null) {
                return false;
            }
            Object wheelPathToInstall = object;
            String[] stringArray = new String[]{"--no-index", wheelPathToInstall};
            return this.installUsingPipWheel(stringArray);
        }
        return true;
    }

    private final boolean installUsingPipWheel(String ... additionalArgs) {
        Path pipWheelPath;
        Path path2 = PythonHelpersLocator.Companion.findPathInHelpers("pip-24.3.1-py2.py3-none-any.whl");
        Path path3 = pipWheelPath = path2 != null ? path2.resolve(Path.of("pip", new String[0])) : null;
        if (pipWheelPath == null) {
            return false;
        }
        List<String> commandArguments = this.buildCommandArguments(pipWheelPath, Arrays.copyOf(additionalArgs, additionalArgs.length));
        return this.executeCommand(commandArguments);
    }

    private final boolean executeCommand(List<String> commandArguments) {
        boolean bl;
        try {
            CapturingProcessHandler processHandler = new CapturingProcessHandler(new GeneralCommandLine(commandArguments));
            ProcessOutput processOutput2 = processHandler.runProcess();
            Intrinsics.checkNotNullExpressionValue((Object)processOutput2, (String)"runProcess(...)");
            ProcessOutput output2 = processOutput2;
            bl = output2.getExitCode() == 0;
        }
        catch (Exception ex) {
            throw new ExecutionException(ex.getMessage(), (Throwable)ex);
        }
        return bl;
    }

    private final boolean hasPip() {
        return this.manager.packageExists(PIP_PACKAGE);
    }

    private final boolean hasSetuptools() {
        return this.languageLevel.compareTo((Enum)LanguageLevel.PYTHON312) >= 0 || this.manager.packageExists(SETUPTOOLS_PACKAGE) || this.manager.packageExists(DISTRIBUTE_PACKAGE);
    }

    private final List<String> buildCommandArguments(Path wheelPath, String ... additionalArgs) {
        Object[] objectArray = new String[]{String.valueOf(this.sdk.getHomePath()), ((Object)wheelPath).toString(), "install"};
        return CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull((Object[])objectArray), (Object[])additionalArgs);
    }

    public static final /* synthetic */ boolean access$hasPip(PipManagementInstaller $this) {
        return $this.hasPip();
    }

    public static final /* synthetic */ boolean access$hasSetuptools(PipManagementInstaller $this) {
        return $this.hasSetuptools();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/packaging/pip/PipManagementInstaller$Companion;", "", "<init>", "()V", "PIP_PACKAGE", "Lcom/jetbrains/python/packaging/common/PythonPackage;", "getPIP_PACKAGE", "()Lcom/jetbrains/python/packaging/common/PythonPackage;", "SETUPTOOLS_PACKAGE", "getSETUPTOOLS_PACKAGE", "DISTRIBUTE_PACKAGE", "getDISTRIBUTE_PACKAGE", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PythonPackage getPIP_PACKAGE() {
            return PIP_PACKAGE;
        }

        @NotNull
        public final PythonPackage getSETUPTOOLS_PACKAGE() {
            return SETUPTOOLS_PACKAGE;
        }

        @NotNull
        public final PythonPackage getDISTRIBUTE_PACKAGE() {
            return DISTRIBUTE_PACKAGE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/packaging/pip/PipManagementInstaller$WheelFiles;", "", "<init>", "()V", "SETUPTOOLS_WHEEL_NAME", "", "PIP_WHEEL_NAME", "intellij.python.community.impl"})
    private static final class WheelFiles {
        @NotNull
        public static final WheelFiles INSTANCE = new WheelFiles();
        @NotNull
        public static final String SETUPTOOLS_WHEEL_NAME = "setuptools-44.1.1-py2.py3-none-any.whl";
        @NotNull
        public static final String PIP_WHEEL_NAME = "pip-24.3.1-py2.py3-none-any.whl";

        private WheelFiles() {
        }
    }
}

