/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPackageNameNormalizeUtilKt;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyPackagingSettings;
import com.jetbrains.python.packaging.repository.PyPackageRepositories;
import com.jetbrains.python.packaging.repository.PyPackageRepositoryUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PyPIPackageUtil {
    private static final Logger LOG = Logger.getInstance(PyPIPackageUtil.class);
    private static final Gson GSON = new GsonBuilder().create();
    private static final String PYPI_BASE_URL = "https://pypi.org";
    private static final String PYPI_SIMPLE_REPOSITORY_API = "/simple/";
    private static final String PYPI_DETAILS_API = "/pypi/";
    private static final String PYPI_PROJECT_API = "/project/";
    @Deprecated
    public static final String PYPI_URL = "https://pypi.org/pypi";
    public static final String PYPI_LIST_URL = "https://pypi.org/simple/";
    public static final PyPIPackageUtil INSTANCE = new PyPIPackageUtil();
    private final LoadingCache<String, List<String>> myAdditionalPackagesReleases = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<String>>(){

        public List<String> load(@NotNull String key) throws Exception {
            if (key == null) {
                1.$$$reportNull$$$0(0);
            }
            LOG.debug("Searching for versions of package '" + key + "' in additional repositories");
            List<String> repositories = PyPackageService.getInstance().additionalRepositories;
            for (String repository : repositories) {
                try {
                    List<String> versions2 = PyPIPackageUtil.parsePackageVersionsFromRepository(repository, key);
                    if (versions2.isEmpty()) continue;
                    LOG.debug("Found versions " + String.valueOf(versions2) + "of " + key + " at " + repository);
                    return Collections.unmodifiableList(versions2);
                }
                catch (HttpRequests.HttpStatusException e) {
                    if (e.getStatusCode() == 404) continue;
                    LOG.debug("Cannot access " + e.getUrl() + ": " + e.getMessage());
                }
            }
            return Collections.emptyList();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$1", "load"));
        }
    });
    private final LoadingCache<String, List<RepoPackage>> myAdditionalPackages = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<RepoPackage>>(){

        public List<RepoPackage> load(@NotNull String key) throws Exception {
            if (key == null) {
                2.$$$reportNull$$$0(0);
            }
            return PyPIPackageUtil.getPackagesFromAdditionalRepository(key);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$2", "load"));
        }
    });
    private final LoadingCache<String, PackageDetails> myPackageToDetails = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, PackageDetails>(){

        public PackageDetails load(@NotNull String key) throws Exception {
            if (key == null) {
                3.$$$reportNull$$$0(0);
            }
            LOG.debug("Fetching details for the package '" + key + "' on PyPI");
            String detailsUrl = PyPIPackageUtil.buildDetailsUrl(PyPIPackageUtil.PYPI_LIST_URL, key);
            return (PackageDetails)HttpRequests.request((String)detailsUrl).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> (PackageDetails)GSON.fromJson((Reader)request.getReader(), PackageDetails.class));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/jetbrains/python/packaging/PyPIPackageUtil$3", "load"));
        }
    });
    private final Object myPyPIPackageCacheUpdateLock = new Object();

    private PyPIPackageUtil() {
    }

    @NotNull
    private static String getUserAgent() {
        String string = ApplicationNamesInfo.getInstance().getProductName() + "/" + ApplicationInfo.getInstance().getFullVersion();
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean isPyPIRepository(@Nullable String repository) {
        return repository != null && repository.startsWith(PYPI_BASE_URL);
    }

    @NotNull
    public List<RepoPackage> getAdditionalPackages(@NotNull List<String> repositories) {
        if (repositories == null) {
            PyPIPackageUtil.$$$reportNull$$$0(1);
        }
        List list = StreamEx.of((Collection)this.myAdditionalPackages.getAllPresent(repositories).values()).flatMap(StreamEx::of).toList();
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void loadAdditionalPackages(@NotNull List<String> repositories, boolean alwaysRefresh) {
        if (repositories == null) {
            PyPIPackageUtil.$$$reportNull$$$0(3);
        }
        ArrayList<String> failedToConnect = new ArrayList<String>();
        if (alwaysRefresh) {
            for (String url : repositories) {
                try {
                    this.myAdditionalPackages.refresh((Object)url);
                }
                catch (Exception e) {
                    LOG.error("Error connecting to " + url, (Throwable)e);
                    failedToConnect.add(url);
                    ((PyPackageRepositories)ApplicationManager.getApplication().getService(PyPackageRepositories.class)).markInvalid(url);
                }
            }
        } else {
            for (String url : repositories) {
                try {
                    PyPIPackageUtil.getCachedValueOrRethrowIO(this.myAdditionalPackages, url);
                }
                catch (Exception e) {
                    LOG.warn("Error connecting to " + url, (Throwable)e);
                    failedToConnect.add(url);
                    ((PyPackageRepositories)ApplicationManager.getApplication().getService(PyPackageRepositories.class)).markInvalid(url);
                }
            }
        }
        if (!failedToConnect.isEmpty()) {
            PyPackageService packageService = PyPackageService.getInstance();
            failedToConnect.forEach(repo -> packageService.removeRepository((String)repo));
        }
    }

    @NotNull
    private static List<RepoPackage> getPackagesFromAdditionalRepository(@NotNull String url) throws IOException {
        if (url == null) {
            PyPIPackageUtil.$$$reportNull$$$0(4);
        }
        List<RepoPackage> list = PyPIPackageUtil.parsePyPIListFromWeb(url).stream().map(s -> new RepoPackage(s, url, null)).collect(Collectors.toList());
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(5);
        }
        return list;
    }

    public void fillPackageDetails(@NotNull String packageName, @NotNull CatchingConsumer<PackageDetails.Info, Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(6);
        }
        if (callback == null) {
            PyPIPackageUtil.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                PackageDetails packageDetails = this.refreshAndGetPackageDetailsFromPyPI(packageName, false);
                callback.consume((Object)packageDetails.getInfo());
            }
            catch (IOException e) {
                callback.consume((Throwable)e);
            }
        });
    }

    @NotNull
    private PackageDetails refreshAndGetPackageDetailsFromPyPI(@NotNull String packageName, boolean alwaysRefresh) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(8);
        }
        if (alwaysRefresh) {
            this.myPackageToDetails.invalidate((Object)packageName);
        }
        return PyPIPackageUtil.getCachedValueOrRethrowIO(this.myPackageToDetails, packageName);
    }

    public void usePackageReleases(@NotNull String packageName, @NotNull CatchingConsumer<? super List<String>, ? super Exception> callback) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(9);
        }
        if (callback == null) {
            PyPIPackageUtil.$$$reportNull$$$0(10);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                List<String> releasesFromSimpleIndex = this.getPackageVersionsFromAdditionalRepositories(packageName);
                if (releasesFromSimpleIndex.isEmpty()) {
                    List<String> releasesFromPyPI = this.getPackageVersionsFromPyPI(packageName, true);
                    callback.consume(releasesFromPyPI);
                } else {
                    callback.consume(releasesFromSimpleIndex);
                }
            }
            catch (Exception e) {
                callback.consume((Throwable)e);
            }
        });
    }

    @NotNull
    private List<String> getPackageVersionsFromPyPI(@NotNull String packageName, boolean force) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(11);
        }
        PackageDetails details = this.refreshAndGetPackageDetailsFromPyPI(packageName, force);
        List<String> result2 = details.getReleases();
        result2.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
        List<String> list = Collections.unmodifiableList(result2);
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @Nullable
    private String getLatestPackageVersionFromPyPI(@NotNull Project project, @NotNull String packageName) throws IOException {
        if (project == null) {
            PyPIPackageUtil.$$$reportNull$$$0(13);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(14);
        }
        LOG.debug("Requesting the latest PyPI version for the package " + packageName);
        List<String> versions2 = this.getPackageVersionsFromPyPI(packageName, true);
        if (project.isDisposed()) {
            return null;
        }
        return PyPackagingSettings.getInstance(project).selectLatestVersion(versions2);
    }

    @NotNull
    private List<String> getPackageVersionsFromAdditionalRepositories(@NotNull String packageName) throws IOException {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(15);
        }
        return PyPIPackageUtil.getCachedValueOrRethrowIO(this.myAdditionalPackagesReleases, packageName);
    }

    @NotNull
    private static <T> T getCachedValueOrRethrowIO(@NotNull LoadingCache<String, ? extends T> cache, @NotNull String key) throws IOException {
        Object object;
        if (cache == null) {
            PyPIPackageUtil.$$$reportNull$$$0(16);
        }
        if (key == null) {
            PyPIPackageUtil.$$$reportNull$$$0(17);
        }
        try {
            object = cache.get((Object)key);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Throwable cause = e.getCause();
            throw cause instanceof IOException ? (IOException)cause : new IOException("Unexpected non-IO error", cause);
        }
        if (object == null) {
            PyPIPackageUtil.$$$reportNull$$$0(18);
        }
        return (T)object;
    }

    @Nullable
    private String getLatestPackageVersionFromAdditionalRepositories(@NotNull Project project, @NotNull String packageName) throws IOException {
        if (project == null) {
            PyPIPackageUtil.$$$reportNull$$$0(19);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(20);
        }
        List<String> versions2 = this.getPackageVersionsFromAdditionalRepositories(packageName);
        return PyPackagingSettings.getInstance(project).selectLatestVersion(versions2);
    }

    @Nullable
    public String fetchLatestPackageVersion(@NotNull Project project, @NotNull String packageName) throws IOException {
        String extraVersion;
        if (project == null) {
            PyPIPackageUtil.$$$reportNull$$$0(21);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(22);
        }
        String version2 = null;
        if (PyPIPackageCache.getInstance().containsPackage(packageName)) {
            version2 = this.getLatestPackageVersionFromPyPI(project, packageName);
        }
        if (!PyPackageService.getInstance().additionalRepositories.isEmpty() && (extraVersion = this.getLatestPackageVersionFromAdditionalRepositories(project, packageName)) != null) {
            version2 = extraVersion;
        }
        return version2;
    }

    private static String normalizeRepositoryUrl(@NotNull String repositoryUrl) throws IllegalArgumentException {
        Object normalizedRepositoryUrl;
        if (repositoryUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(23);
        }
        Object object = normalizedRepositoryUrl = repositoryUrl.endsWith("/") ? repositoryUrl : repositoryUrl + "/";
        if (!((String)normalizedRepositoryUrl).endsWith(PYPI_SIMPLE_REPOSITORY_API)) {
            throw new IllegalArgumentException("The Repository URL must end with /simple/");
        }
        return normalizedRepositoryUrl;
    }

    @NotNull
    public static String buildPackageUrl(@NotNull String repositoryUrl, @NotNull String packageName) {
        String packageUrl;
        if (repositoryUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(24);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(25);
        }
        String normalizedPackageName = PyPackageNameNormalizeUtilKt.normalizePackageName(packageName);
        String normalizedRepositoryUrl = PyPIPackageUtil.normalizeRepositoryUrl(repositoryUrl);
        String string = packageUrl = normalizedRepositoryUrl + normalizedPackageName + "/";
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    public static String buildProjectUrl(@NotNull String packageName) {
        String projectUrl;
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(27);
        }
        String string = projectUrl = "https://pypi.org/project/" + packageName + "/";
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    public static String buildDetailsUrl(@NotNull String repositoryUrl, @NotNull String packageName) throws IllegalArgumentException {
        String detailsUrl;
        if (repositoryUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(29);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(30);
        }
        String normalizedRepositoryUrl = PyPIPackageUtil.normalizeRepositoryUrl(repositoryUrl);
        String normalizedPackageName = PyPackageNameNormalizeUtilKt.normalizePackageName(packageName);
        String baseUrl = StringUtil.trimEnd((String)normalizedRepositoryUrl, (String)PYPI_SIMPLE_REPOSITORY_API);
        String string = detailsUrl = baseUrl + PYPI_DETAILS_API + normalizedPackageName + "/json";
        if (string == null) {
            PyPIPackageUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static List<String> parsePackageVersionsFromRepository(@NotNull String repositoryUrl, @NotNull String packageName) throws IOException {
        if (repositoryUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(32);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(33);
        }
        String packageUrl = PyPIPackageUtil.buildPackageUrl(repositoryUrl, packageName);
        return PyPIPackageUtil.parsePackageVersionsFromArchives(packageUrl, packageName);
    }

    @Deprecated
    @NotNull
    public static List<String> parsePackageVersionsFromArchives(final @NotNull String archivesUrl, final @NotNull String packageName) throws IOException {
        if (archivesUrl == null) {
            PyPIPackageUtil.$$$reportNull$$$0(34);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(35);
        }
        List list = (List)HttpRequests.request((String)archivesUrl).userAgent(PyPIPackageUtil.getUserAgent()).connect(request -> {
            final ArrayList<String> versions2 = new ArrayList<String>();
            BufferedReader reader = request.getReader();
            new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;

                @Override
                public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int i) {
                    this.myTag = tag;
                }

                @Override
                public void handleText(char @NotNull [] data, int pos) {
                    if (data == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        String artifactName = String.valueOf(data);
                        String version2 = PyPIPackageUtil.extractVersionFromArtifactName(artifactName, packageName);
                        if (version2 != null) {
                            versions2.add(version2);
                        } else {
                            LOG.debug("Could not extract version from " + artifactName + " at " + archivesUrl);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/jetbrains/python/packaging/PyPIPackageUtil$4", "handleText"));
                }
            }, true);
            versions2.sort(PyPackageVersionComparator.getSTR_COMPARATOR().reversed());
            return versions2;
        });
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(36);
        }
        return list;
    }

    @Nullable
    private static String extractVersionFromArtifactName(@NotNull String artifactName, @NotNull String packageName) {
        String suffix;
        if (artifactName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(37);
        }
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(38);
        }
        String withoutExtension = artifactName.endsWith(".tar.gz") ? StringUtil.trimEnd((String)artifactName, (String)".tar.gz") : FileUtilRt.getNameWithoutExtension((String)artifactName);
        String packageNameWithUnderscores = packageName.replace('-', '_');
        if (StringUtil.startsWithIgnoreCase((String)withoutExtension, (String)packageName)) {
            suffix = withoutExtension.substring(packageName.length());
        } else if (StringUtil.startsWithIgnoreCase((String)withoutExtension, (String)packageNameWithUnderscores)) {
            suffix = withoutExtension.substring(packageNameWithUnderscores.length());
        } else {
            return null;
        }
        String version2 = (String)ContainerUtil.getFirstItem((List)StringUtil.split((String)suffix, (String)"-"));
        if (StringUtil.isNotEmpty((String)version2)) {
            return version2;
        }
        return null;
    }

    public void updatePyPICache() throws IOException {
        PyPackageService service = PyPackageService.getInstance();
        if (service.PYPI_REMOVED.booleanValue()) {
            return;
        }
        PyPIPackageCache.reload(PyPIPackageUtil.parsePyPIListFromWeb(PYPI_LIST_URL));
    }

    @NotNull
    public static List<String> parsePyPIListFromWeb(@NotNull String url) throws IOException {
        if (url == null) {
            PyPIPackageUtil.$$$reportNull$$$0(39);
        }
        LOG.info("Fetching index of all packages available on " + url);
        RequestBuilder builder = HttpRequests.request((String)url).userAgent(PyPIPackageUtil.getUserAgent());
        PyPackageRepositories service = (PyPackageRepositories)ApplicationManager.getApplication().getService(PyPackageRepositories.class);
        service.getRepositories().stream().filter(repo -> url.equals(repo.getRepositoryUrl())).findFirst().ifPresent(repository -> PyPackageRepositoryUtil.withBasicAuthorization(builder, repository));
        List list = (List)builder.connect(request -> {
            final ArrayList packages2 = new ArrayList();
            BufferedReader reader = request.getReader();
            new ParserDelegator().parse(reader, new HTMLEditorKit.ParserCallback(){
                HTML.Tag myTag;

                @Override
                public void handleStartTag(@NotNull HTML.Tag tag, @NotNull MutableAttributeSet set, int i) {
                    if (tag == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    if (set == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    this.myTag = tag;
                }

                @Override
                public void handleText(char @NotNull [] data, int pos) {
                    if (data == null) {
                        5.$$$reportNull$$$0(2);
                    }
                    if (this.myTag != null && "a".equals(this.myTag.toString())) {
                        String packageName = String.valueOf(data);
                        if (packageName.endsWith("/")) {
                            packageName = packageName.substring(0, packageName.indexOf("/"));
                        }
                        packages2.add(packageName);
                    }
                }

                @Override
                public void handleEndTag(@NotNull HTML.Tag t, int pos) {
                    if (t == null) {
                        5.$$$reportNull$$$0(3);
                    }
                    this.myTag = null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "tag";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "set";
                            break;
                        }
                        case 2: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "data";
                            break;
                        }
                        case 3: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "t";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil$5";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleStartTag";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleText";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "handleEndTag";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, true);
            return packages2;
        });
        if (list == null) {
            PyPIPackageUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPackages() throws IOException {
        Object object = this.myPyPIPackageCacheUpdateLock;
        synchronized (object) {
            PyPIPackageCache cache = PyPIPackageCache.getInstance();
            if (cache.getPackageNames().isEmpty()) {
                this.updatePyPICache();
            }
        }
    }

    public boolean isInPyPI(@NotNull String packageName) {
        if (packageName == null) {
            PyPIPackageUtil.$$$reportNull$$$0(41);
        }
        if (packageName.isEmpty()) {
            return false;
        }
        return PyPIPackageCache.getInstance().containsPackage(packageName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 27, 29, 30, 32, 33, 34, 35, 37, 38, 39, 41 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 4: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 25: 
            case 27: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 13: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 23: 
            case 24: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryUrl";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "archivesUrl";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserAgent";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPIPackageUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPackages";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageVersionsFromPyPI";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedValueOrRethrowIO";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPackageUrl";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "buildProjectUrl";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDetailsUrl";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageVersionsFromArchives";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePyPIListFromWeb";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalPackages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalPackages";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPackagesFromAdditionalRepository";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillPackageDetails";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndGetPackageDetailsFromPyPI";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "usePackageReleases";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromPyPI";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromPyPI";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersionsFromAdditionalRepositories";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getCachedValueOrRethrowIO";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLatestPackageVersionFromAdditionalRepositories";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestPackageVersion";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "normalizeRepositoryUrl";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "buildPackageUrl";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildProjectUrl";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "buildDetailsUrl";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageVersionsFromRepository";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageVersionsFromArchives";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "extractVersionFromArtifactName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "parsePyPIListFromWeb";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isInPyPI";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 7, 8, 9, 10, 11, 13, 14, 15, 16, 17, 19, 20, 21, 22, 23, 24, 25, 27, 29, 30, 32, 33, 34, 35, 37, 38, 39, 41 -> new IllegalArgumentException(string);
        };
    }

    public static final class PackageDetails {
        @SerializedName(value="info")
        private Info info = new Info();
        @SerializedName(value="releases")
        private Map<String, Object> releases = Collections.emptyMap();

        @NotNull
        public Info getInfo() {
            Info info = this.info;
            if (info == null) {
                PackageDetails.$$$reportNull$$$0(0);
            }
            return info;
        }

        @NotNull
        public List<String> getReleases() {
            List list = EntryStream.of(this.releases).filterValues(PackageDetails::isNotBrokenRelease).keys().toList();
            if (list == null) {
                PackageDetails.$$$reportNull$$$0(1);
            }
            return list;
        }

        private static boolean isNotBrokenRelease(Object o) {
            return !(o instanceof List) || !((List)o).isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReleases";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }

        public static final class Info {
            @SerializedName(value="version")
            private String version = "";
            @SerializedName(value="author")
            private String author = "";
            @SerializedName(value="author_email")
            private String authorEmail = "";
            @SerializedName(value="home_page")
            private String homePage = "";
            @SerializedName(value="summary")
            private String summary = "";
            @SerializedName(value="description")
            private String description = "";
            @SerializedName(value="description_content_type")
            private String descriptionContentType = "";
            @SerializedName(value="project_urls")
            private Map<String, String> projectUrls = Collections.emptyMap();

            @NotNull
            public String getVersion() {
                String string = StringUtil.notNullize((String)this.version);
                if (string == null) {
                    Info.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public String getAuthor() {
                String string = StringUtil.notNullize((String)this.author);
                if (string == null) {
                    Info.$$$reportNull$$$0(1);
                }
                return string;
            }

            @NotNull
            public String getAuthorEmail() {
                String string = StringUtil.notNullize((String)this.authorEmail);
                if (string == null) {
                    Info.$$$reportNull$$$0(2);
                }
                return string;
            }

            @NotNull
            public String getHomePage() {
                String string = StringUtil.notNullize((String)this.homePage);
                if (string == null) {
                    Info.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public String getSummary() {
                String string = StringUtil.notNullize((String)this.summary);
                if (string == null) {
                    Info.$$$reportNull$$$0(4);
                }
                return string;
            }

            @NotNull
            public String getDescription() {
                String string = StringUtil.notNullize((String)this.description);
                if (string == null) {
                    Info.$$$reportNull$$$0(5);
                }
                return string;
            }

            @NotNull
            public String getDescriptionContentType() {
                String string = StringUtil.notNullize((String)this.descriptionContentType);
                if (string == null) {
                    Info.$$$reportNull$$$0(6);
                }
                return string;
            }

            @NotNull
            public Map<String, String> getProjectUrls() {
                Map map2 = ContainerUtil.notNullize(this.projectUrls);
                if (map2 == null) {
                    Info.$$$reportNull$$$0(7);
                }
                return map2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/python/packaging/PyPIPackageUtil$PackageDetails$Info";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVersion";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthor";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAuthorEmail";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getHomePage";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSummary";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescription";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDescriptionContentType";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProjectUrls";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }
    }
}

