/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.python.execution.FailureReason;
import com.jetbrains.python.execution.FailureReasonKt;
import com.jetbrains.python.execution.PyExecutionFailure;
import com.jetbrains.python.execution.PyExecutionFailureKt;
import com.jetbrains.python.packaging.PyExecutionFix;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyExecutionException
extends ExecutionException
implements PyExecutionFailure {
    @NotNull
    private final String myCommand;
    @NotNull
    private final List<String> myArgs;
    @NotNull
    private final List<? extends PyExecutionFix> myFixes;
    private final @NlsContexts.DialogMessage @Nullable String myAdditionalMessage;
    @NotNull
    private final FailureReason myError;

    public PyExecutionException(@NlsContexts.DialogMessage @Nullable String additionalMessage, @NotNull String command, @NotNull List<String> args) {
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(0);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(1);
        }
        this(additionalMessage, command, args, Collections.emptyList());
    }

    public PyExecutionException(@NlsContexts.DialogMessage @Nullable String additionalMessage, @NotNull String command, @NotNull List<String> args, @NotNull List<? extends PyExecutionFix> fixes) {
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(2);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            PyExecutionException.$$$reportNull$$$0(4);
        }
        super(PyExecutionFailureKt.getUserMessage(command, args, additionalMessage, FailureReason.CantStart.INSTANCE));
        this.myAdditionalMessage = additionalMessage;
        this.myCommand = command;
        this.myArgs = args;
        this.myFixes = fixes;
        this.myError = FailureReason.CantStart.INSTANCE;
    }

    public PyExecutionException(@NlsContexts.DialogMessage @Nullable String additionalMessage, @NotNull String command, @NotNull List<String> args, @NotNull ProcessOutput output2) {
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(5);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(6);
        }
        if (output2 == null) {
            PyExecutionException.$$$reportNull$$$0(7);
        }
        this(additionalMessage, command, args, output2, Collections.emptyList());
    }

    public PyExecutionException(@NlsContexts.DialogMessage @Nullable String additionalMessage, @NotNull String command, @NotNull List<String> args, @NotNull ProcessOutput output2, @NotNull List<? extends PyExecutionFix> fixes) {
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(8);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(9);
        }
        if (output2 == null) {
            PyExecutionException.$$$reportNull$$$0(10);
        }
        if (fixes == null) {
            PyExecutionException.$$$reportNull$$$0(11);
        }
        super(PyExecutionFailureKt.getUserMessage(command, args, additionalMessage, new FailureReason.ExecutionFailed(output2)));
        this.myAdditionalMessage = additionalMessage;
        this.myCommand = command;
        this.myArgs = args;
        this.myFixes = fixes;
        this.myError = new FailureReason.ExecutionFailed(output2);
    }

    public PyExecutionException(@NlsContexts.DialogMessage @Nullable String additionalMessage, @NotNull String command, @NotNull List<String> args, @NotNull String stdout, @NotNull String stderr, int exitCode, @NotNull List<? extends PyExecutionFix> fixes) {
        if (command == null) {
            PyExecutionException.$$$reportNull$$$0(12);
        }
        if (args == null) {
            PyExecutionException.$$$reportNull$$$0(13);
        }
        if (stdout == null) {
            PyExecutionException.$$$reportNull$$$0(14);
        }
        if (stderr == null) {
            PyExecutionException.$$$reportNull$$$0(15);
        }
        if (fixes == null) {
            PyExecutionException.$$$reportNull$$$0(16);
        }
        this(additionalMessage, command, args, new ProcessOutput(stdout, stderr, exitCode, false, false), fixes);
    }

    @Override
    @NotNull
    public String getCommand() {
        String string = this.myCommand;
        if (string == null) {
            PyExecutionException.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getArgs() {
        List<String> list = this.myArgs;
        if (list == null) {
            PyExecutionException.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<? extends PyExecutionFix> getFixes() {
        List<? extends PyExecutionFix> list = this.myFixes;
        if (list == null) {
            PyExecutionException.$$$reportNull$$$0(19);
        }
        return list;
    }

    @Override
    @Nullable
    public String getAdditionalMessage() {
        return this.myAdditionalMessage;
    }

    @Override
    @NotNull
    public FailureReason getFailureReason() {
        FailureReason failureReason = this.myError;
        if (failureReason == null) {
            PyExecutionException.$$$reportNull$$$0(20);
        }
        return failureReason;
    }

    @Deprecated(forRemoval=true)
    public int getExitCode() {
        FailureReason failureReason = this.getFailureReason();
        if (failureReason instanceof FailureReason.ExecutionFailed) {
            FailureReason.ExecutionFailed executionFailed = (FailureReason.ExecutionFailed)failureReason;
            return executionFailed.getOutput().getExitCode();
        }
        return -1;
    }

    @ApiStatus.Internal
    @NotNull
    public PyExecutionException copyWith(@NotNull String newCommand, @NotNull @NotNull List<@NotNull String> newArgs) {
        if (newCommand == null) {
            PyExecutionException.$$$reportNull$$$0(21);
        }
        if (newArgs == null) {
            PyExecutionException.$$$reportNull$$$0(22);
        }
        PyExecutionException pyExecutionException = FailureReasonKt.copyWith(this, newCommand, newArgs);
        if (pyExecutionException == null) {
            PyExecutionException.$$$reportNull$$$0(23);
        }
        return pyExecutionException;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 20, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stderr";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyExecutionException";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCommand";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArgs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyExecutionException";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgs";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureReason";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWith";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 23: {
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "copyWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 20, 23 -> new IllegalStateException(string);
        };
    }
}

