/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.codeInsight.intentions.PyConvertImportIntentionAction;
import com.jetbrains.python.extensions.PsiFileSystemItemExtKt;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J!\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0094\u0002\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/codeInsight/intentions/PyRelativeToAbsoluteImportIntention;", "Lcom/jetbrains/python/codeInsight/intentions/PyConvertImportIntentionAction;", "<init>", "()V", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.python.psi.impl"})
public final class PyRelativeToAbsoluteImportIntention
extends PyConvertImportIntentionAction {
    public PyRelativeToAbsoluteImportIntention() {
        super("INTN.convert.relative.to.absolute");
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(context.file() instanceof PyFile)) {
            return null;
        }
        PyFromImportStatement pyFromImportStatement = this.findStatement(element);
        if (pyFromImportStatement == null) {
            return null;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        return statement.getRelativeLevel() > 0 ? super.getPresentation(context, element) : null;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PyFromImportStatement pyFromImportStatement = this.findStatement(element);
        if (pyFromImportStatement == null) {
            return;
        }
        PyFromImportStatement statement = pyFromImportStatement;
        PsiFileSystemItem psiFileSystemItem = statement.resolveImportSource();
        if (psiFileSystemItem == null) {
            return;
        }
        PsiFileSystemItem source = psiFileSystemItem;
        QualifiedName qName = PsiFileSystemItemExtKt.getQName(source);
        PsiFile psiFile = context.file();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"file(...)");
        this.replaceImportStatement(statement, psiFile, String.valueOf(qName));
    }
}

