/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.completion.PyImportableNameCompletionContributor;
import com.jetbrains.python.codeInsight.completion.PyParameterizedTypeInsertHandler;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyCapturePattern;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyExportedModuleAttributeIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFileType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public final class PyClassNameCompletionContributor
extends PyImportableNameCompletionContributor {
    private static final boolean TRACING_WITH_SPUTNIK_ENABLED = false;
    private static final Logger LOG = Logger.getInstance(PyClassNameCompletionContributor.class);
    private static final int NAME_TOO_SHORT_FOR_BASIC_COMPLETION_THRESHOLD = 5;
    private static final boolean RECURSIVE_INDEX_ACCESS_ALLOWED = false;

    @Override
    protected void doFillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        if (parameters == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(1);
        }
        result2.restartCompletionWhenNothingMatches();
        LinkedHashSet remainingResults = result2.runRemainingContributors(parameters, true);
        if (parameters.isExtendedCompletion() || remainingResults.isEmpty() || PyClassNameCompletionContributor.containsOnlyElementUnderTheCaret(remainingResults, parameters)) {
            this.fillCompletionVariantsImpl(parameters, result2);
        }
    }

    private static boolean containsOnlyElementUnderTheCaret(@NotNull Set<CompletionResult> remainingResults, @NotNull CompletionParameters parameters) {
        if (remainingResults == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(2);
        }
        if (parameters == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(3);
        }
        PsiElement position = parameters.getOriginalPosition();
        if (remainingResults.size() == 1 && position != null) {
            CompletionResult lookup = (CompletionResult)ContainerUtil.getFirstItem(remainingResults);
            return lookup.getLookupElement().getLookupString().equals(position.getText());
        }
        return false;
    }

    private void fillCompletionVariantsImpl(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        boolean insideStringLiteralInExtendedCompletion;
        if (parameters == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(5);
        }
        boolean isExtendedCompletion = parameters.isExtendedCompletion();
        if (!PyCodeInsightSettings.getInstance().INCLUDE_IMPORTABLE_NAMES_IN_BASIC_COMPLETION && !isExtendedCompletion) {
            return;
        }
        final PsiFile originalFile = parameters.getOriginalFile();
        PsiElement position = parameters.getPosition();
        PyReferenceExpression refExpr = PyUtil.as(position.getParent(), PyReferenceExpression.class);
        PyTargetExpression targetExpr = PyUtil.as(position.getParent(), PyTargetExpression.class);
        boolean insideUnqualifiedReference = refExpr != null && !refExpr.isQualified();
        boolean insidePattern = targetExpr != null && position.getParent().getParent() instanceof PyCapturePattern;
        boolean bl = insideStringLiteralInExtendedCompletion = position instanceof PyStringElement && isExtendedCompletion;
        if (!(insideUnqualifiedReference || insidePattern || insideStringLiteralInExtendedCompletion)) {
            return;
        }
        if (refExpr != null && (PyClassNameCompletionContributor.isDirectlyInsideClassBody(refExpr) || PyClassNameCompletionContributor.isInsideErrorElement(refExpr))) {
            return;
        }
        PsiPolyVariantReference refUnderCaret = refExpr != null ? refExpr.getReference() : (targetExpr != null ? targetExpr.getReference() : null);
        Set namesInScope = refUnderCaret == null ? Collections.emptySet() : StreamEx.of((Object[])refUnderCaret.getVariants()).select(LookupElement.class).map(LookupElement::getLookupString).toSet();
        Project project = originalFile.getProject();
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion(project, originalFile);
        int maxVariants = Registry.intValue((String)"ide.completion.variant.limit");
        Counters counters = new Counters();
        StubIndex stubIndex = StubIndex.getInstance();
        TimeoutUtil.run(() -> {
            GlobalSearchScope scope = PyClassNameCompletionContributor.createScope(originalFile);
            HashSet alreadySuggested = new HashSet();
            PyClassNameCompletionContributor.forEachPublicNameFromIndex(scope, (Processor<String>)((Processor)elementName -> {
                ProgressManager.checkCanceled();
                ++counters.scannedNames;
                if (elementName.length() < 5 && !isExtendedCompletion) {
                    ++counters.tooShortNames;
                    return true;
                }
                if (!result2.getPrefixMatcher().isStartMatch(elementName)) {
                    return true;
                }
                return stubIndex.processElements(PyExportedModuleAttributeIndex.KEY, elementName, project, scope, PyElement.class, exported -> {
                    ProgressManager.checkCanceled();
                    String name2 = exported.getName();
                    if (name2 == null || namesInScope.contains(name2)) {
                        return true;
                    }
                    QualifiedName fqn = PyClassNameCompletionContributor.getFullyQualifiedName(exported);
                    if (!PyClassNameCompletionContributor.isApplicableInInsertionContext(exported, fqn, position, typeEvalContext)) {
                        ++counters.notApplicableInContextNames;
                        return true;
                    }
                    if (alreadySuggested.add(fqn)) {
                        if (PyClassNameCompletionContributor.isPrivateDefinition(fqn, exported, originalFile)) {
                            ++counters.privateNames;
                            return true;
                        }
                        LookupElementBuilder lookupElement = LookupElementBuilder.createWithSmartPointer((String)name2, (PsiElement)exported).withIcon(exported.getIcon(0)).withExpensiveRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

                            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                                presentation.setItemText(element.getLookupString());
                                presentation.setIcon(exported.getIcon(0));
                                QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)exported, (PsiElement)originalFile);
                                if (importPath == null) {
                                    return;
                                }
                                presentation.setTypeText(importPath.toString());
                            }
                        }).withInsertHandler(this.getInsertHandler((PyElement)exported, position, typeEvalContext));
                        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)-1.0));
                        ++counters.totalVariants;
                        if (counters.totalVariants >= maxVariants) {
                            return false;
                        }
                    }
                    return true;
                });
            }));
        }, duration -> LOG.debug(String.valueOf(counters) + " computed for prefix '" + result2.getPrefixMatcher().getPrefix() + "' in " + duration + " ms"));
    }

    private static void forEachPublicNameFromIndex(@NotNull GlobalSearchScope scope, @NotNull Processor<String> processor2) {
        if (scope == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(7);
        }
        StubIndex stubIndex = StubIndex.getInstance();
        Project project = Objects.requireNonNull(scope.getProject());
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project);
        Collection cachedAllNames = (Collection)manager.getCachedValue((UserDataHolder)project, () -> {
            StubIndex index = StubIndex.getInstance();
            Collection keys = index.getAllKeys(PyExportedModuleAttributeIndex.KEY, project);
            ModificationTracker modificationTracker = index.getPerFileElementTypeModificationTracker((IFileElementType)PyFileElementType.INSTANCE);
            return CachedValueProvider.Result.create((Object)keys, (Object[])new Object[]{modificationTracker});
        });
        for (String allKey : cachedAllNames) {
            if (processor2.process((Object)allKey)) continue;
            return;
        }
    }

    private static boolean isApplicableInInsertionContext(@NotNull PyElement definition, @NotNull QualifiedName fqn, @NotNull PsiElement position, @NotNull TypeEvalContext context) {
        if (definition == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(8);
        }
        if (fqn == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(9);
        }
        if (position == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(11);
        }
        if (PyTypingTypeProvider.isInsideTypeHint(position, context)) {
            return definition instanceof PyClass || definition instanceof PyTypeAliasStatement || ArrayUtil.contains((String)fqn.getFirstComponent(), (String[])new String[]{"typing", "typing_extensions"});
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)position, PyPattern.class, (boolean)false) != null) {
            return definition instanceof PyClass;
        }
        return true;
    }

    private static boolean isInsideErrorElement(@NotNull PyReferenceExpression referenceExpression) {
        if (referenceExpression == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(12);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, PsiErrorElement.class) != null;
    }

    private static boolean isDirectlyInsideClassBody(@NotNull PyReferenceExpression referenceExpression) {
        PyExpressionStatement statement;
        PsiElement psiElement;
        if (referenceExpression == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(13);
        }
        return (psiElement = referenceExpression.getParent()) instanceof PyExpressionStatement && ScopeUtil.getScopeOwner((PsiElement)(statement = (PyExpressionStatement)psiElement)) instanceof PyClass;
    }

    @NotNull
    private static QualifiedName getFullyQualifiedName(@NotNull PyElement exported) {
        String string;
        if (exported == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(14);
        }
        String shortName = StringUtil.notNullize((String)exported.getName());
        if (exported instanceof PyQualifiedNameOwner) {
            PyQualifiedNameOwner qNameOwner = (PyQualifiedNameOwner)exported;
            string = qNameOwner.getQualifiedName();
        } else {
            string = null;
        }
        String qualifiedName = string;
        QualifiedName qualifiedName2 = QualifiedName.fromDottedString((String)(qualifiedName != null ? qualifiedName : shortName));
        if (qualifiedName2 == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(15);
        }
        return qualifiedName2;
    }

    private static boolean isPrivateDefinition(@NotNull QualifiedName fqn, @NotNull PyElement exported, PsiFile originalFile) {
        if (fqn == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(16);
        }
        if (exported == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(17);
        }
        if (PyClassNameCompletionContributor.containsPrivateComponents(fqn)) {
            QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)exported, (PsiElement)originalFile);
            return importPath != null && PyClassNameCompletionContributor.containsPrivateComponents(importPath);
        }
        return false;
    }

    private static boolean containsPrivateComponents(@NotNull QualifiedName fqn) {
        if (fqn == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(18);
        }
        return ContainerUtil.exists((Iterable)fqn.getComponents(), c -> c.startsWith("_"));
    }

    @NotNull
    private static GlobalSearchScope createScope(@NotNull PsiFile originalFile) {
        if (originalFile == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(19);
        }
        Project project = originalFile.getProject();
        GlobalSearchScope pyiStubsScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.everythingScope((Project)project), (FileType[])new FileType[]{PyiFileType.INSTANCE});
        class HavingLegalImportPathScope
        extends QualifiedNameFinder.QualifiedNameBasedScope {
            private HavingLegalImportPathScope(@NotNull Project project) {
                if (project == null) {
                    HavingLegalImportPathScope.$$$reportNull$$$0(0);
                }
                super(project);
            }

            @Override
            protected boolean containsQualifiedNameInRoot(@NotNull VirtualFile root, @NotNull QualifiedName qName) {
                if (root == null) {
                    HavingLegalImportPathScope.$$$reportNull$$$0(1);
                }
                if (qName == null) {
                    HavingLegalImportPathScope.$$$reportNull$$$0(2);
                }
                return ContainerUtil.all((Collection)qName.getComponents(), PyNames::isIdentifier) && !qName.equals((Object)QualifiedName.fromComponents((String[])new String[]{"__future__"}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "root";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "qName";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$1HavingLegalImportPathScope";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "containsQualifiedNameInRoot";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
        GlobalSearchScope globalSearchScope = PySearchUtilBase.defaultSuggestionScope((PsiElement)originalFile).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)pyiStubsScope)).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)originalFile))).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)PyClassNameCompletionContributor.fileScope("typing", originalFile, false))).uniteWith(PyClassNameCompletionContributor.fileScope("typing", originalFile, true)).intersectWith((GlobalSearchScope)new HavingLegalImportPathScope(project));
        if (globalSearchScope == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(20);
        }
        return globalSearchScope;
    }

    @NotNull
    private static GlobalSearchScope fileScope(@NotNull String fqn, @NotNull PsiFile anchor, boolean pyiStub) {
        if (fqn == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(21);
        }
        if (anchor == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(22);
        }
        PyQualifiedNameResolveContext context = pyiStub ? PyResolveImportUtil.fromFoothold((PsiElement)anchor) : PyResolveImportUtil.fromFoothold((PsiElement)anchor).copyWithoutStubs();
        List files = ContainerUtil.filterIsInstance(PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromDottedString((String)fqn), context), PsiFile.class);
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            if (globalSearchScope == null) {
                PyClassNameCompletionContributor.$$$reportNull$$$0(23);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)anchor.getProject(), (Collection)ContainerUtil.map((Collection)files, PsiFile::getVirtualFile));
        if (globalSearchScope == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(24);
        }
        return globalSearchScope;
    }

    @NotNull
    private InsertHandler<LookupElement> getInsertHandler(@NotNull PyElement exported, @NotNull PsiElement position, @NotNull TypeEvalContext typeEvalContext) {
        if (exported == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(25);
        }
        if (position == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(26);
        }
        if (typeEvalContext == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(27);
        }
        if (position.getParent() instanceof PyStringLiteralExpression) {
            InsertHandler<LookupElement> insertHandler = this.getStringLiteralInsertHandler();
            if (insertHandler == null) {
                PyClassNameCompletionContributor.$$$reportNull$$$0(28);
            }
            return insertHandler;
        }
        if (PyParameterizedTypeInsertHandler.isCompletingParameterizedType((PsiElement)exported, position, typeEvalContext)) {
            InsertHandler<LookupElement> insertHandler = this.getGenericTypeInsertHandler();
            if (insertHandler == null) {
                PyClassNameCompletionContributor.$$$reportNull$$$0(29);
            }
            return insertHandler;
        }
        if (exported instanceof PyFunction && !(position.getParent().getParent() instanceof PyDecorator)) {
            InsertHandler<LookupElement> insertHandler = this.getFunctionInsertHandler();
            if (insertHandler == null) {
                PyClassNameCompletionContributor.$$$reportNull$$$0(30);
            }
            return insertHandler;
        }
        InsertHandler<LookupElement> insertHandler = this.getImportingInsertHandler();
        if (insertHandler == null) {
            PyClassNameCompletionContributor.$$$reportNull$$$0(31);
        }
        return insertHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 20, 23, 24, 28, 29, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remainingResults";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 9: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 14: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exported";
                break;
            }
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvalContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullyQualifiedName";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createScope";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "fileScope";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doFillCompletionVariants";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "containsOnlyElementUnderTheCaret";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fillCompletionVariantsImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forEachPublicNameFromIndex";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableInInsertionContext";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isInsideErrorElement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyInsideClassBody";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getFullyQualifiedName";
                break;
            }
            case 15: 
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isPrivateDefinition";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsPrivateComponents";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createScope";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "fileScope";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getInsertHandler";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 20, 23, 24, 28, 29, 30, 31 -> new IllegalStateException(string);
        };
    }

    private static class Counters {
        int scannedNames;
        int privateNames;
        int tooShortNames;
        int notApplicableInContextNames;
        int totalVariants;

        private Counters() {
        }

        public String toString() {
            return "Counters{scannedNames=" + this.scannedNames + ", privateNames=" + this.privateNames + ", tooShortNames=" + this.tooShortNames + ", notApplicableInContextNames=" + this.notApplicableInContextNames + ", totalVariants=" + this.totalVariants + "}";
        }
    }
}

