/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import com.google.common.collect.ObjectArrays;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.StringMatcher;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class PatternToken
implements Cloneable {
    public static final String UNKNOWN_TAG = "UNKNOWN";
    private static final PatternToken[] EMPTY_ARRAY = new PatternToken[0];
    private static final int INFLECTED_MASK = 1;
    private static final int NEGATION_MASK = 2;
    private static final int TEST_WHITESPACE_MASK = 4;
    private static final int WHITESPACE_BEFORE_MASK = 8;
    private static final int INSIDE_MARKER_MASK = 16;
    private static final int EXCEPTION_VALID_NEXT_MASK = 32;
    private static final int MAY_BE_OMITTED_MASK = 64;
    private static final int TEST_STRING_MASK = 128;
    private static final int UNIFICATION_NEUTRAL_MASK = 256;
    private static final int UNI_NEGATION_MASK = 512;
    private static final int LAST_UNIFIED_MASK = 1024;
    private short flags;
    private StringMatcher textMatcher;
    private PosToken posToken;
    private RareFields rareFields;
    private byte skip;
    private byte maxOccurrence = 1;

    public PatternToken(String token, boolean caseSensitive, boolean regExp, boolean inflected) {
        this(inflected, StringMatcher.create(PatternToken.normalizeTextPattern(token), regExp, caseSensitive));
    }

    PatternToken(boolean inflected, @NotNull StringMatcher textMatcher) {
        this.flags = (short)(0x10 | (inflected ? 1 : 0));
        this.setTextMatcher(textMatcher);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isMatched(AnalyzedToken token) {
        boolean posNegation;
        if (this.hasFlag(4) && !this.isWhitespaceBefore(token)) {
            return false;
        }
        boolean bl = posNegation = this.posToken != null && this.posToken.negation;
        if (this.hasFlag(128)) {
            return this.textMatcher.matches(this.getTestToken(token)) ^ this.getNegation() && this.isPosTokenMatched(token) ^ posNegation;
        }
        return !this.getNegation() && this.isPosTokenMatched(token) ^ posNegation;
    }

    boolean hasFlag(int mask) {
        return (this.flags & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        this.flags = value ? (short)(this.flags | mask) : (short)(this.flags & ~mask);
    }

    public boolean isExceptionMatched(AnalyzedToken token) {
        if (this.rareFields != null && this.rareFields.currentAndNextExceptions.length > 0) {
            for (PatternToken testException : this.rareFields.currentAndNextExceptions) {
                if (testException.hasNextException() || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAndExceptionGroupMatched(AnalyzedToken token) {
        List andGroupList;
        List list = andGroupList = this.rareFields == null ? null : this.rareFields.andGroupList;
        if (andGroupList == null) {
            return false;
        }
        for (PatternToken testAndGroup : andGroupList) {
            if (!testAndGroup.isExceptionMatched(token)) continue;
            return true;
        }
        return false;
    }

    public boolean isExceptionMatchedCompletely(AnalyzedToken token) {
        return this.isExceptionMatched(token) || this.isAndExceptionGroupMatched(token);
    }

    public void setAndGroupElement(PatternToken andToken) {
        RareFields rareFields = this.initRareFields();
        if (rareFields.andGroupList == null) {
            rareFields.andGroupList = new ArrayList();
        }
        rareFields.andGroupList.add(Objects.requireNonNull(andToken));
    }

    public boolean hasAndGroup() {
        return this.rareFields != null && this.rareFields.andGroupList != null;
    }

    public List<PatternToken> getAndGroup() {
        List andGroupList = this.rareFields == null ? null : this.rareFields.andGroupList;
        return andGroupList == null ? Collections.emptyList() : Collections.unmodifiableList(andGroupList);
    }

    public void setOrGroupElement(PatternToken orToken) {
        RareFields rareFields = this.initRareFields();
        if (rareFields.orGroupList == null) {
            rareFields.orGroupList = new ArrayList();
        }
        rareFields.orGroupList.add(Objects.requireNonNull(orToken));
    }

    public boolean hasOrGroup() {
        return this.rareFields != null && this.rareFields.orGroupList != null;
    }

    public List<PatternToken> getOrGroup() {
        List orGroupList = this.rareFields == null ? null : this.rareFields.orGroupList;
        return orGroupList == null ? Collections.emptyList() : Collections.unmodifiableList(orGroupList);
    }

    public boolean isMatchedByScopeNextException(AnalyzedToken token) {
        if (this.rareFields != null) {
            for (PatternToken testException : this.rareFields.currentAndNextExceptions) {
                if (!testException.hasNextException() || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchedByPreviousException(AnalyzedToken token) {
        if (this.hasPreviousException()) {
            for (PatternToken testException : this.rareFields.previousExceptions) {
                if (testException.hasNextException() || !testException.isMatched(token)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isMatchedByPreviousException(AnalyzedTokenReadings prevToken) {
        for (AnalyzedToken analyzedToken : prevToken) {
            if (!this.isMatchedByPreviousException(analyzedToken)) continue;
            return true;
        }
        return false;
    }

    public boolean isSentenceStart() {
        return this.posToken != null && "SENT_START".equals(this.posToken.posTag) && !this.posToken.negation;
    }

    public void setPosToken(PosToken posToken) {
        this.posToken = posToken;
    }

    public void setChunkTag(ChunkTag chunkTag) {
        this.initRareFields().chunkTag = chunkTag;
    }

    public String getString() {
        return this.textMatcher.pattern;
    }

    public void setStringElement(String token) {
        this.setTextMatcher(StringMatcher.create(PatternToken.normalizeTextPattern(token), this.isRegularExpression(), this.isCaseSensitive()));
    }

    void setTextMatcher(@NotNull StringMatcher matcher) {
        this.textMatcher = matcher;
        this.setFlag(128, !StringTools.isEmpty(matcher.pattern));
    }

    static String normalizeTextPattern(String token) {
        return token == null ? "" : StringTools.trimWhitespace(token);
    }

    public void setStringPosException(String token, boolean regExp, boolean inflected, boolean negation, boolean scopeNext, boolean scopePrevious, String posToken, boolean posRegExp, boolean posNegation, Boolean caseSensitivity) {
        PatternToken exception = new PatternToken(token, caseSensitivity == null ? this.isCaseSensitive() : caseSensitivity.booleanValue(), regExp, inflected);
        exception.setNegation(negation);
        exception.setPosToken(new PosToken(posToken, posRegExp, posNegation));
        this.addException(scopeNext, scopePrevious, exception);
    }

    void addException(boolean scopeNext, boolean scopePrevious, PatternToken exception) {
        exception.setFlag(32, scopeNext);
        this.initRareFields().addException(exception, scopePrevious);
    }

    @NotNull
    private RareFields initRareFields() {
        if (this.rareFields == null) {
            this.rareFields = new RareFields();
        }
        return this.rareFields;
    }

    private boolean isPosTokenMatched(AnalyzedToken token) {
        PosToken pos = this.posToken;
        if (pos == null || pos.posTag == null || pos.posUnknown && token.hasNoTag()) {
            return true;
        }
        String tokenPos = token.getPOSTag();
        if (tokenPos == null) {
            return false;
        }
        return pos.posPattern != null ? pos.posPattern.matches(tokenPos) : pos.posTag.equals(tokenPos);
    }

    private String getTestToken(AnalyzedToken token) {
        if (this.hasFlag(1)) {
            if (token.getLemma() != null) {
                return token.getLemma();
            }
            return token.getToken();
        }
        return token.getToken();
    }

    public int getSkipNext() {
        return this.skip;
    }

    public int getMinOccurrence() {
        return this.hasFlag(64) ? 0 : 1;
    }

    public int getMaxOccurrence() {
        return this.maxOccurrence;
    }

    public void setSkipNext(int i) {
        if (i < -1 || i > 127) {
            throw new IllegalArgumentException("'skip' should be between -1 and 127");
        }
        this.skip = (byte)i;
    }

    public void setMinOccurrence(int i) {
        if (i != 0 && i != 1) {
            throw new IllegalArgumentException("minOccurrences must be 0 or 1: " + i);
        }
        this.setFlag(64, i == 0);
    }

    public void setMaxOccurrence(int i) {
        if (i == 0) {
            throw new IllegalArgumentException("maxOccurrences may not be 0");
        }
        if (i < -1 || i > 127) {
            throw new IllegalArgumentException("maxOccurrences should be between -1 and 127 but was: " + i);
        }
        this.maxOccurrence = (byte)i;
    }

    public boolean hasPreviousException() {
        return this.rareFields != null && this.rareFields.previousExceptions.length > 0;
    }

    public boolean hasNextException() {
        return this.hasFlag(32);
    }

    public void setNegation(boolean negation) {
        this.setFlag(2, negation);
    }

    public boolean getNegation() {
        return this.hasFlag(2);
    }

    public boolean isReferenceElement() {
        return this.getMatch() != null;
    }

    public void setMatch(Match match) {
        this.initRareFields().tokenReference = Objects.requireNonNull(match);
    }

    public Match getMatch() {
        return this.rareFields == null ? null : this.rareFields.tokenReference;
    }

    public PatternToken compile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        PatternToken compiledPatternToken;
        try {
            compiledPatternToken = (PatternToken)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Could not clone element", e);
        }
        compiledPatternToken.doCompile(token, synth);
        return compiledPatternToken;
    }

    private void doCompile(AnalyzedTokenReadings token, Synthesizer synth) throws IOException {
        Match tokenReference = this.rareFields.tokenReference;
        MatchState matchState = tokenReference.createState(synth, token);
        String reference = "\\" + tokenReference.getTokenRef();
        if (tokenReference.setsPos()) {
            String posReference = matchState.getTargetPosTag();
            if (posReference != null) {
                this.setPosToken(new PosToken(posReference, tokenReference.posRegExp(), this.getNegation()));
            }
            this.setStringElement(this.getString().replace(reference, ""));
        } else {
            this.setStringElement(this.getString().replace(reference, matchState.toTokenString()));
        }
    }

    public void setPhraseName(String id) {
        this.initRareFields().phraseName = id;
    }

    public boolean isPartOfPhrase() {
        return this.rareFields != null && this.rareFields.phraseName != null;
    }

    public boolean isCaseSensitive() {
        return this.textMatcher.caseSensitive;
    }

    public boolean isRegularExpression() {
        return this.textMatcher.isRegExp;
    }

    public boolean isPOStagRegularExpression() {
        return this.posToken != null && this.posToken.posPattern != null;
    }

    @Nullable
    public String getPOStag() {
        return this.posToken != null ? this.posToken.posTag : null;
    }

    @Nullable
    public ChunkTag getChunkTag() {
        return this.rareFields == null ? null : this.rareFields.chunkTag;
    }

    public boolean getPOSNegation() {
        return this.posToken != null && this.posToken.negation;
    }

    public boolean isInflected() {
        return this.hasFlag(1);
    }

    @Nullable
    public String getPhraseName() {
        return this.rareFields == null ? null : this.rareFields.phraseName;
    }

    public boolean isUnified() {
        return this.rareFields != null && this.rareFields.unificationFeatures != null;
    }

    public void setUnification(Map<String, List<String>> uniFeatures) {
        this.initRareFields().unificationFeatures = Objects.requireNonNull(uniFeatures);
    }

    @Nullable
    public Map<String, List<String>> getUniFeatures() {
        return this.rareFields == null ? null : this.rareFields.unificationFeatures;
    }

    public void setUniNegation() {
        this.setFlag(512, true);
    }

    public boolean isUniNegated() {
        return this.hasFlag(512);
    }

    public boolean isLastInUnification() {
        return this.hasFlag(1024);
    }

    public void setLastInUnification() {
        this.setFlag(1024, true);
    }

    public boolean isUnificationNeutral() {
        return this.hasFlag(256);
    }

    public void setUnificationNeutral() {
        this.setFlag(256, true);
    }

    public void setWhitespaceBefore(boolean isWhite) {
        this.setFlag(8, isWhite);
        this.setFlag(4, true);
    }

    public boolean isInsideMarker() {
        return this.hasFlag(16);
    }

    public void setInsideMarker(boolean isInsideMarker) {
        this.setFlag(16, isInsideMarker);
    }

    public void setExceptionSpaceBefore(boolean isWhite) {
        if (this.rareFields != null) {
            PatternToken[] array;
            PatternToken[] patternTokenArray = array = this.hasPreviousException() ? this.rareFields.previousExceptions : this.rareFields.currentAndNextExceptions;
            if (array.length > 0) {
                array[array.length - 1].setWhitespaceBefore(isWhite);
            }
        }
    }

    public boolean isWhitespaceBefore(AnalyzedToken token) {
        return this.hasFlag(8) == token.isWhitespaceBefore();
    }

    @NotNull
    public List<PatternToken> getExceptionList() {
        PatternToken[] array = this.rareFields == null ? EMPTY_ARRAY : this.rareFields.currentAndNextExceptions;
        return array.length == 0 ? Collections.emptyList() : Arrays.asList(array);
    }

    @ApiStatus.Internal
    public boolean hasCurrentOrNextExceptions() {
        return this.rareFields != null && this.rareFields.currentAndNextExceptions.length > 0;
    }

    public boolean hasExceptionList() {
        return this.rareFields != null && (this.rareFields.currentAndNextExceptions.length > 0 || this.rareFields.previousExceptions.length > 0);
    }

    @Nullable
    Set<String> calcFormHints() {
        return this.calcStringHints(false);
    }

    @Nullable
    Set<String> calcLemmaHints() {
        return this.calcStringHints(true);
    }

    private Set<String> calcStringHints(boolean inflected) {
        Set<String> result2;
        block5: {
            List orGroupList;
            block4: {
                Set<String> set = result2 = inflected != this.isInflected() ? null : this.calcOwnPossibleStringValues();
                if (result2 == null) {
                    return null;
                }
                List andGroupList = this.rareFields == null ? null : this.rareFields.andGroupList;
                List list = orGroupList = this.rareFields == null ? null : this.rareFields.orGroupList;
                if (andGroupList == null) break block4;
                result2 = new HashSet<String>(result2);
                for (PatternToken token : andGroupList) {
                    Set<String> hints = token.calcStringHints(inflected);
                    if (hints == null) continue;
                    result2.retainAll(hints);
                }
                break block5;
            }
            if (orGroupList == null) break block5;
            result2 = new HashSet<String>(result2);
            for (PatternToken token : orGroupList) {
                Set<String> hints = token.calcStringHints(inflected);
                if (hints == null) {
                    return null;
                }
                result2.addAll(hints);
            }
        }
        return result2.isEmpty() ? null : result2;
    }

    @Nullable
    private Set<String> calcOwnPossibleStringValues() {
        if (this.getNegation() || !this.hasStringThatMustMatch()) {
            return null;
        }
        return this.textMatcher.getPossibleValues();
    }

    boolean hasStringThatMustMatch() {
        return !this.isReferenceElement() && !this.hasFlag(64) && !this.getString().isEmpty();
    }

    public String toString() {
        List<PatternToken> exceptionList;
        ChunkTag chunkTag;
        StringBuilder sb = new StringBuilder();
        if (this.getNegation()) {
            sb.append('!');
        }
        sb.append(this.getString());
        String phraseName = this.getPhraseName();
        if (phraseName != null) {
            sb.append(" {");
            sb.append(phraseName);
            sb.append('}');
        }
        if (this.posToken != null) {
            sb.append('/');
            sb.append(this.posToken);
        }
        if ((chunkTag = this.getChunkTag()) != null) {
            sb.append('/');
            sb.append(chunkTag);
        }
        if (!(exceptionList = this.getExceptionList()).isEmpty()) {
            sb.append("/exceptions=");
            sb.append(exceptionList);
        }
        return sb.toString();
    }

    static /* synthetic */ PatternToken[] access$1400() {
        return EMPTY_ARRAY;
    }

    public static class PosToken {
        private final String posTag;
        private final boolean negation;
        private final StringMatcher posPattern;
        private final boolean posUnknown;

        public PosToken(String posTag, boolean regExp, boolean negation) {
            this(posTag, negation, regExp ? StringMatcher.regexp(posTag) : null);
        }

        PosToken(String posTag, boolean negation, StringMatcher matcher) {
            this.posTag = posTag;
            this.negation = negation;
            this.posPattern = matcher;
            this.posUnknown = this.posPattern != null ? this.posPattern.matches(PatternToken.UNKNOWN_TAG) : PatternToken.UNKNOWN_TAG.equals(posTag);
        }

        public String toString() {
            return this.posTag;
        }
    }

    private static class RareFields {
        @NotNull
        private PatternToken[] currentAndNextExceptions = PatternToken.access$1400();
        @NotNull
        private PatternToken[] previousExceptions = PatternToken.access$1400();
        private Map<String, List<String>> unificationFeatures;
        private String phraseName;
        private List<PatternToken> andGroupList;
        private List<PatternToken> orGroupList;
        private Match tokenReference;
        private ChunkTag chunkTag;

        private RareFields() {
        }

        private void addException(PatternToken pToken, boolean scopePrevious) {
            if (scopePrevious) {
                this.previousExceptions = (PatternToken[])ObjectArrays.concat((Object[])this.previousExceptions, (Object)pToken);
            } else {
                this.currentAndNextExceptions = (PatternToken[])ObjectArrays.concat((Object[])this.currentAndNextExceptions, (Object)pToken);
            }
        }
    }
}

