/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.languagetool.language.English;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.tools.Tools;

public class EnglishDiacriticsRule
extends AbstractSimpleReplaceRule2 {
    public static final String EN_DIACRITICS_REPLACE = "EN_DIACRITICS_REPLACE_ORTHOGRAPHY";
    private static final String FILE_NAME = "/en/diacritics.txt";
    private static final Locale EN_LOCALE = new Locale("en");

    @Override
    public final List<String> getFileNames() {
        return Collections.singletonList(FILE_NAME);
    }

    public EnglishDiacriticsRule(ResourceBundle messages) throws IOException {
        super(messages, new English());
        this.useSubRuleSpecificIds();
        this.setCategory(Categories.TYPOS.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        this.addExamplePair(Example.wrong("<marker>blase</marker>"), Example.fixed("<marker>blas\u00e9</marker>"));
    }

    @Override
    public final String getId() {
        return EN_DIACRITICS_REPLACE;
    }

    @Override
    public String getDescription() {
        return "Suggest diacritics for '$match'";
    }

    @Override
    public String getShort() {
        return "The original word has a diacritic";
    }

    @Override
    public String getMessage() {
        return "'$match' is an imported foreign name or expression, which originally has a diacritic.";
    }

    @Override
    public String getSuggestionsSeparator() {
        return " or ";
    }

    @Override
    public URL getUrl() {
        return Tools.getUrl("https://en.wikipedia.org/wiki/English_terms_with_diacritical_marks");
    }

    @Override
    public Locale getLocale() {
        return EN_LOCALE;
    }
}

