/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.rules.AbstractSimpleReplaceRule2;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Example;
import org.languagetool.rules.ITSIssueType;

public class AmericanReplaceRule
extends AbstractSimpleReplaceRule2 {
    public static final String AMERICAN_SIMPLE_REPLACE_RULE = "EN_US_SIMPLE_REPLACE";
    private static final Locale EN_US_LOCALE = new Locale("en-US");
    private final String path;

    @Override
    public List<String> getFileNames() {
        return Collections.singletonList(this.path);
    }

    public AmericanReplaceRule(ResourceBundle messages, String path) {
        super(messages, new AmericanEnglish());
        this.path = Objects.requireNonNull(path);
        this.useSubRuleSpecificIds();
        this.setCategory(Categories.STYLE.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.LocaleViolation);
        this.addExamplePair(Example.wrong("Are baked <marker>crisps</marker> healthy?"), Example.fixed("Are baked <marker>chips</marker> healthy?"));
    }

    @Override
    public final String getId() {
        return AMERICAN_SIMPLE_REPLACE_RULE;
    }

    @Override
    public String getDescription() {
        return "British words easily confused in American English: $match";
    }

    @Override
    public String getShort() {
        return "British word";
    }

    @Override
    public String getMessage() {
        return "'$match' is a common British expression. Consider using expressions more common to American English.";
    }

    @Override
    public Locale getLocale() {
        return EN_US_LOCALE;
    }
}

