/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.grammar;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.inspection.grammar.GrazieInspection;
import com.intellij.grazie.text.CheckerRunner;
import com.intellij.grazie.text.TextChecker;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.text.TextProblem;
import com.intellij.lang.Language;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spellchecker.ui.SpellCheckingEditorCustomization;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u00012\u00020\u0002:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getDisplayName", "", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "intellij.grazie.core"})
public final class GrazieInspection
extends LocalInspectionTool
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_TEXT_LENGTH_IN_PSI_ELEMENT = 50000;
    private static final int MAX_TEXT_LENGTH_IN_FILE = 200000;
    @NotNull
    private static final Lazy<Boolean> hasSpellChecking$delegate = LazyKt.lazy(GrazieInspection::hasSpellChecking_delegate$lambda$0);

    @NotNull
    public String getDisplayName() {
        return GrazieBundle.message("grazie.grammar.inspection.grammar.text", new Object[0]);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        PsiFile psiFile = holder.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (Companion.ignoreGrammarChecking(file) || InspectionProfileManager.hasTooLowSeverity((LocalInspectionToolSession)session, (LocalInspectionTool)this)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        List<TextChecker> checkers = TextChecker.allCheckers();
        Set<TextContent.TextDomain> checkedDomains = Companion.checkedDomains();
        Function1<PsiElement, Boolean> areChecksDisabled = Companion.getDisabledChecker(file);
        return new PsiElementVisitor(areChecksDisabled, checkedDomains, session, checkers, isOnTheFly, holder){
            final /* synthetic */ Function1<PsiElement, Boolean> $areChecksDisabled;
            final /* synthetic */ Set<TextContent.TextDomain> $checkedDomains;
            final /* synthetic */ LocalInspectionToolSession $session;
            final /* synthetic */ List<TextChecker> $checkers;
            final /* synthetic */ boolean $isOnTheFly;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$areChecksDisabled = $areChecksDisabled;
                this.$checkedDomains = $checkedDomains;
                this.$session = $session;
                this.$checkers = $checkers;
                this.$isOnTheFly = $isOnTheFly;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof PsiWhiteSpace || ((Boolean)this.$areChecksDisabled.invoke((Object)element)).booleanValue()) {
                    return;
                }
                List<TextContent> list = TextExtractor.findUniqueTextsAt(element, this.$checkedDomains);
                Intrinsics.checkNotNullExpressionValue(list, (String)"findUniqueTextsAt(...)");
                List<TextContent> texts = list;
                if (GrazieInspection.Companion.skipCheckingTooLargeTexts(texts)) {
                    return;
                }
                TextRange textRange = this.$session.getPriorityRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getPriorityRange(...)");
                for (TextContent extracted : GrazieInspection.Companion.sortByPriority(texts, textRange)) {
                    CheckerRunner runner = new CheckerRunner(extracted);
                    List<TextChecker> list2 = this.$checkers;
                    Intrinsics.checkNotNull(list2);
                    runner.run(list2, (Function1<? super TextProblem, Unit>)((Function1)arg_0 -> buildVisitor.1.visitElement$lambda$0(runner, this.$isOnTheFly, this.$holder, arg_0)));
                }
            }

            private static final Unit visitElement$lambda$0(CheckerRunner $runner, boolean $isOnTheFly, ProblemsHolder $holder, TextProblem problem) {
                Intrinsics.checkNotNullParameter((Object)problem, (String)"problem");
                Iterable $this$forEach$iv = $runner.toProblemDescriptors(problem, $isOnTheFly);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ProblemDescriptor p0 = (ProblemDescriptor)element$iv;
                    boolean bl = false;
                    $holder.registerProblem(p0);
                }
                return Unit.INSTANCE;
            }
        };
    }

    private static final boolean hasSpellChecking_delegate$lambda$0() {
        boolean bl;
        try {
            Class.forName("com.intellij.spellchecker.ui.SpellCheckingEditorCustomization");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent> findAllTextContents(@NotNull FileViewProvider vp, @NotNull Set<? extends TextContent.TextDomain> domains) {
        return Companion.findAllTextContents(vp, domains);
    }

    @JvmStatic
    public static final boolean skipCheckingTooLargeTexts(@NotNull List<? extends TextContent> texts) {
        return Companion.skipCheckingTooLargeTexts(texts);
    }

    @JvmStatic
    public static final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
        return Companion.ignoreGrammarChecking(file);
    }

    @JvmStatic
    @NotNull
    public static final Set<TextContent.TextDomain> checkedDomains() {
        return Companion.checkedDomains();
    }

    @JvmStatic
    @NotNull
    public static final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
        return Companion.getDisabledChecker(file);
    }

    @JvmStatic
    @NotNull
    public static final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
        return Companion.sortByPriority(texts, priorityRange);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0007J\u0016\u0010\u0014\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u000eH\u0007J\u001c\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J$\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010 \u001a\u00020!H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Lcom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion;", "", "<init>", "()V", "MAX_TEXT_LENGTH_IN_PSI_ELEMENT", "", "MAX_TEXT_LENGTH_IN_FILE", "hasSpellChecking", "", "getHasSpellChecking", "()Z", "hasSpellChecking$delegate", "Lkotlin/Lazy;", "findAllTextContents", "", "Lcom/intellij/grazie/text/TextContent;", "vp", "Lcom/intellij/psi/FileViewProvider;", "domains", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "skipCheckingTooLargeTexts", "texts", "", "ignoreGrammarChecking", "file", "Lcom/intellij/psi/PsiFile;", "isSpellCheckingDisabled", "checkedDomains", "getDisabledChecker", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "sortByPriority", "priorityRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1#2:150\n1053#3:151\n*S KotlinDebug\n*F\n+ 1 GrazieInspection.kt\ncom/intellij/grazie/ide/inspection/grammar/GrazieInspection$Companion\n*L\n138#1:151\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getHasSpellChecking() {
            Lazy lazy = hasSpellChecking$delegate;
            return (Boolean)lazy.getValue();
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent> findAllTextContents(@NotNull FileViewProvider vp, @NotNull Set<? extends TextContent.TextDomain> domains) {
            Intrinsics.checkNotNullParameter((Object)vp, (String)"vp");
            Intrinsics.checkNotNullParameter(domains, (String)"domains");
            Set allContents = new HashSet();
            for (Object e : vp.getAllFiles()) {
                Iterator iterator;
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                PsiFile root = (PsiFile)e;
                Intrinsics.checkNotNullExpressionValue((Object)SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)root)).iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    PsiElement element = (PsiElement)iterator.next();
                    if (element.getFirstChild() != null) continue;
                    List<TextContent> list = TextExtractor.findTextsAt(element, domains);
                    Intrinsics.checkNotNullExpressionValue(list, (String)"findTextsAt(...)");
                    allContents.addAll((Collection)list);
                }
            }
            return allContents;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final boolean skipCheckingTooLargeTexts(@NotNull List<? extends TextContent> texts) {
            int n;
            int n2;
            Object object2;
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            if (texts.isEmpty()) {
                return false;
            }
            Iterable iterable = texts;
            int n3 = 0;
            for (Object object2 : iterable) {
                void it;
                TextContent textContent = (TextContent)object2;
                n2 = n3;
                boolean bl = false;
                n = it.length();
                n3 = n2 + n;
            }
            if (n3 > 50000) {
                return true;
            }
            PsiFile psiFile = texts.get(0).getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            PsiFile file = psiFile;
            if (file.getTextLength() <= 200000) {
                return false;
            }
            Set allInFile = (Set)CachedValuesManager.getProjectPsiDependentCache((PsiElement)((PsiElement)file), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$2(Companion::skipCheckingTooLargeTexts$lambda$1, arg_0));
            Set<TextContent.TextDomain> checkedDomains = this.checkedDomains();
            Intrinsics.checkNotNull((Object)allInFile);
            object2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allInFile), arg_0 -> Companion.skipCheckingTooLargeTexts$lambda$3(checkedDomains, arg_0));
            int n4 = 0;
            for (Object e : object2) {
                void it;
                TextContent textContent = (TextContent)e;
                n2 = n4;
                boolean bl = false;
                n = it.length();
                n4 = n2 + n;
            }
            return n4 > 200000;
        }

        @JvmStatic
        public final boolean ignoreGrammarChecking(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.getHasSpellChecking() && this.isSpellCheckingDisabled(file);
        }

        private final boolean isSpellCheckingDisabled(PsiFile file) {
            return SpellCheckingEditorCustomization.isSpellCheckingDisabled((PsiFile)file);
        }

        @JvmStatic
        @NotNull
        public final Set<TextContent.TextDomain> checkedDomains() {
            EnumSet<Enum> result2 = EnumSet.of((Enum)TextContent.TextDomain.PLAIN_TEXT);
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInStringLiteralsEnabled()) {
                result2.add(TextContent.TextDomain.LITERALS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInCommentsEnabled()) {
                result2.add(TextContent.TextDomain.COMMENTS);
            }
            if (GrazieConfig.Companion.get().getCheckingContext().isCheckInDocumentationEnabled()) {
                result2.add(TextContent.TextDomain.DOCUMENTATION);
            }
            Intrinsics.checkNotNull(result2);
            return result2;
        }

        @JvmStatic
        @NotNull
        public final Function1<PsiElement, Boolean> getDisabledChecker(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Language language = file.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
            Language fileLanguage = language;
            Set<Language> supportedLanguages = TextExtractor.getSupportedLanguages();
            Set<String> disabledLanguages = GrazieConfig.Companion.get().getCheckingContext().getEffectivelyDisabledLanguageIds();
            return arg_0 -> Companion.getDisabledChecker$lambda$5(fileLanguage, supportedLanguages, disabledLanguages, arg_0);
        }

        @JvmStatic
        @NotNull
        public final List<TextContent> sortByPriority(@NotNull List<? extends TextContent> texts, @NotNull TextRange priorityRange) {
            Intrinsics.checkNotNullParameter(texts, (String)"texts");
            Intrinsics.checkNotNullParameter((Object)priorityRange, (String)"priorityRange");
            Iterable $this$sortedBy$iv = texts;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(priorityRange){
                final /* synthetic */ TextRange $priorityRange$inlined;
                {
                    this.$priorityRange$inlined = textRange;
                }

                public final int compare(T a, T b) {
                    TextContent text2 = (TextContent)a;
                    boolean bl = false;
                    TextRange textRange = text2.textRangeToFile(new TextRange(0, text2.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"textRangeToFile(...)");
                    TextRange textRangeInFile = textRange;
                    text2 = (TextContent)b;
                    Comparable comparable = Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2));
                    bl = false;
                    TextRange textRange2 = text2.textRangeToFile(new TextRange(0, text2.length()));
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"textRangeToFile(...)");
                    textRangeInFile = textRange2;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(textRangeInFile.contains(this.$priorityRange$inlined) ? 0 : (textRangeInFile.intersects(this.$priorityRange$inlined) ? 1 : 2)));
                }
            });
        }

        private static final Set skipCheckingTooLargeTexts$lambda$1(PsiFile it) {
            FileViewProvider fileViewProvider = it.getViewProvider();
            Intrinsics.checkNotNullExpressionValue((Object)fileViewProvider, (String)"getViewProvider(...)");
            Set<TextContent.TextDomain> set = TextContent.TextDomain.ALL;
            Intrinsics.checkNotNullExpressionValue(set, (String)"ALL");
            return Companion.findAllTextContents(fileViewProvider, set);
        }

        private static final Set skipCheckingTooLargeTexts$lambda$2(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final boolean skipCheckingTooLargeTexts$lambda$3(Set $checkedDomains, TextContent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return $checkedDomains.contains((Object)it.getDomain());
        }

        private static final boolean getDisabledChecker$lambda$5(Language $fileLanguage, Set $supportedLanguages, Set $disabledLanguages, PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Language lang = element.getLanguage();
            if ($fileLanguage.isKindOf(lang)) {
                lang = $fileLanguage;
            }
            while (lang != null && !$supportedLanguages.contains(lang)) {
                lang = lang.getBaseLanguage();
            }
            return lang != null && $disabledLanguages.contains(lang.getID());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

