/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.ml.inline.completion.impl.diagnostic.DiagnosticLoggersKt;
import com.intellij.ml.inline.completion.impl.diagnostic.MLCompletionEventListener;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditComputed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditConsideredChange;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditDiffAccepted;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditDiffShown;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditJumpAccepted;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditJumpShown;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditModelResponse;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditPromptComposed;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionFinishType;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionFinished;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionMessage;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditSessionMessagePayload;
import com.intellij.ml.inline.completion.impl.diagnostic.NextEditTargetFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015J\u0016\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015J\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\nJ\u0016\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015J\u000e\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\nJ\u000e\u0010\"\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\nJ\u001e\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nJ6\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\u0006\u0010,\u001a\u00020\n2\u0006\u0010-\u001a\u00020\nJ\u000e\u0010.\u001a\u00020\u00102\u0006\u0010/\u001a\u000200R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter;", "", "<init>", "()V", "requestId", "", "created", "shown", "Ljava/lang/Long;", "totalDiffs", "", "shownDiffs", "acceptedDiffs", "shownJumps", "acceptedJumps", "fire", "", "nextEditSessionMessage", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionMessagePayload;", "onPromptComposed", "prompt", "", "onClientResponse", "string", "onTargetFile", "before", "after", "onDiffComputed", "diffsCount", "onChangeConsidered", "path", "content", "onJumpShown", "jumpOffset", "onJumpAccepted", "onDiffShown", "startOffset", "endOffset", "textLengthDiff", "onDiffAccepted", "diffIndex", "diffsTotal", "startOffset1", "endOffset1", "startOffset2", "endOffset2", "onSessionFinished", "finishType", "Lcom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionFinishType;", "intellij.fullLine.core.completion"})
@SourceDebugExtension(value={"SMAP\ndiagnosticLoggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 diagnosticLoggers.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/NextEditSessionEventsReporter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,220:1\n1#2:221\n*E\n"})
public final class NextEditSessionEventsReporter {
    private final long requestId = Random.Default.nextLong();
    private final long created = System.currentTimeMillis();
    @Nullable
    private Long shown;
    private int totalDiffs;
    private int shownDiffs;
    private int acceptedDiffs;
    private int shownJumps;
    private int acceptedJumps;

    private final void fire(NextEditSessionMessagePayload nextEditSessionMessage) {
        if (!DiagnosticLoggersKt.access$getDispatcher$p().hasListeners()) {
            return;
        }
        ((MLCompletionEventListener)DiagnosticLoggersKt.access$getDispatcher$p().getMulticaster()).onEvent(new NextEditSessionMessage(this.requestId, nextEditSessionMessage));
    }

    public final void onPromptComposed(@NotNull String prompt2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        this.fire(new NextEditPromptComposed(prompt2));
    }

    public final void onClientResponse(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.fire(new NextEditModelResponse(string));
    }

    public final void onTargetFile(@NotNull String before, @NotNull String after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        this.fire(new NextEditTargetFile(before, after));
    }

    public final void onDiffComputed(int diffsCount) {
        this.totalDiffs = diffsCount;
        this.fire(new NextEditComputed(diffsCount));
    }

    public final void onChangeConsidered(@NotNull String path2, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.fire(new NextEditConsideredChange(path2, content));
    }

    public final void onJumpShown(int jumpOffset) {
        if (this.shown == null) {
            this.shown = System.currentTimeMillis();
        }
        int n = this.shownJumps;
        this.shownJumps = n + 1;
        this.fire(new NextEditJumpShown(jumpOffset));
    }

    public final void onJumpAccepted(int jumpOffset) {
        int n = this.acceptedJumps;
        this.acceptedJumps = n + 1;
        this.fire(new NextEditJumpAccepted(jumpOffset));
    }

    public final void onDiffShown(int startOffset, int endOffset, int textLengthDiff) {
        if (this.shown == null) {
            this.shown = System.currentTimeMillis();
        }
        int n = this.shownDiffs;
        this.shownDiffs = n + 1;
        this.fire(new NextEditDiffShown(startOffset, endOffset, textLengthDiff));
    }

    public final void onDiffAccepted(int diffIndex, int diffsTotal, int startOffset1, int endOffset1, int startOffset2, int endOffset2) {
        int n = this.acceptedDiffs;
        this.acceptedDiffs = n + 1;
        this.fire(new NextEditDiffAccepted(diffIndex, diffsTotal, startOffset1, endOffset1, startOffset2, endOffset2));
    }

    public final void onSessionFinished(@NotNull NextEditSessionFinishType finishType) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
        Long l2 = this.shown;
        if (l2 != null) {
            long shown = ((Number)l2).longValue();
            boolean bl = false;
            l = shown - this.created;
        } else {
            l = null;
        }
        Long timeToShow = l;
        this.fire(new NextEditSessionFinished(finishType, this.acceptedDiffs, this.shownDiffs, this.totalDiffs, this.acceptedJumps, this.shownJumps, timeToShow));
    }
}

