/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.publisher;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.cloudclient.QDCloudResponse;
import org.jetbrains.qodana.cloudclient.QDCloudResponseBlock;
import org.jetbrains.qodana.cloudclient.ResponseKt;
import org.jetbrains.qodana.cloudclient.v1.QDCloudProjectApiV1;
import org.jetbrains.qodana.cloudclient.v1.QDCloudSchema;
import org.jetbrains.qodana.publisher.Config;
import org.jetbrains.qodana.publisher.PublishResult;
import org.jetbrains.qodana.publisher.Publisher;
import org.jetbrains.qodana.publisher.PublisherKt;
import org.jetbrains.qodana.publisher.PublisherParameters;
import org.jetbrains.qodana.publisher.PublisherParametersKt;
import org.jetbrains.qodana.publisher.PublisherParsingException;
import org.jetbrains.qodana.publisher.QDCloudAwsClient;
import org.jetbrains.qodana.publisher.ReportMetadata;
import org.jetbrains.qodana.publisher.schemas.PublisherReportFile;
import org.jetbrains.qodana.publisher.schemas.UploadedReport;
import org.jetbrains.qodana.publisher.utils.UtilsKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/qodana/publisher/Publisher;", "", "qodanaCloudProjectApi", "Lorg/jetbrains/qodana/cloudclient/v1/QDCloudProjectApiV1;", "awsClient", "Lorg/jetbrains/qodana/publisher/QDCloudAwsClient;", "(Lorg/jetbrains/qodana/cloudclient/v1/QDCloudProjectApiV1;Lorg/jetbrains/qodana/publisher/QDCloudAwsClient;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "publish", "Lorg/jetbrains/qodana/publisher/PublishResult;", "config", "Lorg/jetbrains/qodana/publisher/Config;", "(Lorg/jetbrains/qodana/publisher/Config;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publisherParameters", "Lorg/jetbrains/qodana/publisher/PublisherParameters;", "(Lorg/jetbrains/qodana/publisher/PublisherParameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "publisher"})
@SourceDebugExtension(value={"SMAP\nPublisher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Publisher.kt\norg/jetbrains/qodana/publisher/Publisher\n+ 2 Utils.kt\norg/jetbrains/qodana/publisher/utils/UtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n106#2,3:108\n110#2:115\n1549#3:111\n1620#3,3:112\n*S KotlinDebug\n*F\n+ 1 Publisher.kt\norg/jetbrains/qodana/publisher/Publisher\n*L\n27#1:108,3\n27#1:115\n31#1:111\n31#1:112,3\n*E\n"})
public final class Publisher {
    @NotNull
    private final QDCloudProjectApiV1 qodanaCloudProjectApi;
    @NotNull
    private final QDCloudAwsClient awsClient;
    private final Logger logger;

    public Publisher(@NotNull QDCloudProjectApiV1 qodanaCloudProjectApi, @NotNull QDCloudAwsClient awsClient) {
        Intrinsics.checkNotNullParameter((Object)qodanaCloudProjectApi, (String)"qodanaCloudProjectApi");
        Intrinsics.checkNotNullParameter((Object)awsClient, (String)"awsClient");
        this.qodanaCloudProjectApi = qodanaCloudProjectApi;
        this.awsClient = awsClient;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Nullable
    public final Object publish(@NotNull PublisherParameters publisherParameters, @NotNull Continuation<? super PublishResult> $completion) {
        return this.publish(PublisherParametersKt.toPublisherConfig(publisherParameters), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object publish(Config var1_1, Continuation<? super PublishResult> var2_2) {
        if (!(var2_2 instanceof publish.2)) ** GOTO lbl-1000
        var24_3 = var2_2;
        if ((var24_3.label & -2147483648) != 0) {
            var24_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                /* synthetic */ Object result;
                final /* synthetic */ Publisher this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return Publisher.access$publish(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var25_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                prefix$iv = "qodana-report-gzipped-files";
                $i$f$withTempDirectory = false;
                tmpDir$iv = Files.createTempDirectory(prefix$iv, new FileAttribute[0]);
                Intrinsics.checkNotNull((Object)tmpDir$iv);
                gzipDir = tmpDir$iv;
                $i$a$-withTempDirectory-Publisher$publish$3 = false;
                this.logger.debug("Publishing report with config {}", (Object)config);
                $continuation.L$0 = this;
                $continuation.L$1 = config;
                $continuation.L$2 = tmpDir$iv;
                $continuation.L$3 = gzipDir;
                $continuation.label = 1;
                v0 = UtilsKt.getReportFiles(config.getReportPath(), gzipDir, (Continuation<? super List<PublisherReportFile>>)$continuation);
                ** if (v0 != var25_5) goto lbl31
lbl30:
                // 1 sources

                return var25_5;
lbl31:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                $i$f$withTempDirectory = false;
                $i$a$-withTempDirectory-Publisher$publish$3 = false;
                gzipDir = (Path)$continuation.L$3;
                tmpDir$iv = (Path)$continuation.L$2;
                config = (Config)$continuation.L$1;
                this = (Publisher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl43:
                // 2 sources

                reportFiles = (List)v0;
                var9_17 = reportFiles;
                var10_18 = "Report files are {}";
                var11_19 = this.logger;
                $i$f$map = false;
                var13_22 = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    var18_27 = (PublisherReportFile)item$iv$iv;
                    var19_28 = destination$iv$iv;
                    $i$a$-map-Publisher$publish$3$1 = false;
                    var19_28.add(it.getName());
                }
                var19_28 = (List)destination$iv$iv;
                var11_19.debug(var10_18, (Object)var19_28);
                $continuation.L$0 = this;
                $continuation.L$1 = config;
                $continuation.L$2 = tmpDir$iv;
                $continuation.L$3 = gzipDir;
                $continuation.L$4 = reportFiles;
                $continuation.label = 2;
                v1 = ReportMetadata.Companion.extract(config, reportFiles, (Continuation<? super ReportMetadata>)$continuation);
                ** if (v1 != var25_5) goto lbl69
lbl68:
                // 1 sources

                return var25_5;
lbl69:
                // 1 sources

                ** GOTO lbl82
            }
            case 2: {
                $i$f$withTempDirectory = false;
                $i$a$-withTempDirectory-Publisher$publish$3 = false;
                reportFiles = (List)$continuation.L$4;
                gzipDir = (Path)$continuation.L$3;
                tmpDir$iv = (Path)$continuation.L$2;
                config = (Config)$continuation.L$1;
                this = (Publisher)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl82:
                // 2 sources

                metadata = (ReportMetadata)v1;
                $continuation.L$0 = tmpDir$iv;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 3;
                v2 = ResponseKt.qodanaCloudResponse((Function2)new Function2<QDCloudResponseBlock, Continuation<? super UploadedReport>, Object>(config, (List<PublisherReportFile>)reportFiles, metadata, this, gzipDir, null){
                    Object L$1;
                    Object L$2;
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ Config $config;
                    final /* synthetic */ List<PublisherReportFile> $reportFiles;
                    final /* synthetic */ ReportMetadata $metadata;
                    final /* synthetic */ Publisher this$0;
                    final /* synthetic */ Path $gzipDir;
                    {
                        this.$config = $config;
                        this.$reportFiles = $reportFiles;
                        this.$metadata = $metadata;
                        this.this$0 = $receiver;
                        this.$gzipDir = $gzipDir;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var21_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$qodanaCloudResponse = (QDCloudResponseBlock)this.L$0;
                                publishRequest = PublisherKt.buildPublishRequest(this.$config, this.$reportFiles, this.$metadata);
                                var16_5 = $this$qodanaCloudResponse;
                                this.L$0 = $this$qodanaCloudResponse;
                                this.L$1 = var16_5;
                                this.label = 1;
                                v0 = Publisher.access$getQodanaCloudProjectApi$p(this.this$0).startUpload(publishRequest, (Continuation<? super QDCloudResponse<QDCloudSchema.StartPublishReportData>>)((Continuation)this));
                                if (v0 == var21_2) {
                                    return var21_2;
                                }
                                ** GOTO lbl20
                            }
                            case 1: {
                                var16_5 = (QDCloudResponseBlock)this.L$1;
                                $this$qodanaCloudResponse = (QDCloudResponseBlock)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl20:
                                // 2 sources

                                initPublishResponse = (QDCloudSchema.StartPublishReportData)var16_5.value((QDCloudResponse)v0);
                                var16_5 = $this$qodanaCloudResponse;
                                this.L$0 = $this$qodanaCloudResponse;
                                this.L$1 = initPublishResponse;
                                this.L$2 = var16_5;
                                this.label = 2;
                                v1 = UtilsKt.publishAllFiles(Publisher.access$getAwsClient$p(this.this$0), this.$reportFiles, this.$gzipDir, initPublishResponse.getFileLinks(), (Continuation<? super QDCloudResponse<? extends List<PublisherReportFile>>>)((Continuation)this));
                                if (v1 == var21_2) {
                                    return var21_2;
                                }
                                ** GOTO lbl36
                            }
                            case 2: {
                                var16_5 = (QDCloudResponseBlock)this.L$2;
                                initPublishResponse = (QDCloudSchema.StartPublishReportData)this.L$1;
                                $this$qodanaCloudResponse = (QDCloudResponseBlock)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl36:
                                // 2 sources

                                skippedFiles = (List)var16_5.value((QDCloudResponse)v1);
                                var16_5 = $this$qodanaCloudResponse;
                                this.L$0 = skippedFiles;
                                this.L$1 = var16_5;
                                this.L$2 = null;
                                this.label = 3;
                                v2 = Publisher.access$getQodanaCloudProjectApi$p(this.this$0).finishUpload(initPublishResponse.getReportId(), null, (Continuation<? super QDCloudResponse<QDCloudSchema.FinishPublishReportData>>)((Continuation)this));
                                if (v2 == var21_2) {
                                    return var21_2;
                                }
                                ** GOTO lbl51
                            }
                            case 3: {
                                var16_5 = (QDCloudResponseBlock)this.L$1;
                                skippedFiles = (List)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl51:
                                // 2 sources

                                finishResponse = (QDCloudSchema.FinishPublishReportData)var16_5.value((QDCloudResponse)v2);
                                $this$map$iv = skippedFiles;
                                $i$f$map = false;
                                var9_11 = $this$map$iv;
                                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    var14_16 = (PublisherReportFile)item$iv$iv;
                                    var17_18 = destination$iv$iv;
                                    $i$a$-map-Publisher$publish$3$response$1$1 = false;
                                    var17_18.add(it.getName());
                                }
                                var18_19 = finishResponse.getUrl();
                                var19_20 = finishResponse.getToken();
                                var20_21 = (List)destination$iv$iv;
                                return new UploadedReport(var20_21, var19_20, var18_19);
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value2;
                        return (Continuation)var3_3;
                    }

                    @Nullable
                    public final Object invoke(@NotNull QDCloudResponseBlock p1, @Nullable Continuation<? super UploadedReport> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v2 != var25_5) goto lbl92
lbl91:
                // 1 sources

                return var25_5;
lbl92:
                // 1 sources

                ** GOTO lbl102
            }
            case 3: {
                $i$f$withTempDirectory = false;
                $i$a$-withTempDirectory-Publisher$publish$3 = false;
                tmpDir$iv = (Path)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl102:
                    // 2 sources

                    if ((var13_22 = (response = (QDCloudResponse)v2)) instanceof QDCloudResponse.Error) {
                        v3 = new PublishResult.ServerError((QDCloudResponse.Error)response);
                    } else if (var13_22 instanceof QDCloudResponse.Success) {
                        v3 = new PublishResult.Success((UploadedReport)((QDCloudResponse.Success)response).getValue());
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    var22_30 = v3;
                    return var22_30;
                    {
                        catch (Throwable var21_31) {
                            throw var21_31;
                        }
                    }
                    finally {
                        v4 = tmpDir$iv.toFile();
                        Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"toFile(...)");
                        FilesKt.deleteRecursively((File)v4);
                    }
                }
                catch (PublisherParsingException pe) {
                    return new PublishResult.ParsingError(pe);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$publish(Publisher $this, Config config, Continuation $completion) {
        return $this.publish(config, (Continuation<? super PublishResult>)$completion);
    }

    public static final /* synthetic */ QDCloudProjectApiV1 access$getQodanaCloudProjectApi$p(Publisher $this) {
        return $this.qodanaCloudProjectApi;
    }

    public static final /* synthetic */ QDCloudAwsClient access$getAwsClient$p(Publisher $this) {
        return $this.awsClient;
    }
}

