/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.media.tags.internal;

import com.vladsch.flexmark.ext.media.tags.AudioLink;
import com.vladsch.flexmark.ext.media.tags.EmbedLink;
import com.vladsch.flexmark.ext.media.tags.PictureLink;
import com.vladsch.flexmark.ext.media.tags.VideoLink;
import com.vladsch.flexmark.ext.media.tags.internal.Utilities;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MediaTagsNodeRenderer
implements NodeRenderer {
    public MediaTagsNodeRenderer(DataHolder options) {
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<AudioLink>(AudioLink.class, this::renderAudioLink));
        set.add(new NodeRenderingHandler<EmbedLink>(EmbedLink.class, this::renderEmbedLink));
        set.add(new NodeRenderingHandler<PictureLink>(PictureLink.class, this::renderPictureLink));
        set.add(new NodeRenderingHandler<VideoLink>(VideoLink.class, this::renderVideoLink));
        return set;
    }

    private void renderAudioLink(AudioLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren(node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), false);
            String[] sources = resolvedLink.getUrl().split("\\|");
            ((HtmlWriter)((HtmlWriter)html.attr("title", node.getText())).attr("controls", "")).withAttr().tag("audio");
            for (String source : sources) {
                String encoded2 = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl(source) : source;
                String type2 = Utilities.resolveAudioType(source);
                html.attr("src", encoded2);
                if (type2 != null) {
                    html.attr("type", type2);
                }
                html.withAttr().tag((CharSequence)"source", true);
            }
            html.text("Your browser does not support the audio element.");
            html.tag("/audio");
        }
    }

    private void renderEmbedLink(EmbedLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren(node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), null);
            ((HtmlWriter)((HtmlWriter)html.attr("title", node.getText())).attr("src", resolvedLink.getUrl())).withAttr().tag((CharSequence)"embed", true);
        }
    }

    private void renderPictureLink(PictureLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren(node);
        } else {
            String encoded2;
            String source;
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), false);
            String[] sources = resolvedLink.getUrl().split("\\|");
            html.tag("picture");
            for (int index = 0; index < sources.length - 1; ++index) {
                source = sources[index];
                encoded2 = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl(source) : source;
                ((HtmlWriter)html.attr("srcset", encoded2)).withAttr().tag((CharSequence)"source", true);
            }
            int last = sources.length - 1;
            if (last >= 0) {
                source = sources[last];
                encoded2 = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl(source) : source;
                ((HtmlWriter)((HtmlWriter)html.attr("src", encoded2)).attr("alt", node.getText())).withAttr().tag((CharSequence)"img", true);
            }
            html.tag("/picture");
        }
    }

    private void renderVideoLink(VideoLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren(node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, node.getUrl().unescape(), false);
            String[] sources = resolvedLink.getUrl().split("\\|");
            ((HtmlWriter)((HtmlWriter)html.attr("title", node.getText())).attr("controls", "")).withAttr().tag("video");
            for (String source : sources) {
                String encoded2 = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl(source) : source;
                String type2 = Utilities.resolveVideoType(source);
                html.attr("src", encoded2);
                if (type2 != null) {
                    html.attr("type", type2);
                }
                html.withAttr().tag((CharSequence)"source", true);
            }
            html.text("Your browser does not support the video element.");
            html.tag("/video");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new MediaTagsNodeRenderer(options);
        }
    }
}

