/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleImpl;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.containers.ContainerUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Presentation(icon="AllIcons.Nodes.ResourceBundle")
public final class ResourceBundleAsVirtualFile
extends VirtualFile
implements VirtualFileWithoutContent {
    private final ResourceBundle myResourceBundle;

    public ResourceBundleAsVirtualFile(@NotNull ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(0);
        }
        this.myResourceBundle = resourceBundle;
    }

    @NotNull
    public ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = this.myResourceBundle;
        if (resourceBundle == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(1);
        }
        return resourceBundle;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        if (localFileSystem == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(2);
        }
        return localFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.getName();
        if (string == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getName() {
        return this.myResourceBundle.isValid() ? this.myResourceBundle.getBaseName() : "";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleAsVirtualFile resourceBundleAsVirtualFile = (ResourceBundleAsVirtualFile)((Object)o);
        return this.myResourceBundle.equals(resourceBundleAsVirtualFile.myResourceBundle);
    }

    public int hashCode() {
        return this.myResourceBundle.hashCode();
    }

    public void rename(Object requestor, @NotNull String newName) {
        if (newName == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        if (this.myResourceBundle instanceof ResourceBundleImpl && !this.myResourceBundle.isValid()) {
            return false;
        }
        for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
            VirtualFile virtualFile = propertiesFile.getVirtualFile();
            if (virtualFile != null && virtualFile.isValid()) continue;
            return false;
        }
        return true;
    }

    public VirtualFile getParent() {
        return this.myResourceBundle.isValid() ? this.myResourceBundle.getBaseDirectory() : null;
    }

    public VirtualFile[] getChildren() {
        return EMPTY_ARRAY;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull String name) {
        if (name == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(5);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile createChildData(Object requestor, @NotNull String name) {
        if (name == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    public void delete(Object requestor) {
    }

    public void move(Object requestor, @NotNull VirtualFile newParent) {
        if (newParent == null) {
            ResourceBundleAsVirtualFile.$$$reportNull$$$0(7);
        }
    }

    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    public byte @NotNull [] contentsToByteArray() {
        return new byte[0];
    }

    public long getModificationStamp() {
        return 0L;
    }

    public long getTimeStamp() {
        return 0L;
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
        List files = ContainerUtil.mapNotNull(this.myResourceBundle.getPropertiesFiles(), file -> file.getVirtualFile());
        if (!files.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, postRunnable, (Collection)files);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceBundle";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/properties/editor/ResourceBundleAsVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceBundle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "rename";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createChildData";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "move";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

