/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers.async.core.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilerHandlerUtils;
import com.jetbrains.performancePlugin.profilers.async.core.AsyncBundle;
import com.jetbrains.performancePlugin.profilers.async.core.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.async.core.actions.StartStopAsyncProfilerAction;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CaptureCPUUsageDataAction
extends ToggleAction
implements DumbAware {
    public static final String CPU_USAGE = "cpu-usage";
    private String myActiveDumpPath;

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(0);
        }
        return CaptureCPUUsageDataAction.isRunning();
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        if (event == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(1);
        }
        final AsyncProfilerHandler profiler = AsyncProfilerHandler.getInstance();
        if (!CaptureCPUUsageDataAction.isRunning()) {
            try {
                this.myActiveDumpPath = FileUtil.createTempFile((String)"cpu-profiling", (String)".jfr").getAbsolutePath();
                String cpuEvent = profiler.getCpuEvent();
                profiler.startProfiling(CPU_USAGE, List.of("event=" + cpuEvent, "interval=10000000", "jfr", "jfrsync=profile", "file=" + this.myActiveDumpPath), false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            final String dumpPath = this.myActiveDumpPath != null ? this.myActiveDumpPath : profiler.getSnapshotPath();
            this.myActiveDumpPath = null;
            new Task.Backgroundable(CaptureCPUUsageDataAction.getEventProject((AnActionEvent)event), PerformanceTestingBundle.message((String)"profiling.compress.snapshot.progress", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        profiler.stopProfiling(List.of("jfr"));
                        File snapshot = profiler.compressResults(dumpPath, Profiler.formatSnapshotName((boolean)false));
                        if (snapshot != null) {
                            ProfilerHandlerUtils.notify((Project)this.myProject, (File)snapshot);
                        }
                    }
                    catch (ProcessCanceledException snapshot) {
                    }
                    catch (Exception ex) {
                        ProfilerHandlerUtils.notifyCapturingError((Throwable)ex, (Project)this.myProject);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/performancePlugin/profilers/async/core/actions/CaptureCPUUsageDataAction$1", "run"));
                }
            }.queue();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(StartStopAsyncProfilerAction.isEnabled(CPU_USAGE));
        presentation.setText(AsyncBundle.messagePointer(CaptureCPUUsageDataAction.isRunning() ? "stop.capture.cpu.usage.data.action.name" : "action.CaptureCPUUsageData.text", new Object[0]));
        super.update(e);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            CaptureCPUUsageDataAction.$$$reportNull$$$0(3);
        }
        return actionUpdateThread;
    }

    private static boolean isRunning() {
        return StartStopAsyncProfilerAction.isRunning(CPU_USAGE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/profilers/async/core/actions/CaptureCPUUsageDataAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/profilers/async/core/actions/CaptureCPUUsageDataAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

