/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.terminal.session.TerminalClearBufferEvent;
import com.intellij.terminal.session.TerminalInputEvent;
import com.intellij.terminal.session.TerminalResizeEvent;
import com.intellij.terminal.session.TerminalSession;
import com.intellij.terminal.session.TerminalState;
import com.intellij.terminal.session.TerminalWriteBytesEvent;
import com.intellij.terminal.session.dto.TerminalSizeDtoKt;
import com.jediterm.core.util.TermSize;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeMark;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.ClosedSendChannelException;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.TerminalSessionModel;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporter;
import org.jetbrains.plugins.terminal.fus.BatchLatencyReporterKt;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.fus.TerminalStartupFusInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 )2\u00020\u0001:\u0002)*B/\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 J\u001a\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020 2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%J\u0010\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u000fH\u0002J\u0010\u0010(\u001a\u00020\u00182\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput;", "", "terminalSessionFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/terminal/session/TerminalSession;", "sessionModel", "Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;", "startupFusInfo", "Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Ljava/util/concurrent/CompletableFuture;Lorg/jetbrains/plugins/terminal/block/reworked/TerminalSessionModel;Lorg/jetbrains/plugins/terminal/fus/TerminalStartupFusInfo;Lkotlinx/coroutines/CoroutineScope;)V", "bufferChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/intellij/terminal/frontend/TerminalInput$InputEventSubmission;", "inputChannelDeferred", "Lkotlinx/coroutines/Deferred;", "Lkotlinx/coroutines/channels/SendChannel;", "Lcom/intellij/terminal/session/TerminalInputEvent;", "typingLatencyReporter", "Lorg/jetbrains/plugins/terminal/fus/BatchLatencyReporter;", "Lkotlin/time/Duration;", "sendString", "", "data", "", "sendTrackedString", "eventTime", "Lkotlin/time/TimeMark;", "sendBracketedString", "sendBytes", "", "doSendBytes", "sendClearBuffer", "sendResize", "newSize", "Lcom/jediterm/core/util/TermSize;", "sendEvent", "event", "reportShellStartingLatency", "Companion", "InputEventSubmission", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalInput.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalInput.kt\ncom/intellij/terminal/frontend/TerminalInput\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,156:1\n15#2:157\n*S KotlinDebug\n*F\n+ 1 TerminalInput.kt\ncom/intellij/terminal/frontend/TerminalInput\n*L\n30#1:157\n*E\n"})
public final class TerminalInput {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CompletableFuture<TerminalSession> terminalSessionFuture;
    @NotNull
    private final TerminalSessionModel sessionModel;
    @NotNull
    private final Channel<InputEventSubmission> bufferChannel;
    @NotNull
    private final Deferred<SendChannel<TerminalInputEvent>> inputChannelDeferred;
    @NotNull
    private final BatchLatencyReporter<Duration> typingLatencyReporter;
    @NotNull
    private static final DataKey<TerminalInput> KEY = DataKey.Companion.create("TerminalInput");
    @NotNull
    private static final Logger LOG;

    public TerminalInput(@NotNull CompletableFuture<TerminalSession> terminalSessionFuture, @NotNull TerminalSessionModel sessionModel, @Nullable TerminalStartupFusInfo startupFusInfo, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter(terminalSessionFuture, (String)"terminalSessionFuture");
        Intrinsics.checkNotNullParameter((Object)sessionModel, (String)"sessionModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.terminalSessionFuture = terminalSessionFuture;
        this.sessionModel = sessionModel;
        this.bufferChannel = ChannelKt.Channel$default((int)10000, (BufferOverflow)BufferOverflow.DROP_OLDEST, null, (int)4, null);
        this.inputChannelDeferred = BuildersKt.async$default((CoroutineScope)coroutineScope, (CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)new CoroutineName("Get input channel")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SendChannel<? super TerminalInputEvent>>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalInput this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = FutureKt.await((CompletionStage)TerminalInput.access$getTerminalSessionFuture$p(this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((TerminalSession)v0).getInputChannel((Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super SendChannel<? super TerminalInputEvent>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        this.typingLatencyReporter = new BatchLatencyReporter(50, TerminalInput::typingLatencyReporter$lambda$0);
        Job job2 = BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, startupFusInfo, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int label;
            final /* synthetic */ TerminalInput this$0;
            final /* synthetic */ TerminalStartupFusInfo $startupFusInfo;
            {
                this.this$0 = $receiver;
                this.$startupFusInfo = $startupFusInfo;
                super(2, $completion);
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object var1_1) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = TerminalInput.access$getInputChannelDeferred$p(this.this$0).await((Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        targetChannel = (SendChannel)v0;
                        if (this.$startupFusInfo != null) {
                            TerminalInput.access$reportShellStartingLatency(this.this$0, this.$startupFusInfo);
                        }
                        try {
                            var3_4 = TerminalInput.access$getBufferChannel$p(this.this$0).iterator();
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (ClosedSendChannelException e) {
                            TerminalInput.access$getLOG$cp().warn("Failed to send the event because input channel is closed");
                            return Unit.INSTANCE;
                        }
                        catch (Throwable t) {
                            TerminalInput.access$getLOG$cp().error("Error while sending input event", t);
                            return Unit.INSTANCE;
                        }
lbl28:
                        // 3 sources

                        while (true) {
                            this.L$0 = targetChannel;
                            this.L$1 = var3_4;
                            this.L$2 = null;
                            this.label = 2;
                            v1 = var3_4.hasNext((Continuation)this);
                            if (v1 == var7_2) {
                                return var7_2;
                            }
                            ** GOTO lbl43
                            break;
                        }
                    }
                    case 2: {
                        var3_4 = (ChannelIterator)this.L$1;
                        targetChannel = (SendChannel)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl43:
                            // 2 sources

                            if ((Boolean)v1 == false) return Unit.INSTANCE;
                            submission = (InputEventSubmission)var3_4.next();
                            event = submission.getEvent();
                            this.L$0 = targetChannel;
                            this.L$1 = var3_4;
                            this.L$2 = submission;
                            this.label = 3;
                            v2 = targetChannel.send((Object)event, (Continuation)this);
                            ** if (v2 != var7_2) goto lbl53
                        }
lbl52:
                        // 1 sources

                        return var7_2;
lbl53:
                        // 1 sources

                        ** GOTO lbl61
                    }
                    case 3: {
                        submission = (InputEventSubmission)this.L$2;
                        var3_4 = (ChannelIterator)this.L$1;
                        targetChannel = (SendChannel)this.L$0;
                        {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl61:
                            // 2 sources

                            v3 = submission.getEventTime();
                            latency /* !! */  = v3 != null ? Duration.box-impl((long)v3.elapsedNow-UwyO8pc()) : null;
                            if (latency /* !! */  == null) ** GOTO lbl28
                            TerminalInput.access$getTypingLatencyReporter$p(this.this$0).update(latency /* !! */ );
                            ** continue;
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        job2.invokeOnCompletion(arg_0 -> TerminalInput._init_$lambda$1(this, arg_0));
    }

    public final void sendString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        String string = data;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.doSendBytes(byArray, null);
    }

    public final void sendTrackedString(@NotNull String data, @NotNull TimeMark eventTime) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)eventTime, (String)"eventTime");
        String string = data;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        this.doSendBytes(byArray, eventTime);
    }

    public final void sendBracketedString(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (((TerminalState)this.sessionModel.getTerminalState().getValue()).isBracketedPasteMode()) {
            this.sendString("\u001b[200~" + data + "\u001b[201~");
        } else {
            this.sendString(data);
        }
    }

    public final void sendBytes(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.doSendBytes(data, null);
    }

    private final void doSendBytes(byte[] data, TimeMark eventTime) {
        TerminalWriteBytesEvent writeBytesEvent = new TerminalWriteBytesEvent(data);
        this.sendEvent(new InputEventSubmission((TerminalInputEvent)writeBytesEvent, eventTime));
    }

    public final void sendClearBuffer() {
        this.sendEvent(new InputEventSubmission((TerminalInputEvent)new TerminalClearBufferEvent(), null, 2, null));
    }

    public final void sendResize(@NotNull TermSize newSize) {
        Intrinsics.checkNotNullParameter((Object)newSize, (String)"newSize");
        if ((TerminalSession)this.terminalSessionFuture.getNow(null) == null) {
            return;
        }
        TerminalResizeEvent event = new TerminalResizeEvent(TerminalSizeDtoKt.toDto((TermSize)newSize));
        this.sendEvent(new InputEventSubmission((TerminalInputEvent)event, null, 2, null));
    }

    private final void sendEvent(InputEventSubmission event) {
        Object result2 = this.bufferChannel.trySend-JP2dKIU((Object)event);
        if (ChannelResult.isClosed-impl((Object)result2)) {
            LOG.warn("Terminal input channel is closed, " + event + " won't be sent", ChannelResult.exceptionOrNull-impl((Object)result2));
        } else if (ChannelResult.isFailure-impl((Object)result2)) {
            LOG.error("Failed to send input event: " + event, ChannelResult.exceptionOrNull-impl((Object)result2));
        }
    }

    private final void reportShellStartingLatency(TerminalStartupFusInfo startupFusInfo) {
        long latency = startupFusInfo.getTriggerTime().elapsedNow-UwyO8pc();
        ReworkedTerminalUsageCollector.INSTANCE.logStartupShellStartingLatency-HG0u8IE(startupFusInfo.getWay(), latency);
        LOG.info("Reworked terminal startup shell starting latency: " + Duration.getInWholeMilliseconds-impl((long)latency) + " ms");
    }

    private static final Unit typingLatencyReporter$lambda$0(List samples) {
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        ReworkedTerminalUsageCollector.INSTANCE.logFrontendTypingLatency-WzaCiaA(BatchLatencyReporterKt.totalDuration(samples), ((Duration)BatchLatencyReporterKt.percentile(samples, 90)).unbox-impl(), ((Duration)BatchLatencyReporterKt.secondLargest(samples)).unbox-impl());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TerminalInput this$0, Throwable it) {
        SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)this$0.bufferChannel), null, (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ CompletableFuture access$getTerminalSessionFuture$p(TerminalInput $this) {
        return $this.terminalSessionFuture;
    }

    public static final /* synthetic */ Deferred access$getInputChannelDeferred$p(TerminalInput $this) {
        return $this.inputChannelDeferred;
    }

    public static final /* synthetic */ void access$reportShellStartingLatency(TerminalInput $this, TerminalStartupFusInfo startupFusInfo) {
        $this.reportShellStartingLatency(startupFusInfo);
    }

    public static final /* synthetic */ Channel access$getBufferChannel$p(TerminalInput $this) {
        return $this.bufferChannel;
    }

    public static final /* synthetic */ BatchLatencyReporter access$getTypingLatencyReporter$p(TerminalInput $this) {
        return $this.typingLatencyReporter;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalInput.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/terminal/frontend/TerminalInput;", "getKEY", "()Lcom/intellij/openapi/actionSystem/DataKey;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<TerminalInput> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/terminal/frontend/TerminalInput$InputEventSubmission;", "", "event", "Lcom/intellij/terminal/session/TerminalInputEvent;", "eventTime", "Lkotlin/time/TimeMark;", "<init>", "(Lcom/intellij/terminal/session/TerminalInputEvent;Lkotlin/time/TimeMark;)V", "getEvent", "()Lcom/intellij/terminal/session/TerminalInputEvent;", "getEventTime", "()Lkotlin/time/TimeMark;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.terminal.frontend"})
    private static final class InputEventSubmission {
        @NotNull
        private final TerminalInputEvent event;
        @Nullable
        private final TimeMark eventTime;

        public InputEventSubmission(@NotNull TerminalInputEvent event, @Nullable TimeMark eventTime) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.event = event;
            this.eventTime = eventTime;
        }

        public /* synthetic */ InputEventSubmission(TerminalInputEvent terminalInputEvent, TimeMark timeMark, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                timeMark = null;
            }
            this(terminalInputEvent, timeMark);
        }

        @NotNull
        public final TerminalInputEvent getEvent() {
            return this.event;
        }

        @Nullable
        public final TimeMark getEventTime() {
            return this.eventTime;
        }

        @NotNull
        public final TerminalInputEvent component1() {
            return this.event;
        }

        @Nullable
        public final TimeMark component2() {
            return this.eventTime;
        }

        @NotNull
        public final InputEventSubmission copy(@NotNull TerminalInputEvent event, @Nullable TimeMark eventTime) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            return new InputEventSubmission(event, eventTime);
        }

        public static /* synthetic */ InputEventSubmission copy$default(InputEventSubmission inputEventSubmission, TerminalInputEvent terminalInputEvent, TimeMark timeMark, int n, Object object) {
            if ((n & 1) != 0) {
                terminalInputEvent = inputEventSubmission.event;
            }
            if ((n & 2) != 0) {
                timeMark = inputEventSubmission.eventTime;
            }
            return inputEventSubmission.copy(terminalInputEvent, timeMark);
        }

        @NotNull
        public String toString() {
            return "InputEventSubmission(event=" + this.event + ", eventTime=" + this.eventTime + ")";
        }

        public int hashCode() {
            int result2 = this.event.hashCode();
            result2 = result2 * 31 + (this.eventTime == null ? 0 : this.eventTime.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InputEventSubmission)) {
                return false;
            }
            InputEventSubmission inputEventSubmission = (InputEventSubmission)other;
            if (!Intrinsics.areEqual((Object)this.event, (Object)inputEventSubmission.event)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.eventTime, (Object)inputEventSubmission.eventTime);
        }
    }
}

