/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.actions;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.FrontendXDebuggerManager;
import com.intellij.platform.debugger.impl.frontend.FrontendXDebuggerSession;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.FrontendDebuggerActionsKt;
import com.intellij.xdebugger.impl.actions.handlers.XMarkObjectActionHandler;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.rpc.XValueMarkerId;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0016J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\bH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/actions/FrontendMarkObjectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/remoting/ActionRemoteBehaviorSpecification$Frontend;", "<init>", "()V", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "e", "getMarkers", "Lcom/intellij/xdebugger/impl/frame/XValueMarkers;", "Lcom/intellij/platform/debugger/impl/frontend/evaluate/quick/FrontendXValue;", "Lcom/intellij/xdebugger/impl/rpc/XValueMarkerId;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.debugger.impl.frontend"})
@ApiStatus.Internal
final class FrontendMarkObjectAction
extends AnAction
implements ActionRemoteBehaviorSpecification.Frontend {
    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!FrontendDebuggerActionsKt.areFrontendDebuggerActionsEnabled()) {
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        XValueMarkers<FrontendXValue, XValueMarkerId> xValueMarkers = this.getMarkers(event);
        if (xValueMarkers == null) {
            FrontendMarkObjectAction $this$update_u24lambda_u240 = this;
            boolean bl = false;
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        XValueMarkers<FrontendXValue, XValueMarkerId> markers = xValueMarkers;
        XValue xValue = XDebuggerTreeActionBase.getSelectedValue((DataContext)event.getDataContext());
        if (xValue == null) {
            FrontendMarkObjectAction $this$update_u24lambda_u241 = this;
            boolean bl = false;
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        XValue value = xValue;
        boolean canMark = markers.canMarkValue(value);
        if (!canMark) {
            event.getPresentation().setVisible(true);
            event.getPresentation().setEnabled(false);
            return;
        }
        boolean isMarked = markers.getMarkup(value) != null;
        String text = isMarked ? ActionsBundle.message((String)"action.Debugger.MarkObject.unmark.text", (Object[])new Object[0]) : ActionsBundle.message((String)"action.Debugger.MarkObject.text", (Object[])new Object[0]);
        event.getPresentation().setText(text);
        event.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XValueMarkers<FrontendXValue, XValueMarkerId> markers = this.getMarkers(e);
        XValueNodeImpl node = XDebuggerTreeActionBase.getSelectedNode((DataContext)e.getDataContext());
        if (markers == null || node == null) {
            return;
        }
        XDebuggerTreeState treeState = XDebuggerTreeState.saveState((XDebuggerTree)node.getTree());
        XMarkObjectActionHandler.Companion.performMarkObject(e, node, markers, () -> FrontendMarkObjectAction.actionPerformed$lambda$2(e, node, treeState));
    }

    private final XValueMarkers<FrontendXValue, XValueMarkerId> getMarkers(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        FrontendXDebuggerSession frontendXDebuggerSession = (FrontendXDebuggerSession)FrontendXDebuggerManager.Companion.getInstance(project2).getCurrentSession().getValue();
        return frontendXDebuggerSession != null ? frontendXDebuggerSession.getValueMarkers() : null;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final Unit actionPerformed$lambda$2(AnActionEvent $e, XValueNodeImpl $node, XDebuggerTreeState $treeState) {
        if (DebuggerUIUtil.isInDetachedTree((AnActionEvent)$e)) {
            $node.getTree().rebuildAndRestore($treeState);
        }
        return Unit.INSTANCE;
    }
}

