/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.PowerService;
import com.intellij.util.io.PowerStatus;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u0002J\u001a\u0010\u0017\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\tH\u0002J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0012\u001a\u0004\u0018\u00010\tH\u0002J0\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u0019*\u0004\u0018\u00010\t2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00190\u001bH\u0082\b\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/util/io/MacPowerService;", "Lcom/intellij/util/io/PowerService;", "<init>", "()V", "status", "Lcom/intellij/util/io/PowerStatus;", "ioKit", "Lcom/intellij/util/io/MacPowerService$IOKit;", "kIOPSIsPresentKey", "Lcom/sun/jna/Pointer;", "kIOPSTypeKey", "kIOPSInternalBatteryType", "kIOPSUPSType", "kIOPSPowerSourceStateKey", "kIOPSBatteryPowerValue", "kCFCompareEqualTo", "", "CFSTR", "str", "", "isTrue", "", "p", "strEquals", "use", "T", "block", "Lkotlin/Function1;", "(Lcom/sun/jna/Pointer;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "IOKit", "CFRange", "intellij.platform.ide.util.io"})
@SourceDebugExtension(value={"SMAP\nPowerStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PowerStatus.kt\ncom/intellij/util/io/MacPowerService\n*L\n1#1,234:1\n181#1,2:235\n181#1,2:237\n*S KotlinDebug\n*F\n+ 1 PowerStatus.kt\ncom/intellij/util/io/MacPowerService\n*L\n101#1:235,2\n102#1:237,2\n*E\n"})
final class MacPowerService
implements PowerService {
    @NotNull
    private final IOKit ioKit;
    @NotNull
    private final Pointer kIOPSIsPresentKey;
    @NotNull
    private final Pointer kIOPSTypeKey;
    @NotNull
    private final Pointer kIOPSInternalBatteryType;
    @NotNull
    private final Pointer kIOPSUPSType;
    @NotNull
    private final Pointer kIOPSPowerSourceStateKey;
    @NotNull
    private final Pointer kIOPSBatteryPowerValue;
    private final long kCFCompareEqualTo;

    public MacPowerService() {
        Library library = Native.load((String)"IOKit", IOKit.class);
        Intrinsics.checkNotNullExpressionValue((Object)library, (String)"load(...)");
        this.ioKit = (IOKit)library;
        this.kIOPSIsPresentKey = this.CFSTR("Is Present");
        this.kIOPSTypeKey = this.CFSTR("Type");
        this.kIOPSInternalBatteryType = this.CFSTR("InternalBattery");
        this.kIOPSUPSType = this.CFSTR("UPS");
        this.kIOPSPowerSourceStateKey = this.CFSTR("Power Source State");
        this.kIOPSBatteryPowerValue = this.CFSTR("Battery Power");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public PowerStatus status() {
        PowerStatus powerStatus;
        PowerStatus powerStatus2;
        MacPowerService macPowerService = this;
        Pointer $this$use$iv = this.ioKit.IOPSCopyPowerSourcesInfo();
        boolean $i$f$use = false;
        if ($this$use$iv == null) {
            powerStatus2 = null;
        } else {
            PowerStatus powerStatus3;
            try {
                PowerStatus powerStatus4;
                Pointer psBlob = $this$use$iv;
                boolean bl = false;
                MacPowerService macPowerService2 = this;
                Pointer $this$use$iv2 = this.ioKit.IOPSCopyPowerSourcesList(psBlob);
                boolean $i$f$use2 = false;
                if ($this$use$iv2 == null) {
                    powerStatus4 = null;
                } else {
                    PowerStatus powerStatus5;
                    try {
                        PowerStatus powerStatus6;
                        Pointer psList = $this$use$iv2;
                        boolean bl2 = false;
                        PowerStatus batteryState = null;
                        PowerStatus upsState = null;
                        long count = this.ioKit.CFArrayGetCount(psList);
                        if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
                            PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug("count=" + count);
                        }
                        for (long i = 0L; i < count; ++i) {
                            Pointer ps = this.ioKit.IOPSGetPowerSourceDescription(psBlob, this.ioKit.CFArrayGetValueAtIndex(psList, i));
                            if (!this.isTrue(this.ioKit.CFDictionaryGetValue(ps, this.kIOPSIsPresentKey))) continue;
                            Pointer type = this.ioKit.CFDictionaryGetValue(ps, this.kIOPSTypeKey);
                            Pointer state = this.ioKit.CFDictionaryGetValue(ps, this.kIOPSPowerSourceStateKey);
                            if (PowerService.Companion.getLOG$intellij_platform_ide_util_io().isDebugEnabled()) {
                                PowerService.Companion.getLOG$intellij_platform_ide_util_io().debug(i + ": type='" + this.str(type) + "' state='" + this.str(state) + "'");
                            }
                            if (this.strEquals(type, this.kIOPSInternalBatteryType)) {
                                batteryState = this.strEquals(state, this.kIOPSBatteryPowerValue) ? PowerStatus.BATTERY : PowerStatus.AC;
                                break;
                            }
                            if (!this.strEquals(type, this.kIOPSUPSType) || upsState != null) continue;
                            upsState = this.strEquals(state, this.kIOPSBatteryPowerValue) ? PowerStatus.BATTERY : PowerStatus.AC;
                        }
                        if (batteryState == PowerStatus.BATTERY) {
                            powerStatus6 = PowerStatus.BATTERY;
                        } else {
                            powerStatus6 = upsState;
                            if (powerStatus6 == null) {
                                powerStatus6 = PowerStatus.AC;
                            }
                        }
                        powerStatus5 = powerStatus6;
                    }
                    finally {
                        void this_$iv;
                        this_$iv.ioKit.CFRelease($this$use$iv2);
                    }
                    powerStatus4 = powerStatus5;
                }
                powerStatus3 = powerStatus4;
            }
            finally {
                void this_$iv;
                this_$iv.ioKit.CFRelease($this$use$iv);
            }
            powerStatus2 = powerStatus = powerStatus3;
        }
        if (powerStatus2 == null) {
            powerStatus = PowerStatus.UNKNOWN;
        }
        return powerStatus;
    }

    private final Pointer CFSTR(String str) {
        char[] cArray = str.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        return this.ioKit.CFStringCreateWithCharacters(null, cArray, str.length());
    }

    private final boolean isTrue(Pointer p) {
        return p != null && this.ioKit.CFBooleanGetValue(p) != 0;
    }

    private final boolean strEquals(Pointer p, Pointer str) {
        return p != null && this.ioKit.CFStringCompare(p, str, 0L) == this.kCFCompareEqualTo;
    }

    private final String str(Pointer str) {
        String string;
        if (str == null) {
            string = "<null>";
        } else {
            CFRange range = new CFRange();
            range.length = this.ioKit.CFStringGetLength(str);
            char[] buffer = new char[(int)range.length];
            this.ioKit.CFStringGetCharacters(str, range, buffer);
            string = new String(buffer);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T use(Pointer $this$use, Function1<? super Pointer, ? extends T> block) {
        Object object;
        boolean $i$f$use = false;
        if ($this$use == null) {
            object = null;
        } else {
            Object object2;
            try {
                object2 = block.invoke((Object)$this$use);
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this.ioKit.CFRelease($this$use);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        return (T)object;
    }

    @Structure.FieldOrder(value={"location", "length"})
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/util/io/MacPowerService$CFRange;", "Lcom/sun/jna/Structure;", "Lcom/sun/jna/Structure$ByValue;", "<init>", "()V", "location", "", "length", "intellij.platform.ide.util.io"})
    public static final class CFRange
    extends Structure
    implements Structure.ByValue {
        @JvmField
        public long location;
        @JvmField
        public long length;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u0019\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u0003H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H&J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003H&J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H&J\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\fH&J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H&J\"\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fH&J \u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\fH&J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0003H&J \u0010\u001e\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0016H&J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006%\u00c0\u0006\u0001"}, d2={"Lcom/intellij/util/io/MacPowerService$IOKit;", "Lcom/sun/jna/Library;", "IOPSCopyPowerSourcesInfo", "Lcom/sun/jna/Pointer;", "IOPSCopyPowerSourcesList", "psBlob", "IOPSGetPowerSourceDescription", "psName", "CFRelease", "", "p", "CFArrayGetCount", "", "array", "CFArrayGetValueAtIndex", "idx", "CFDictionaryGetValue", "dict", "key", "CFStringCreateWithCharacters", "alloc", "chars", "", "numChars", "CFStringCompare", "str1", "str2", "flags", "CFStringGetLength", "str", "CFStringGetCharacters", "range", "Lcom/intellij/util/io/MacPowerService$CFRange;", "buffer", "CFBooleanGetValue", "", "ref", "intellij.platform.ide.util.io"})
    private static interface IOKit
    extends Library {
        @Nullable
        public Pointer IOPSCopyPowerSourcesInfo();

        @Nullable
        public Pointer IOPSCopyPowerSourcesList(@NotNull Pointer var1);

        @NotNull
        public Pointer IOPSGetPowerSourceDescription(@NotNull Pointer var1, @NotNull Pointer var2);

        public void CFRelease(@NotNull Pointer var1);

        public long CFArrayGetCount(@NotNull Pointer var1);

        @NotNull
        public Pointer CFArrayGetValueAtIndex(@NotNull Pointer var1, long var2);

        @Nullable
        public Pointer CFDictionaryGetValue(@NotNull Pointer var1, @NotNull Pointer var2);

        @NotNull
        public Pointer CFStringCreateWithCharacters(@Nullable Pointer var1, @NotNull char[] var2, long var3);

        public long CFStringCompare(@NotNull Pointer var1, @NotNull Pointer var2, long var3);

        public long CFStringGetLength(@NotNull Pointer var1);

        public void CFStringGetCharacters(@NotNull Pointer var1, @NotNull CFRange var2, @NotNull char[] var3);

        public short CFBooleanGetValue(@NotNull Pointer var1);
    }
}

