/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.navbar.backend.split;

import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.platform.navbar.backend.NavBarItem;
import com.intellij.platform.navbar.backend.impl.DefaultNavBarItem;
import com.jetbrains.codeWithMe.model.NavBarElementModel;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 !2\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\rJ$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\r2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u0016\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\rJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\nJ\u001c\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u001e\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/intellij/platform/navbar/backend/split/BackendNavigationBarHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "<init>", "()V", "nextId", "Ljava/util/concurrent/atomic/AtomicLong;", "lifetimeIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "dataMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lkotlin/Pair;", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/intellij/platform/navbar/backend/NavBarItem;", "modelMap", "", "", "Lcom/jetbrains/codeWithMe/model/NavBarElementModel;", "sequentialLifetimes", "", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "[Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "putItem", "lifetime", "item", "putModel", "", "model", "getModel", "getData", "nodeId", "get", "nextLifetime", "Companion", "intellij.platform.navbar.backend.split"})
public final class BackendNavigationBarHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicLong nextId = new AtomicLong();
    @NotNull
    private final AtomicInteger lifetimeIndex = new AtomicInteger();
    @NotNull
    private final ConcurrentHashMap<Long, Pair<Lifetime, NavBarItem>> dataMap = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<Object, List<NavBarElementModel>> modelMap = new ConcurrentHashMap();
    @NotNull
    private final SequentialLifetimes[] sequentialLifetimes;
    private static final int LIFETIMES_COUNT = 4;

    public BackendNavigationBarHost() {
        int n = 0;
        SequentialLifetimes[] sequentialLifetimesArray = new SequentialLifetimes[4];
        BackendNavigationBarHost backendNavigationBarHost = this;
        while (n < 4) {
            int n2 = n++;
            sequentialLifetimesArray[n2] = new SequentialLifetimes(Lifetime.Companion.getEternal());
        }
        backendNavigationBarHost.sequentialLifetimes = sequentialLifetimesArray;
    }

    public final long putItem(@NotNull Lifetime lifetime, @NotNull NavBarItem item) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        long nodeId = this.nextId.incrementAndGet();
        CollectionExKt.put((Map)this.dataMap, (Lifetime)lifetime, (Object)nodeId, (Object)TuplesKt.to((Object)lifetime, (Object)item));
        return nodeId;
    }

    public final void putModel(@NotNull Lifetime lifetime, @NotNull NavBarItem item, @NotNull List<NavBarElementModel> model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        Object object = item instanceof DefaultNavBarItem ? (DefaultNavBarItem)item : null;
        if (object == null || (object = object.getData()) == null) {
            return;
        }
        Object data = object;
        CollectionExKt.put((Map)this.modelMap, (Lifetime)lifetime, (Object)data, model);
    }

    @Nullable
    public final List<NavBarElementModel> getModel(@NotNull NavBarItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Object object = item instanceof DefaultNavBarItem ? (DefaultNavBarItem)item : null;
        if (object == null || (object = object.getData()) == null) {
            return null;
        }
        Object data = object;
        return this.modelMap.get(data);
    }

    @Nullable
    public final Object getData(long nodeId) {
        Pair<Lifetime, NavBarItem> pair = this.dataMap.get(nodeId);
        NavBarItem navBarItem = pair != null ? (NavBarItem)pair.getSecond() : null;
        DefaultNavBarItem defaultNavBarItem = navBarItem instanceof DefaultNavBarItem ? (DefaultNavBarItem)navBarItem : null;
        return defaultNavBarItem != null ? defaultNavBarItem.getData() : null;
    }

    @Nullable
    public final Pair<Lifetime, NavBarItem> get(long nodeId) {
        return this.dataMap.get(nodeId);
    }

    @NotNull
    public final Lifetime nextLifetime() {
        int index = this.lifetimeIndex.updateAndGet(BackendNavigationBarHost::nextLifetime$lambda$0);
        if (!(0 <= index ? index < 4 : false)) {
            throw new IllegalStateException("Check failed.");
        }
        return (Lifetime)this.sequentialLifetimes[index].next();
    }

    private static final int nextLifetime$lambda$0(int it) {
        return (it + 1) % 4;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/platform/navbar/backend/split/BackendNavigationBarHost$Companion;", "", "<init>", "()V", "LIFETIMES_COUNT", "", "getInstance", "Lcom/intellij/platform/navbar/backend/split/BackendNavigationBarHost;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "intellij.platform.navbar.backend.split"})
    @SourceDebugExtension(value={"SMAP\nBackendNavigationBarHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNavigationBarHost.kt\ncom/intellij/platform/navbar/backend/split/BackendNavigationBarHost$Companion\n+ 2 Components.kt\ncom/jetbrains/rd/platform/util/ComponentsKt\n*L\n1#1,153:1\n23#2:154\n*S KotlinDebug\n*F\n+ 1 BackendNavigationBarHost.kt\ncom/intellij/platform/navbar/backend/split/BackendNavigationBarHost$Companion\n*L\n69#1:154\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendNavigationBarHost getInstance(@NotNull ClientProjectSession session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            ClientSession $this$service$iv = (ClientSession)session;
            boolean $i$f$service = false;
            Object object = $this$service$iv.getService(BackendNavigationBarHost.class);
            if (object == null) {
                throw new IllegalStateException(("Can't find service for " + $this$service$iv).toString());
            }
            return (BackendNavigationBarHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

