/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.text.StringUtil;
import java.text.ParseException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u001a\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\b\u001a\u0016\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/run/ui/grid/editors/ValueParserWrapper;", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "parser", "Lcom/intellij/database/run/ui/grid/editors/Formatter;", "nullable", "", "emptyValue", "Lcom/intellij/database/run/ReservedCellValue;", "unparsedValueCreator", "Lkotlin/Function2;", "", "Lcom/intellij/database/run/ui/grid/editors/UnparsedValue$ParsingError;", "Lcom/intellij/database/run/ui/grid/editors/UnparsedValue;", "<init>", "(Lcom/intellij/database/run/ui/grid/editors/Formatter;ZLcom/intellij/database/run/ReservedCellValue;Lkotlin/jvm/functions/Function2;)V", "parse", "", "text", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.grid.impl"})
@SourceDebugExtension(value={"SMAP\nValueParserWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ValueParserWrapper.kt\ncom/intellij/database/run/ui/grid/editors/ValueParserWrapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class ValueParserWrapper
implements GridCellEditorFactory.ValueParser {
    @NotNull
    private final Formatter parser;
    private final boolean nullable;
    @Nullable
    private final ReservedCellValue emptyValue;
    @NotNull
    private final Function2<String, UnparsedValue.ParsingError, UnparsedValue> unparsedValueCreator;

    public ValueParserWrapper(@NotNull Formatter parser, boolean nullable, @Nullable ReservedCellValue emptyValue, @NotNull Function2<? super String, ? super UnparsedValue.ParsingError, ? extends UnparsedValue> unparsedValueCreator) {
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter(unparsedValueCreator, (String)"unparsedValueCreator");
        this.parser = parser;
        this.nullable = nullable;
        this.emptyValue = emptyValue;
        this.unparsedValueCreator = unparsedValueCreator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object parse(@NotNull String text, @Nullable Document document) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.emptyValue != null && StringUtil.isEmptyOrSpaces((String)text)) {
            return this.emptyValue;
        }
        if (this.nullable && StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"null") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"<null>")) {
            return ReservedCellValue.NULL;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"default") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"<default>")) {
            return ReservedCellValue.DEFAULT;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"generated") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"<generated>")) {
            return ReservedCellValue.GENERATED;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"computed") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"<computed>")) {
            return ReservedCellValue.COMPUTED;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"unset") || StringUtil.equalsIgnoreCase((CharSequence)text, (CharSequence)"<unset>")) {
            return ReservedCellValue.COMPUTED;
        }
        try {
            Object object = this.parser.parse(text);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(...)");
            return object;
        }
        catch (ParseException e) {
            void it;
            Integer n = e.getErrorOffset();
            int n2 = ((Number)n).intValue();
            String string = e.getLocalizedMessage();
            String string2 = text;
            Function2<String, UnparsedValue.ParsingError, UnparsedValue> function2 = this.unparsedValueCreator;
            boolean bl = false;
            boolean bl2 = it != -1;
            Integer n3 = bl2 ? n : null;
            int n4 = n3 != null ? n3 : 0;
            String string3 = string;
            return function2.invoke((Object)string2, (Object)new UnparsedValue.ParsingError(string3, n4));
        }
    }
}

