/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.py.debugger.JupyterPositionConverter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterEditorSourcePosition;", "Lcom/intellij/xdebugger/XSourcePosition;", "position", "<init>", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "lineStartOffset", "", "getLineStartOffset", "()I", "lineStartOffset$delegate", "Lkotlin/Lazy;", "getLine", "getOffset", "getFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "createNavigatable", "Lcom/intellij/pom/Navigatable;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.jupyter.py"})
public final class JupyterEditorSourcePosition
implements XSourcePosition {
    @NotNull
    private final XSourcePosition position;
    @NotNull
    private final Lazy lineStartOffset$delegate;

    public JupyterEditorSourcePosition(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.position = position;
        this.lineStartOffset$delegate = LazyKt.lazy(() -> JupyterEditorSourcePosition.lineStartOffset_delegate$lambda$1(this));
    }

    @NotNull
    public final XSourcePosition getPosition() {
        return this.position;
    }

    private final int getLineStartOffset() {
        Lazy lazy = this.lineStartOffset$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int getLine() {
        return this.position.getLine();
    }

    public int getOffset() {
        return this.getLineStartOffset();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return virtualFile;
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Navigatable navigatable = XDebuggerUtilImpl.createNavigatable((Project)project, (XSourcePosition)this);
        Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
        return navigatable;
    }

    private static final Integer lineStartOffset_delegate$lambda$1$lambda$0(JupyterEditorSourcePosition this$0) {
        VirtualFile virtualFile = this$0.position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        return JupyterPositionConverter.Companion.getJupyterLineStartOffset(virtualFile, this$0.position.getLine());
    }

    private static final int lineStartOffset_delegate$lambda$1(JupyterEditorSourcePosition this$0) {
        Integer n = (Integer)ReadAction.compute(() -> JupyterEditorSourcePosition.lineStartOffset_delegate$lambda$1$lambda$0(this$0));
        return n != null ? n.intValue() : this$0.position.getOffset();
    }
}

