/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.extensions.JupyterPsiCellExt;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionInterruptService;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterDebugSessionManager;
import com.intellij.jupyter.core.jupyter.debugger.common.JupyterSessionPath;
import com.intellij.jupyter.py.debugger.JupyterDebugProcess;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterDebugProcessHandler;", "Lcom/intellij/execution/process/ProcessHandler;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugSession;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "destroyProcessImpl", "", "detachProcessImpl", "detachIsDefault", "", "getProcessInput", "Ljava/io/OutputStream;", "intellij.jupyter.py"})
public final class JupyterDebugProcessHandler
extends ProcessHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final XDebugSession session;

    public JupyterDebugProcessHandler(@NotNull Project project, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.project = project;
        this.session = session;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    protected void destroyProcessImpl() {
        XDebugProcess xDebugProcess = this.session.getDebugProcess();
        Pair<JupyterPsiCell, NotebookIntervalPointer> debugProcess = xDebugProcess instanceof JupyterDebugProcess ? (Pair<JupyterPsiCell, NotebookIntervalPointer>)xDebugProcess : null;
        Pair<JupyterPsiCell, NotebookIntervalPointer> pair = debugProcess;
        if (pair == null || (pair = pair.getLatestExecutedCell()) == null) {
            return;
        }
        JupyterPsiCell jupyterCell = (JupyterPsiCell)pair.component1();
        ApplicationManager.getApplication().runReadAction(() -> JupyterDebugProcessHandler.destroyProcessImpl$lambda$0(jupyterCell, this));
        debugProcess.printToConsole(JupyterBundle.message((String)"debugger.disconnected", (Object[])new Object[0]) + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    protected void detachProcessImpl() {
        this.destroyProcessImpl();
    }

    public boolean detachIsDefault() {
        return false;
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    private static final void destroyProcessImpl$lambda$0(JupyterPsiCell $jupyterCell, JupyterDebugProcessHandler this$0) {
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterPsiCellExt.INSTANCE.getJupyterBackedVirtualFile($jupyterCell);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile notebookVirtualFile = backedNotebookVirtualFile;
        String sessionPath = JupyterSessionPath.constructor-impl((BackedNotebookVirtualFile)notebookVirtualFile);
        if (JupyterDebugSessionManager.Companion.getInstance(this$0.project).isSessionUnderDebug-MgfaZcY(sessionPath)) {
            try {
                JupyterExecutionInterruptService.Companion.getInstance(this$0.project).interruptJupyterKernel(notebookVirtualFile);
            }
            catch (Exception e) {
                JupyterDebugProcess.Companion.getLOG().warn(e.getMessage());
                this$0.session.stop();
            }
        }
        this$0.notifyProcessTerminated(0);
        JupyterDebugSessionManager.Companion.getInstance(this$0.project).debugInSessionFinished-MgfaZcY(sessionPath);
    }
}

