/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.CompressedRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.api.printer.GraphColorGetter;
import com.intellij.vcs.log.graph.collapsing.CollapsedController;
import com.intellij.vcs.log.graph.impl.facade.BaseController;
import com.intellij.vcs.log.graph.impl.facade.SimpleGraphInfo;
import com.intellij.vcs.log.graph.impl.facade.VisibleGraphImpl;
import com.intellij.vcs.log.graph.impl.print.GraphColorGetterByHeadFactory;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.VisiblePack;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class SnapshotVisiblePackBuilder {
    private static final int VISIBLE_RANGE = 1000;
    @NotNull
    private final VcsLogStorage myStorage;

    SnapshotVisiblePackBuilder(@NotNull VcsLogStorage storage) {
        if (storage == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(0);
        }
        this.myStorage = storage;
    }

    @NotNull
    public VisiblePack build(@NotNull VisiblePack visiblePack) {
        DataPackBase dataPack;
        if (visiblePack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(1);
        }
        if ((dataPack = visiblePack.getDataPack()) instanceof DataPack.ErrorDataPack) {
            VisiblePack visiblePack2 = visiblePack;
            if (visiblePack2 == null) {
                SnapshotVisiblePackBuilder.$$$reportNull$$$0(2);
            }
            return visiblePack2;
        }
        if (visiblePack.getVisibleGraph().getVisibleCommitCount() == 0 || !(visiblePack.getVisibleGraph() instanceof VisibleGraphImpl)) {
            DataPackBase newDataPack = new DataPackBase(dataPack.getLogProviders(), RefsModel.createEmptyInstance(this.myStorage), false);
            if (visiblePack instanceof VisiblePack.ErrorVisiblePack) {
                return new VisiblePack.ErrorVisiblePack(newDataPack, visiblePack.getFilters(), ((VisiblePack.ErrorVisiblePack)visiblePack).getError());
            }
            return new VisiblePack(newDataPack, EmptyVisibleGraph.getInstance(), true, visiblePack.getFilters());
        }
        return this.build(dataPack, (VisibleGraphImpl)visiblePack.getVisibleGraph(), visiblePack.getFilters(), visiblePack.getAdditionalData());
    }

    @NotNull
    private VisiblePack build(@NotNull DataPackBase oldPack, @NotNull VisibleGraphImpl<Integer> oldGraph, @NotNull VcsLogFilterCollection filters, @NotNull Map<Key, Object> data) {
        if (oldPack == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(3);
        }
        if (oldGraph == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(4);
        }
        if (filters == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(5);
        }
        if (data == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(6);
        }
        int visibleRow = 1000;
        int visibleRange = 1000;
        SimpleGraphInfo<Integer> info = oldGraph.buildSimpleGraphInfo(visibleRow, visibleRange);
        Set heads = ContainerUtil.map2Set(info.getPermanentGraphLayout().getHeadNodeIndex(), integer -> (Integer)info.getPermanentCommitsInfo().getCommitId((int)integer));
        RefsModel newRefsModel = this.createRefsModel(oldPack.getRefsModel(), heads, oldGraph, oldPack.getLogProviders(), visibleRow, visibleRange);
        DataPackBase newPack = new DataPackBase(oldPack.getLogProviders(), newRefsModel, false);
        GraphColorGetter colorGetter = new GraphColorGetterByHeadFactory<Integer>(new GraphColorManagerImpl(newRefsModel)).createColorGetter(info);
        VisibleGraphImpl<Integer> newGraph = new VisibleGraphImpl<Integer>(new CollapsedController(new BaseController(info), info, null), info, colorGetter);
        return new VisiblePack(newPack, newGraph, true, filters, data);
    }

    private RefsModel createRefsModel(@NotNull RefsModel refsModel, @NotNull Set<Integer> heads, @NotNull VisibleGraphImpl<Integer> visibleGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, int visibleRow, int visibleRange) {
        if (refsModel == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(7);
        }
        if (heads == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(8);
        }
        if (visibleGraph == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(9);
        }
        if (providers == null) {
            SnapshotVisiblePackBuilder.$$$reportNull$$$0(10);
        }
        HashSet branchesAndHeads = new HashSet();
        for (int row = Math.max(0, visibleRow - visibleRange); row < Math.min(visibleGraph.getLinearGraph().nodesCount(), visibleRow + visibleRange); ++row) {
            Integer commit = (Integer)visibleGraph.getRowInfo(row).getCommit();
            refsModel.refsToCommit(commit).forEach(ref -> {
                if (ref.getType().isBranch() || heads.contains(commit)) {
                    branchesAndHeads.add(ref);
                }
            });
        }
        Map<VirtualFile, Set<VcsRef>> map = VcsLogUtil.groupRefsByRoot(branchesAndHeads);
        HashMap<VirtualFile, CompressedRefs> refs = new HashMap<VirtualFile, CompressedRefs>();
        Iterator<VirtualFile> iterator = providers.keySet().iterator();
        while (iterator.hasNext()) {
            VirtualFile root;
            HashSet<VcsRef> refsForRoot = map.get(root = iterator.next());
            refs.put(root, new CompressedRefs(refsForRoot == null ? new HashSet<VcsRef>() : refsForRoot, this.myStorage));
        }
        return RefsModel.create(refs, heads, this.myStorage, providers);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visiblePack";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldPack";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldGraph";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refsModel";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "heads";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibleGraph";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "providers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/SnapshotVisiblePackBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRefsModel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

