/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsShowSettingOption;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.OptionsDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.idea.svn.SvnBundle;

public class LockDialog
extends OptionsDialog {
    private JTextArea myLockTextArea;
    private JCheckBox myForceCheckBox;
    @NonNls
    private static final String HELP_ID = "reference.VCS.subversion.lockFile";
    private final VcsShowSettingOption myOption;

    public LockDialog(Project project, boolean canBeParent, boolean multiple, @NonNls VcsShowSettingOption option) {
        super(project, canBeParent);
        this.myOption = option;
        this.setTitle(multiple ? SvnBundle.message("dialog.title.lock.files", new Object[0]) : SvnBundle.message("dialog.title.lock.file", new Object[0]));
        this.setResizable(true);
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected String getHelpId() {
        return HELP_ID;
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public String getComment() {
        return this.myLockTextArea.getText();
    }

    public boolean isForce() {
        return this.myForceCheckBox.isSelected();
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = JBUI.insets((int)2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        JLabel commentLabel = new JLabel(SvnBundle.message("label.lock.comment", new Object[0]));
        panel2.add((Component)commentLabel, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.myLockTextArea = new JTextArea(7, 25);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myLockTextArea, (int)22, (int)30);
        scrollPane.setMinimumSize(scrollPane.getPreferredSize());
        panel2.add((Component)scrollPane, gc);
        commentLabel.setLabelFor(this.myLockTextArea);
        ++gc.gridy;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.fill = 0;
        this.myForceCheckBox = new JCheckBox(SvnBundle.message("label.locl.steal.existing", new Object[0]));
        panel2.add((Component)this.myForceCheckBox, gc);
        ++gc.gridy;
        gc.weightx = 1.0;
        gc.fill = 2;
        panel2.add((Component)new JSeparator(), gc);
        return panel2;
    }

    protected String getDimensionServiceKey() {
        return "svn.lockDialog";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myLockTextArea;
    }

    protected boolean isToBeShown() {
        return true;
    }

    protected void setToBeShown(boolean value, boolean onOk) {
        this.myOption.setValue(value);
    }

    protected boolean shouldSaveOptionsOnCancel() {
        return false;
    }
}

