/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.launching;

import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.launching.InputRedirection;
import com.install4j.runtime.installer.helper.launching.OutputRedirection;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;

public class LaunchDescriptor
implements Serializable {
    private File executable;
    private File workingDirectory;
    private String[] arguments;
    private boolean includeParentEnvironmentVariables = true;
    private Map specificEnvironmentVariables;
    private boolean showWindowsConsole = false;
    private boolean keepConsoleWindow = false;
    private boolean useNohup = false;
    private OutputRedirection stdoutRedirection;
    private OutputRedirection stderrRedirection;
    private InputRedirection stdinRedirection;
    private boolean wait = false;
    private boolean waitForStreams = false;
    private int timeout = 0;
    private Process process;
    private boolean receiveProcess = false;
    private boolean suidRoot;
    private ExecutionContext executionContext = ExecutionContext.SAME;

    public LaunchDescriptor(File file) {
        this.executable = file;
    }

    public File getExecutable() {
        return this.executable;
    }

    public LaunchDescriptor executable(File file) {
        this.executable = file;
        return this;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public LaunchDescriptor workingDirectory(File file) {
        this.workingDirectory = this.replaceEmpty(file);
        return this;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public LaunchDescriptor arguments(String[] stringArray) {
        if (stringArray != null && (stringArray.length == 0 || stringArray.length == 1 && (stringArray[0] == null || stringArray[0].length() == 0))) {
            stringArray = null;
        }
        this.arguments = stringArray;
        return this;
    }

    public LaunchDescriptor suidRoot(boolean bl) {
        this.suidRoot = bl;
        return this;
    }

    public boolean isSuidRoot() {
        return this.suidRoot;
    }

    public boolean isUseNohup() {
        return this.useNohup;
    }

    public LaunchDescriptor useNohup(boolean bl) {
        this.useNohup = bl;
        return this;
    }

    public boolean isIncludeParentEnvironmentVariables() {
        return this.includeParentEnvironmentVariables;
    }

    public LaunchDescriptor includeParentEnvironmentVariables(boolean bl) {
        this.includeParentEnvironmentVariables = bl;
        return this;
    }

    public Map getSpecificEnvironmentVariables() {
        return this.specificEnvironmentVariables;
    }

    public LaunchDescriptor specificEnvironmentVariables(Map map) {
        this.specificEnvironmentVariables = map;
        return this;
    }

    public boolean isShowWindowsConsole() {
        return this.showWindowsConsole;
    }

    public LaunchDescriptor showWindowsConsole(boolean bl) {
        this.showWindowsConsole = bl;
        return this;
    }

    public boolean isKeepConsoleWindow() {
        return this.keepConsoleWindow;
    }

    public LaunchDescriptor keepConsoleWindow(boolean bl) {
        this.keepConsoleWindow = bl;
        return this;
    }

    public OutputRedirection getStdoutRedirection() {
        return this.stdoutRedirection;
    }

    public LaunchDescriptor stdoutRedirection(OutputRedirection outputRedirection) {
        this.stdoutRedirection = outputRedirection;
        return this;
    }

    public OutputRedirection getStderrRedirection() {
        return this.stderrRedirection;
    }

    public LaunchDescriptor stderrRedirection(OutputRedirection outputRedirection) {
        this.stderrRedirection = outputRedirection;
        return this;
    }

    public InputRedirection getStdinRedirection() {
        return this.stdinRedirection;
    }

    public LaunchDescriptor stdinRedirection(InputRedirection inputRedirection) {
        this.stdinRedirection = inputRedirection;
        return this;
    }

    private File replaceEmpty(File file) {
        if (file != null && file.getPath().length() == 0) {
            return null;
        }
        return file;
    }

    public boolean isWait() {
        return this.wait;
    }

    public LaunchDescriptor wait(boolean bl) {
        this.wait = bl;
        return this;
    }

    public boolean isWaitForStreams() {
        return this.waitForStreams;
    }

    public LaunchDescriptor waitForStreams(boolean bl) {
        this.waitForStreams = bl;
        return this;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public LaunchDescriptor timeout(int n) {
        this.timeout = n;
        return this;
    }

    public Process getProcess() {
        return this.process;
    }

    public void setProcess(Process process) {
        this.process = process;
    }

    public boolean isReceiveProcess() {
        return this.receiveProcess;
    }

    public LaunchDescriptor receiveProcess(boolean bl) {
        this.receiveProcess = bl;
        return this;
    }

    public String toString() {
        return "LaunchDescriptor{executable=" + this.executable + ", workingDirectory=" + this.workingDirectory + ", arguments=" + (this.arguments == null ? null : Arrays.asList(this.arguments)) + ", suidRoot=" + this.suidRoot + ", includeParentEnvironmentVariables=" + this.includeParentEnvironmentVariables + ", specificEnvironmentVariables=" + this.specificEnvironmentVariables + ", showWindowsConsole=" + this.showWindowsConsole + ", keepConsoleWindow=" + this.keepConsoleWindow + ", useNohup=" + this.useNohup + ", stdoutRedirection=" + this.stdoutRedirection + ", stderrRedirection=" + this.stderrRedirection + ", stdinRedirection=" + this.stdinRedirection + ", wait=" + this.wait + ", process=" + this.process + ", receiveProcess=" + this.receiveProcess + ", executionContext=" + this.executionContext + '}';
    }

    public LaunchDescriptor executionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
        return this;
    }

    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }
}

