/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.exe4j.runtime.util.FileUtil;
import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.FileOptions;
import com.install4j.api.context.OverwriteMode;
import com.install4j.api.context.UninstallMode;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.platform.win32.ShellLink;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class MenuHelper {
    public static void installWindowsMenu(ExecutionContext executionContext, File file, File file2, File file3) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(executionContext, file, file2, file3, null, false, null);
    }

    public static void installWindowsMenu(ExecutionContext executionContext, File file, File file2, File file3, String string, boolean bl, String string2) throws IOException, UserCanceledException {
        MenuHelper.installWindowsMenu(executionContext, file, file2, file3, string, bl, string2, null);
    }

    public static void installWindowsMenu(ExecutionContext executionContext, final File file, final File file2, final File file3, final String string, final boolean bl, final String string2, final File file4) throws IOException, UserCanceledException {
        HelperCommunication.getInstance().executeActionChecked(executionContext, new RunAction(){

            protected void run(Context context) throws Exception {
                MenuHelper.createWindowsMenuInt(file, file2, file3, string, bl, string2, file4);
            }
        });
    }

    private static void createWindowsMenuInt(File file, File file2, File file3, String string, boolean bl, String string2, File file4) throws IOException, UserCanceledException {
        if (!file2.exists()) {
            return;
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        if (file2.getName().endsWith(".url")) {
            File file5 = new File(file.getAbsolutePath() + ".url");
            if (file3 != null) {
                File file6 = File.createTempFile("i4j", ".url");
                if (FileUtil.copyFile(file2, file6)) {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file6, true));
                    bufferedWriter.newLine();
                    bufferedWriter.write("IconIndex=0");
                    bufferedWriter.newLine();
                    bufferedWriter.write("IconFile=" + file3);
                    bufferedWriter.close();
                    FileInstaller.getInstance().install(file6, file5, new FileOptions(file2.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                }
                file6.delete();
            } else {
                FileInstaller.getInstance().install(file2, file5, new FileOptions(file2.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
            }
            ShellLink.changeNotify(file5);
        } else {
            File file7 = new File(file.getAbsolutePath() + ".lnk");
            File file8 = new File(file.getAbsolutePath() + ".pif");
            File file9 = File.createTempFile("i4j", ".lnk");
            File file10 = new File(file9.getAbsolutePath().substring(0, file9.getAbsolutePath().length() - 3) + "pif");
            ShellLink.create(file9, file2, file3, string, bl, string2, file4);
            if (file9.exists()) {
                FileInstaller.getInstance().install(file9, file7, new FileOptions(file9.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                file8.delete();
            } else if (file10.exists()) {
                FileInstaller.getInstance().install(file10, file8, new FileOptions(file10.lastModified(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
                file7.delete();
            }
            file9.delete();
            file10.delete();
            ShellLink.changeNotify(file7);
        }
    }

    public static File installUnixDesktopFile(File file, File file2, File file3, String string, String string2, String string3) throws IOException, UserCanceledException {
        if (file3 == null || !file3.exists()) {
            return null;
        }
        File file4 = new File(file2, string + ".desktop");
        File file5 = File.createTempFile("i4j", null);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file5));
        printWriter.println("#!/usr/bin/env xdg-open");
        printWriter.println("[Desktop Entry]");
        printWriter.println("Type=Application");
        printWriter.println("Name=" + string);
        printWriter.println("Exec=/bin/sh \"" + file3.getAbsolutePath() + "\"" + (string3 == null ? "" : " " + string3));
        File file6 = new File(file, ".install4j/" + file3.getName() + ".png");
        if (file6.exists()) {
            printWriter.println("Icon=" + file6.getAbsolutePath());
        }
        if (string2 != null) {
            printWriter.println("Categories=" + string2 + (!string2.trim().endsWith(";") ? ";" : ""));
        }
        printWriter.close();
        FileInstaller.getInstance().install(file5, file4, new FileOptions(new Date().getTime(), "755", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
        file5.delete();
        return file4;
    }

    public static void installUnixMenu(File file, File file2, String string, String string2, String string3) throws IOException, UserCanceledException {
        File file3;
        File file4 = MenuHelper.installUnixDesktopFile(file, file, file2, string, string2, string3);
        if (file4 != null && !file2.getCanonicalPath().equals(new File(file, InstallerConfig.getCurrentInstance().getUninstallerPath()).getCanonicalPath()) && (file3 = MenuHelper.getMenuFile(string)) != null) {
            FileInstaller.getInstance().install(file4, file3, new FileOptions(new Date().getTime(), "644", OverwriteMode.ALWAYS, false, UninstallMode.ALWAYS));
        }
    }

    public static File getMenuFile(String string) {
        File[] fileArray = new File[]{new File("/usr/share/applications"), new File("/usr/local/share/applications"), new File(Util.getUserHome(), ".local/share/applications")};
        for (int i = 0; i < fileArray.length; ++i) {
            File file;
            File file2 = fileArray[i];
            File file3 = file2.getParentFile();
            if (!file2.getPath().startsWith("/usr") && !file2.exists() && file3.exists()) {
                file2.mkdir();
            }
            if ((file = MenuHelper.createMenuFile(string, file2)) == null) continue;
            return file;
        }
        return null;
    }

    private static File createMenuFile(String string, File file) {
        File file2 = null;
        if (file.canWrite()) {
            int n = 0;
            do {
                file2 = new File(file, string + "-" + n + ".desktop");
                ++n;
            } while (file2.exists() && !FileInstaller.getInstance().wasPreviouslyCreated(file2));
        }
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createUrlLink(File file, String string, File file2, boolean bl) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileOutputStream(file));
            printWriter.println("[InternetShortcut]");
            printWriter.print("URL=");
            printWriter.println(string);
            if (bl) {
                try {
                    URL uRL = new URL(string);
                    printWriter.print("IconFile=");
                    printWriter.print(uRL.getProtocol());
                    printWriter.print("://");
                    printWriter.print(uRL.getHost());
                    printWriter.println("/favicon.ico");
                    printWriter.println("IconIndex=1");
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            } else if (file2 != null) {
                printWriter.print("IconFile=");
                printWriter.println(file2.getPath());
                printWriter.println("IconIndex=0");
                printWriter.println("HotKey=0");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    public static void installUrlLink(ExecutionContext executionContext, String string, File file, File file2, boolean bl) throws IOException, UserCanceledException {
        File file3 = File.createTempFile("i4j", ".url");
        MenuHelper.createUrlLink(file3, string, file2, bl);
        MenuHelper.installWindowsMenu(executionContext, file, file3, null, null, false, null);
        file3.delete();
    }
}

