/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer;

import com.install4j.runtime.beans.applications.ExecutionMode;
import com.install4j.runtime.installer.InstallerVariables;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.controller.Controller;
import com.install4j.runtime.installer.controller.ScreenExecutor;
import com.install4j.runtime.installer.frontend.InstallerWizardScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.InstallerConsoleScreenExecutor;
import com.install4j.runtime.installer.frontend.headless.InstallerUnattendedScreenExecutor;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.versionspecific.VersionSpecificHelper;
import com.install4j.runtime.launcher.Launcher;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public class Installer {
    private Installer() {
    }

    public static void main(String[] stringArray) {
        if (!HelperCommunication.executeAsHelper(stringArray)) {
            try {
                InstallerUtil.setInProcess(false);
                Installer.runInProcess(stringArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                InstallerUtil.reportException(throwable);
                System.exit(1);
            }
        }
    }

    private static void runInProcess(String[] stringArray) {
        InstallerConfig.setCurrentApplicationId("installer");
        ScreenExecutor screenExecutor = Installer.getScreenExecutor(stringArray, false, null);
        new Controller(screenExecutor).start();
    }

    static ScreenExecutor getScreenExecutor(String[] stringArray, final boolean bl, final Window window) {
        ScreenExecutor screenExecutor;
        ExecutionMode executionMode;
        InstallerUtil.CommandLineOptions commandLineOptions = InstallerUtil.parseCommandLine(stringArray);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        if (commandLineOptions.installDir != null) {
            if (!commandLineOptions.installDir.isAbsolute()) {
                System.err.println("The installation directory must be absolute. Aborting.");
                System.exit(1);
            }
            installerConfig.setInstallationDirectory(commandLineOptions.installDir);
            InstallerVariables.setInstallationDirectoryFromCommandLine(true);
        }
        if ((executionMode = InstallerUtil.getExecutionMode(commandLineOptions, false)) == ExecutionMode.GUI && !InstallerUtil.isInProcess()) {
            Launcher.showDelayedSlashScreen();
        }
        VersionSpecificHelper.initUncaughtExceptionHandler();
        if (executionMode == ExecutionMode.UNATTENDED || executionMode == ExecutionMode.UNATTENDED_WITH_PROGRESS) {
            screenExecutor = new InstallerUnattendedScreenExecutor(commandLineOptions.quietOverwrite, commandLineOptions.wait, InstallerUtil.getSplash(commandLineOptions, executionMode), bl, window);
        } else if (executionMode == ExecutionMode.CONSOLE) {
            screenExecutor = new InstallerConsoleScreenExecutor();
        } else {
            final ScreenExecutor[] screenExecutorArray = new ScreenExecutor[1];
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        screenExecutorArray[0] = new InstallerWizardScreenExecutor(bl, window);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            screenExecutor = screenExecutorArray[0];
        }
        InstallerVariables.initCommandLine(commandLineOptions.varFileName, commandLineOptions.commandLineVars);
        return screenExecutor;
    }
}

