/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.groups;

import com.install4j.api.Util;
import com.install4j.api.beans.Anchor;
import com.install4j.api.beans.ExternalFile;
import com.install4j.api.beans.ScriptProperty;
import com.install4j.api.formcomponents.AbstractFormComponent;
import com.install4j.api.formcomponents.GroupType;
import com.install4j.runtime.beans.groups.GroupOrientation;
import com.install4j.runtime.beans.groups.LayoutManagerGroup;
import com.install4j.runtime.installer.helper.Logger;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabGroup
extends LayoutManagerGroup {
    private static final Object TAB_ICON = "tabIcon";
    private String title = "";
    private ExternalFile iconFile;
    private ScriptProperty activationScript;
    private String tooltipText = "";
    private JTabbedPane tabbedPane;
    private JComponent tabComponent;
    private int lastIndex = -1;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public ExternalFile getIconFile() {
        return this.iconFile;
    }

    public void setIconFile(ExternalFile externalFile) {
        this.iconFile = externalFile;
    }

    public ScriptProperty getActivationScript() {
        return this.activationScript;
    }

    public void setActivationScript(ScriptProperty scriptProperty) {
        this.activationScript = scriptProperty;
    }

    public String getTooltipText() {
        return this.tooltipText;
    }

    public void setTooltipText(String string) {
        this.tooltipText = string;
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.insertTab(this.lastIndex);
            this.setEnabled(this.isEnabled());
        } else {
            int n = this.tabbedPane.indexOfComponent(this.tabComponent);
            if (n >= 0) {
                this.lastIndex = n;
                this.tabbedPane.removeTabAt(n);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        int n = this.tabbedPane.indexOfComponent(this.tabComponent);
        if (n >= 0) {
            this.tabbedPane.setEnabledAt(n, bl);
        }
    }

    protected int getDefaultCellSpacing() {
        return 0;
    }

    public GroupOrientation getGroupOrientation() {
        return GroupOrientation.VERTICAL;
    }

    public GroupType getGroupType() {
        return GroupType.SINGLE_TAB;
    }

    public Anchor getDefaultAnchor() {
        return Anchor.NORTHWEST;
    }

    public JComponent createComponent(JComponent jComponent) {
        Serializable serializable;
        this.tabComponent = super.createComponent(jComponent);
        if (this.iconFile != null && ((File)(serializable = this.getContext().getExternalFile(this.iconFile, false))).exists()) {
            try {
                this.tabComponent.putClientProperty(TAB_ICON, new ImageIcon(((File)serializable).getPath()));
            }
            catch (Exception exception) {
                Util.printAnnotatedStackTrace(exception);
                Logger.getInstance().log(exception);
            }
        }
        this.tabbedPane = (JTabbedPane)jComponent;
        this.insertTab(-1);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TabGroup.this.activationScript != null && TabGroup.this.tabbedPane.getSelectedComponent() == TabGroup.this.tabComponent) {
                    try {
                        TabGroup.this.getContext().runScript(TabGroup.this.activationScript, TabGroup.this, new Object[]{TabGroup.this.getFormEnvironment().getLayoutGroupById(TabGroup.this.getId()), TabGroup.this.getFormEnvironment()});
                    }
                    catch (Exception exception) {
                        Util.printAnnotatedStackTrace(exception);
                        Logger.getInstance().log(exception);
                    }
                }
            }
        });
        serializable = new JPanel(new GridBagLayout());
        ((JComponent)serializable).setOpaque(false);
        return serializable;
    }

    private void insertTab(int n) {
        if (this.isVisible()) {
            int n2 = this.tabbedPane.getComponentCount();
            int n3 = n < 0 ? n2 : Math.min(n, n2);
            String string = AbstractFormComponent.getTextWithoutMnemonics(this.title);
            this.tabbedPane.insertTab(string, (Icon)this.tabComponent.getClientProperty(TAB_ICON), this.tabComponent, this.tooltipText.length() > 0 ? this.tooltipText : null, n3);
            int n4 = AbstractFormComponent.getMnemonicCharIndex(this.title);
            if (n4 >= 0) {
                int n5 = string.charAt(n4);
                if (n5 >= 97 && n5 <= 122) {
                    n5 -= 32;
                }
                this.tabbedPane.setMnemonicAt(n3, n5);
                this.tabbedPane.setDisplayedMnemonicIndexAt(n3, n4);
            }
        }
    }

    protected Insets getDefaultInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void makeTabVisible() {
        this.tabbedPane.setSelectedComponent(this.tabComponent);
    }
}

