/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.formcomponents;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.screens.Console;
import com.install4j.runtime.beans.formcomponents.TextfieldComponent;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.InputVerifier;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.JTextComponent;

public abstract class FormattedTextfieldComponent
extends TextfieldComponent {
    protected JTextComponent createTextComponent() {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.updateFormatter(jFormattedTextField);
        this.applyTextFieldProperties(jFormattedTextField);
        return jFormattedTextField;
    }

    protected void initText(JTextComponent jTextComponent) {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)jTextComponent;
        this.updateFormatter(jFormattedTextField);
        super.initText(jTextComponent);
        if (jTextComponent.getText().length() > 0) {
            try {
                jFormattedTextField.commitEdit();
                jFormattedTextField.setValue(jFormattedTextField.getValue());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean checkCompleted() {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getTextComponent();
        try {
            jFormattedTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return super.checkCompleted();
    }

    protected abstract DefaultFormatter createFormatter();

    public Object[] createInputVerifierParameters() {
        return new Object[]{this.getFormEnvironment(), this.isInputValid(), this.getTextComponent().getText()};
    }

    private boolean isInputValid() {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getTextComponent();
        JFormattedTextField.AbstractFormatter abstractFormatter = jFormattedTextField.getFormatter();
        if (abstractFormatter != null) {
            try {
                abstractFormatter.stringToValue(jFormattedTextField.getText());
            }
            catch (ParseException parseException) {
                return false;
            }
        }
        return true;
    }

    protected Object getValue() {
        return ((JFormattedTextField)this.getTextComponent()).getValue();
    }

    public Class getConfigurationObjectClass() {
        return JFormattedTextField.class;
    }

    public boolean handleConsole(Console console) throws UserCanceledException {
        JFormattedTextField jFormattedTextField = (JFormattedTextField)this.getTextComponent();
        String string = jFormattedTextField.getText();
        Object object = jFormattedTextField.getValue();
        while (true) {
            jFormattedTextField.setText(string);
            jFormattedTextField.setValue(object);
            String string2 = console.askString(this.getConsoleLabelText(false) + this.getFormatDescription(), string == null ? null : string);
            jFormattedTextField.setText(string2);
            try {
                jFormattedTextField.commitEdit();
            }
            catch (ParseException parseException) {
                continue;
            }
            InputVerifier inputVerifier = jFormattedTextField.getInputVerifier();
            try {
                if (inputVerifier == null) {
                    return true;
                }
                if (!inputVerifier.verify(jFormattedTextField)) continue;
                jFormattedTextField.commitEdit();
                return true;
            }
            catch (ParseException parseException) {
                continue;
            }
            break;
        }
    }

    protected String getFormatDescription() {
        return "";
    }

    private void updateFormatter(JFormattedTextField jFormattedTextField) {
        jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(this.createFormatter()));
    }
}

